#!/bin/bash 

# wrapper script to batch-feed mn, mp and the p(n,g)d rate coefficients into bbn code

### config section ###
prefix="lqcd2_mnonly_"
endtime=1e6
inputfile="lqcdinput2_mnonly.dat" #input file containing a column used as label as well as a0-a7, mn and mp for the p(n,g)d reaction rate
variablelabel="Lambda_QCD(m_n only)" #just a label used in the final.dat file

rm $prefix*
n=0
while read line; do
  if [ ${line:0:1} != "#" ]; then #skip comment lines
    prefixn=$prefix$n"_"
    
    var=`echo $line | awk '{ print $1; }'`
    params=`echo $line | cut -f2- -d ' '`
    echo -e "\n$params\n$endtime\n$prefixn\n1\n" | ./bigbang_deuteron.out
    
    #copy header for first file
    if [ $n -eq 0 ]; then
      head -n 2 $prefixn'0002_z1.dat' > $prefix"final.dat"
      echo " * variable varied: $variablelabel" >> $prefix"final.dat"
      awk '{$1=$2="";print;}' $prefixn'0003_z1.dat'  | paste $prefixn'0002_z1.dat' - | sed '3q;d' >> $prefix"final.dat"
    fi
    
    result1=`tail -n 1 $prefixn'0002_z1.dat'`
    result2=`tail -n 1 $prefixn'0003_z1.dat' | awk '{$1=$2="";print;}' # | cut -f3-`
    echo $var" "$result1" "$result2 >> $prefix"final.dat"
    n=$((n+1))
  fi
done < $inputfile
