/*
 * ProtonDetectorData.hh
 *
 *  Created on: Dec 19, 2013
 *      Author: perezlou
 */

#ifndef PROTONDETECTORDATA_HH_
#define PROTONDETECTORDATA_HH_

#include "TROOT.h"

class ProtonDetectorData {

private:

	Double_t energyOnGas_beam;
	Double_t energyOnGas_protons;
	Double_t energyOnGas_betas;
	Double_t energyOnGas_alphas;
	Double_t energyOnGas_total;
	Double_t energyOnDegrader;
	Double_t energyOnVeto;
	Double_t energyOnVeto_protons;
	Double_t energyOnVeto_betas;
	Double_t stepSumLengthOnGas_beam;
	Double_t stepSumLengthOnGas_protons;
	Double_t stepSumLengthOnGas_betas;
	Double_t stepSumLengthOnGas_alphas;
	Double_t beam_last_positionX;
	Double_t beam_last_positionY;
	Double_t beam_last_positionZ;
	Double_t proton_last_positionX;
	Double_t proton_last_positionY;
	Double_t proton_last_positionZ;
	Double_t alpha_last_positionX;
	Double_t alpha_last_positionY;
	Double_t alpha_last_positionZ;
	Int_t eventID;
	Int_t runID;

public:
	ProtonDetectorData();
	~ProtonDetectorData();

	Double_t GetEnergyOnGas_beam(){return energyOnGas_beam;}
	Double_t GetEnergyOnGas_protons(){return energyOnGas_protons;}
	Double_t GetEnergyOnGas_betas(){return energyOnGas_betas;}
	Double_t GetEnergyOnGas_alphas(){return energyOnGas_alphas;}
	Double_t GetEnergyOnGas_total(){return energyOnGas_total;}
	Double_t GetEnergyOnDegrader(){return energyOnDegrader;}
	Double_t GetEnergyOnVeto(){return energyOnVeto;}
	Double_t GetEnergyOnVeto_protons(){return energyOnVeto_protons;}
	Double_t GetEnergyOnVeto_betas(){return energyOnVeto_betas;}
	Double_t GetStepSumLengthOnGas_beam(){return stepSumLengthOnGas_beam;}
	Double_t GetStepSumLengthOnGas_protons(){return stepSumLengthOnGas_protons;}
	Double_t GetStepSumLengthOnGas_betas(){return stepSumLengthOnGas_betas;}
	Double_t GetStepSumLengthOnGas_alphas(){return stepSumLengthOnGas_alphas;}
	Double_t GetBeamLastPositionX(){return beam_last_positionX;}
	Double_t GetBeamLastPositionY(){return beam_last_positionY;}
	Double_t GetBeamLastPositionZ(){return beam_last_positionZ;}
	Double_t GetProtonLastPositionX(){return proton_last_positionX;}
	Double_t GetProtonLastPositionY(){return proton_last_positionY;}
	Double_t GetProtonLastPositionZ(){return proton_last_positionZ;}
	Double_t GetAlphaLastPositionX(){return alpha_last_positionX;}
	Double_t GetAlphaLastPositionY(){return alpha_last_positionY;}
	Double_t GetAlphaLastPositionZ(){return alpha_last_positionZ;}
	Int_t GetEventID(){return eventID;}
	Int_t GetRunID(){return runID;}

	void SetEnergyOnGas_beam(Double_t val){energyOnGas_beam=val;}
	void SetEnergyOnGas_protons(Double_t val){energyOnGas_protons=val;}
	void SetEnergyOnGas_betas(Double_t val){energyOnGas_betas=val;}
	void SetEnergyOnGas_alphas(Double_t val){energyOnGas_alphas=val;}
	void SetEnergyOnGas_total(Double_t val){energyOnGas_total=val;}
	void SetEnergyOnDegrader(Double_t val){energyOnDegrader=val;}
	void SetEnergyOnVeto(Double_t val){ energyOnVeto=val;}
	void SetEnergyOnVeto_protons(Double_t val){ energyOnVeto_protons=val;}
	void SetEnergyOnVeto_betas(Double_t val){ energyOnVeto_betas=val;}
	void SetStepSumLengthOnGas_beam(Double_t val){  stepSumLengthOnGas_beam=val;}
	void SetStepSumLengthOnGas_protons(Double_t val){  stepSumLengthOnGas_protons=val;}
	void SetStepSumLengthOnGas_betas(Double_t val){  stepSumLengthOnGas_betas=val;}
	void SetStepSumLengthOnGas_alphas(Double_t val){  stepSumLengthOnGas_alphas=val;}
	void SetBeamLastPositionX(Double_t val){  beam_last_positionX=val;}
	void SetBeamLastPositionY(Double_t val){  beam_last_positionY=val;}
	void SetBeamLastPositionZ(Double_t val){  beam_last_positionZ=val;}
	void SetProtonLastPositionX(Double_t val){  proton_last_positionX=val;}
	void SetProtonLastPositionY(Double_t val){  proton_last_positionY=val;}
	void SetProtonLastPositionZ(Double_t val){  proton_last_positionZ=val;}
	void SetAlphaLastPositionX(Double_t val){  alpha_last_positionX=val;}
	void SetAlphaLastPositionY(Double_t val){  alpha_last_positionY=val;}
	void SetAlphaLastPositionZ(Double_t val){  alpha_last_positionZ=val;}
	void SetEventID(Int_t val){  eventID =val;}
	void SetRunID(Int_t val){  runID =val;}



ClassDef(ProtonDetectorData,1);
};

#endif /* PROTONDETECTORDATA_HH_ */
