//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
//
// $Id: MargotEventAction.hh,v 1.2 2007/02/14 17:44:45 roeder Exp $
// GEANT4 tag $Name: geant4-08-02 $
//
// Modifed by: Brian Roeder, LPC Caen 02/14/2007 for Margot
// email - roeder@lpccaen.in2p3.fr
 
#ifndef MargotEventAction_h
#define MargotEventAction_h 1

#include "globals.hh"
#include "G4UserEventAction.hh"
#include "G4THitsMap.hh"


#include "MargotDataRecordTree.hh"

class G4Event;

//
class MargotEventAction : public G4UserEventAction
{
  public:
    MargotEventAction();
   ~MargotEventAction();

  public:
    void BeginOfEventAction(const G4Event*);
    void EndOfEventAction(const G4Event*);

  private:
  G4int numberOfEvent;

  MargotDataRecordTree* MargotGetDataEV;
};



#endif

    
