Module UNEDF
  !=================================================================== 
  ! M.Kortelainen & M.Stoitsov, 2009-2010
  ! UNEDF interface for Skyrme, DME(LO,NLO,N2LO) and other DFT solvers 
  !=================================================================== 
  Implicit None
  !
  Character(16), Private :: Version='15'
  !
  ! Version History
  !-------------------------------------------------------------------
  ! ver#15:(Markus)  Added parameter CExPar, used in Coul. excange term.
  !                  Also, all the channels included in direct Hartree
  ! ver#14:(Markus)  Added function Vexternal for the external field,
  !                  and use_j2terms to switch off tensor terms. 
  !                  Direct Hartree set to zero.
  ! Ver#13:(Mario)   Added ac2,ac3,acoord
  ! ver#12:(Mario)   hartree term temprorary dropped. rDr NNN terms taken
  !                  with a factor of 1/2 
  ! ver#11:(Mario)   Gaussian approximation to the Hartree term added,
  ! [3/10/2010]      hatree_rc removed. NB! Function HartreeV is an
  !                  elemental function with possible array arguments
  ! ver#10: (Markus) Added e2charg (e^2 for Coulomb) to the public variables
  ! ver#9: (Mario)   Hartree 'CHrho' calculated in INM with rc='hatree_rc'
  ! [2/2/2010]       is subtracted from Crho(0)at DMEorder >= 0. 
  !                  CHrho added to the public list, 'hatree_rc' added
  !                  to interaction parameters and the namelist.   
  !                  In the case DMEorder=-1 (standard Skyrme) 
  !                  both, 'CHrho' and 'hatree_rc', do not play.
  !                  New function HartreeV(u) defines Hatree energy as
  !                  E(Hartree)=(1/2)*Int[rho_0(r)*V(|r-r'|)*rho_0(r')]
  !                  HartreeV(u) is zero for u=<'hatree_rc'
  ! ver#8: (Markus)  Hartree DME terms dropped out.
  ! ver#7: (Markus)  Added switch to turn off the 3N terms.
  !        (Mario)   Added Abs to density and gradient dependent LDA       
  !                  Public :: DMEorder,DMElda,use_DME3N_terms   
  ! ver#6: (Mario)   Skyrme transformation added.
  ! ver#5: (Mario)   Print_Namelist=T/F added to the namelist 
  ! ver#4: (Markus)  Added natural units to the module. Used only for printing.
  ! ver#3: (Mario)   Uamplitudes(0:3,0:7) in normal order
  ! t for Uamplitudes(t,*)
  ! 0 -> 0,0
  ! 1 -> 1,1
  ! 2 -> 0,1
  ! 3 -> 1,0
  ! n for Uamplitudes(*,n)
  ! 0 -> U
  ! 1 -> dU/dRHO_0
  ! 2 -> dU/dRHO_1
  ! 3 -> d2U/(dRHO_0*dRHO_0)
  ! 4 -> d2U/(dRHO_1*dRHO_1) 
  ! 5 -> d2U/(dRHO_0*dRHO_1) 
  ! 6 -> dU/d(TAU_0)   
  ! 7 -> dU/d(Delta RHO_0)   
  ! TESTED MATTHEMETICA<=>BIRUC & SCOTT; MATTHEMETICA<=>Module UNEDF (energy amplitudes only)
  ! ver#2: (Mario) Pairing included
  !  - set_functional_parameters(fname,lpr)
  !  - pairing incorporated into CpV0(0:1),CpV1(0:1)
  !    as public variables also serving two public amplitudes
  !     Urhorhopr(0:1,0)=CpV0(0:1)+CpV1(0:1)*rho(0)
  !     Urhorhopr(0:1,1)=CpV1(0:1)
  !     so, they can be used with appropriate values by the DME solver
  !  -need improvement later, 
  !      currently HFBTHO uses CpV0(0:1), CpV0(0:1)  as before
  !      just substituting V0,V1 in pn-representation 
  !      CpV0*(1-CpV1/0.16*rho_0)and this defines
  !      the default values in the module CpV0=V0,CpV1=1/2)
  !  -NAMELIST and input/output modified. RESERVED NAMES ARE:
  !      -namelist forbiden:
  !          'UNRDF'  - best UNEDF
  !          'SKYRME' - best SKYRME
  !      -namelist inforced but not for C-parameters (use_INM=F) 
  !       or NM-parameters (use_INM=T) defined by the solver 
  !          'FITS'   
  !      -namelist inforced (one can overwrite all):
  !          'ANY OTHER NAME' 
  !       i.e., the solver defines C-/NM- only using 'FITS'       
  ! ver#1: (Mario) Complete rewrite consistent with HFBTHO
  !  -CB-LDA added
  !  -INM added 
  !  -HFBTHO BENCHMARK: LN, ZR(110) prolate solution with SLY4, 
  !   mixed pairing and tensor terms. Agreement with previouse 
  !   implemetation to the last significant digit in the cases:
  !      - Standard Skyrme  
  !      - LO+LDA
  !      - LO+CB-LDA
  !      - (NrNr=0,rDj=0), (rDr=0,jDr=0), 0.5(NrNr=-rDr,jDr=-rDj)  
  !   -use_j2terms removed, i.e., in the SKYRME case CJ=0 removes all
  !    tensor terms, while in DME tensor terms are always present     
  ! ver#0: (Marcus) Basic coding from scratch
  !   -DME(u) consistent with Mathematica numbers 
  !   -including small 'u' approximation  
  !-------------------------------------------------------------------
  !
  ! === PUBLIC VARIABLES ===
  !
  ! Use pointers to prevent conflicts with UNEDF public variabes
  ! Example: Use UNEDF, pr=>my_pr, ipr=>my_ipr, Crho=>my_Crho ...
  !
  Integer, Parameter, Public :: pr=Kind(1.0D0), ipr=Kind(1)                   ! to set the precision of the DFT solver
  Logical, Public :: use_charge_density, use_cm_cor           
  Real(pr), Public, Dimension(0:3,0:7) :: Urhorho,Urhotau,UrhoDrho,Unablarho  ! ph DME amplitudes   
  Real(pr), Public, Dimension(0:3,0:7) :: UJnablarho,UrhonablaJ,UJJ
  Real(pr), Public, Dimension(0:3,0:7) :: Urhorhopr                           ! pp amplitudes   
  Real(pr), Public, Dimension(0:1) :: UEnonstdr,UFnonstdr,URnonstdr           ! Other amplitudes  
  Real(pr), Public :: hbzero,sigma,e2charg,CExPar                             ! hbr^2/2m, DD sigma, e^2 charge, coul. exchange parameter
  Real(pr), Public, Dimension(0:1) :: Crho,Cdrho,Ctau,CrDr,CrdJ,CJ,CpV0,CpV1  ! basic coupling constants
  Real(pr), Public :: E_NM,K_NM,SMASS_NM,RHO_NM,ASS_NM,LASS_NM,VMASS_NM,P_NM,KA_NM
  Real(pr), Public :: CHrho                                                   ! Crho(0) from the Hartree term in NM
  Logical, Public :: use_DME3N_terms,use_j2terms
  Integer(ipr), Public :: DMEorder,DMElda
  !  
  ! === PRIVATE VARIABLES ===
  !
  Real(pr), Private, Dimension(0:1) :: nuCrho,nuCdrho,nuCtau,nuCrDr           ! basic coupling constants in natural units
  Real(pr), Private, Dimension(0:1) :: nuCrdJ,nuCJ,nuCpV0,nuCpV1              !
  Real(pr), Private :: t0,t1,t2,t3,x0,x1,x2,x3,b4,b4p,te,to
  Real(pr), Private :: nuLambda,nufpi                                         ! parameters associated to natural units
  Real(pr), Private, Dimension(0:1) :: Cnrho,CJdr                             ! hidden and always zero
  Integer(ipr), Private :: i_cut                                              ! dmeorder: -1=Standard Skyrme, 0=LO, 1=NLO, 2=N2LO  
  Real(pr), Private :: Pi,eps                                                 ! dmelda: 0=Kf-LDA, 1=CB-LDA
  Real(pr), Private :: kfconst,CK                                             ! (3Pi^2/2)^(1/3)
  Real(pr), Parameter, Private :: mevfm=197.30_pr; 
  Real(pr), Private :: rho(0:1),tau(0:1),nrho2(0:1),lrho(0:1)
  Real(pr), Private :: mpi,gA,fpi,c1,c3,c4,cd,ce,LambdaX
  Real(pr), Private :: mpi2,fpi2,fpi4,gA2,gA4,gA6,CHartree
  Real(pr), Private :: arhorho,brhorho,arhodrho,brhodrho,arhotau,brhotau,ajj,bjj,adrdr,bdrdr
  Real(pr), Private :: darhorho,dbrhorho,darhodrho,dbrhodrho,darhotau,dbrhotau,dajj,dbjj,dadrdr,dbdrdr
  Real(pr), Private :: ddarhodrho,ddbrhodrho,ddarhotau,ddbrhotau,ddarhorho,ddbrhorho
  Real(pr), Private :: hrho0rho0,hrho1rho1,hdr0dr0,hdr1dr1,hrho0Drho0,hrho1Drho0, &
       hrho1Drho1,hrho0tau0,hrho1tau0,hrho1tau1,hJ0dr0,hrho0DJ0,hJ1dr1,hrho1DJ1, &
       hJ0dr1,hrho1DJ0,hJ1dr0,hJ0J0,hJ0J1,hJ1J1     
  Real(pr), Private :: dhrho0rho0,dhrho1rho1,dhdr0dr0,dhdr1dr1,dhrho0Drho0, &
       dhrho1Drho0,dhrho1Drho1,dhrho0tau0,dhrho1tau0,dhrho1tau1,dhJ0dr0,dhrho0DJ0, &
       dhJ1dr1,dhrho1DJ1,dhJ0dr1,dhrho1DJ0,dhJ1dr0,dhJ0J0,dhJ0J1,dhJ1J1     
  Real(pr), Private :: ddhrho0rho0,ddhrho1rho1,ddhrho0Drho0,ddhrho1Drho0, &
       ddhrho1Drho1,ddhrho0tau0,ddhrho1tau0,ddhrho1tau1
  Real(pr), Private, Dimension(3,3,33) :: ctr0r0,ctr1r1,ctdr0dr0,ctdr1dr1, & ! coefficients for 3N part   
       ctr0Dr0,ctr1Dr0,ctr1Dr1,ctr0t0,ctr1t0,ctr1t1,ctJ0dr0,ctr0dJ0,ctJ1dr1, &
       ctr1dJ1,ctJ0dr1,ctr1dJ0,ctJ1dr0,ctJ0J0,ctJ0J1,ctJ1J1
  Real(pr), Private :: u2,u3,u4,u5,u6,u7,u8,u9,u10,u11,u12
  Real(pr), Private :: ual,lual,atu,asqu,asqu4 
  Real(pr), Private :: ac2,ac3,acoord
  Parameter(acoord=0.50_pr,ac2=4.0_pr*(acoord**2-acoord+0.50_pr),ac3=2.0_pr*(acoord**2-acoord+0.50_pr))
  Character (30) :: FunctionalName 
  Logical, Private :: Print_Namelist
  ! 
  Real(pr), Private :: A1_1,A1_2,A1_3,A1_4,A1_5,b1_1,b1_2,b1_3,b1_4,b1_5
  Real(pr), Private :: A3_1,A3_2,A3_3,A3_4,A3_5,b3_1,b3_2,b3_3,b3_4,b3_5    
  Real(pr), Private :: h0mpi6,h0mpi6c1,h0mpi6c3,h0mpi6NM,h0mpi6c1NM,h0mpi6c3NM
  !
Contains
  !
  !=======================================================================================================
  Subroutine calculate_U_parameters(rho0_in,rho1_in,tau0_in,tau1_in,laprho0,laprho1,nablarho0s,nablarho1s)
    !-----------------------------------------------------------------------------------------------------
    Implicit None
    Real(pr), Intent(in) :: rho0_in,rho1_in,tau0_in,tau1_in
    Real(pr), Intent(in), Optional :: &
         nablarho0s,nablarho1s,laprho0,laprho1
    Integer(ipr) :: t,i,j,k,l
    Real(pr) :: u,du,ddu,dtu,dlu
    Real(pr) :: ph,aux,daux,ddaux
    Real(pr) :: y,dy,ddy,marc,dmarc,ddmarc,mlog,dmlog,ddmlog
    Real(pr) :: ucut,ucut3n
    !
    ucut=0.1_pr; ucut3n=0.6_pr
    !    
    rho(0)=rho0_in; rho(1)=rho1_in; 
    tau(0)=tau0_in; tau(1)=tau1_in; 
    !
    lrho=0.0_pr; nrho2=0.0_pr; 
    If (Present(laprho0)) lrho(0)=laprho0 
    If (Present(laprho1)) lrho(1)=laprho1
    If (Present(nablarho0s)) nrho2(0)=nablarho0s 
    If (Present(nablarho1s)) nrho2(1)=nablarho1s
    !
    arhorho=0.0_pr; darhorho=0.0_pr; ddarhorho=0.0_pr
    brhorho=0.0_pr; dbrhorho=0.0_pr; ddbrhorho=0.0_pr
    arhodrho=0.0_pr; darhodrho=0.0_pr; ddarhodrho=0.0_pr
    brhodrho=0.0_pr; dbrhodrho=0.0_pr; ddbrhodrho=0.0_pr
    arhotau=0.0_pr; darhotau=0.0_pr; ddarhotau=0.0_pr
    brhotau=0.0_pr; dbrhotau=0.0_pr; ddbrhotau=0.0_pr  
    adrdr=0.0_pr; dadrdr=0.0_pr
    bdrdr=0.0_pr; dbdrdr=0.0_pr
    ajj=0.0_pr; dajj=0.0_pr
    bjj=0.0_pr; dbjj=0.0_pr    
    !
    hrho0rho0=0.0_pr; hrho1rho1=0.0_pr; hdr0dr0=0.0_pr; hdr1dr1=0.0_pr
    hrho0Drho0=0.0_pr; hrho1Drho0=0.0_pr; hrho1Drho1=0.0_pr 
    hrho0tau0=0.0_pr; hrho1tau0=0.0_pr; hrho1tau1=0.0_pr 
    hJ0dr0=0.0_pr; hrho0DJ0=0.0_pr; hJ1dr1=0.0_pr; hrho1DJ1=0.0_pr
    hJ0dr1=0.0_pr; hrho1DJ0=0.0_pr; hJ1dr0=0.0_pr 
    hJ0J0=0.0_pr; hJ0J1=0.0_pr; hJ1J1=0.0_pr
    dhrho0rho0=0.0_pr; dhrho1rho1=0.0_pr; dhdr0dr0=0.0_pr; dhdr1dr1=0.0_pr
    dhrho0Drho0=0.0_pr; dhrho1Drho0=0.0_pr; dhrho1Drho1=0.0_pr 
    dhrho0tau0=0.0_pr; dhrho1tau0=0.0_pr; dhrho1tau1=0.0_pr 
    dhJ0dr0=0.0_pr; dhrho0DJ0=0.0_pr; dhJ1dr1=0.0_pr; dhrho1DJ1=0.0_pr
    dhJ0dr1=0.0_pr; dhrho1DJ0=0.0_pr; dhJ1dr0=0.0_pr 
    dhJ0J0=0.0_pr; dhJ0J1=0.0_pr; dhJ1J1=0.0_pr
    ddhrho0rho0=0.0_pr; ddhrho1rho1=0.0_pr 
    ddhrho0Drho0=0.0_pr; ddhrho1Drho0=0.0_pr; ddhrho1Drho1=0.0_pr
    ddhrho0tau0=0.0_pr; ddhrho1tau0=0.0_pr; ddhrho1tau1=0.0_pr
    !
    ! U and partial derivatives with respect of rho_0 in Thomas Fermi approximation
    !
    u=0.0_pr; du=0.0_pr; ddu=0.0_pr; dtu=0.0_pr; dlu=0.0_pr
    If (dmeorder.Ge.0) Then
       If (dmelda.Eq.0) Then
          ! density dependent LDA
          u=(kfconst/mpi)*rho(0)**(1.0_pr/3.0_pr)
          du=(1.0_pr/3.0_pr)*u/(rho(0)+eps)                 ! u'(RHO_0)   
          ddu=-(2.0_pr/9.0_pr)*u/(rho(0)**2+eps)            ! u''(RHO_0)  
          dtu=0.0_pr                                        ! u'(TAU_0)   
          dlu=0.0_pr                                        ! u'(DeltaRHO_0) 
       Else 
          ! density and gradient dependent LDA       
          u=Sqrt(Abs((5.0_pr/3.0_pr)*(tau(0)-0.250_pr*lrho(0))/(rho(0)+eps)))/mpi 
          du=-0.50_pr*u/(rho(0)+eps)                        ! u'(RHO_0)   
          ddu=0.750_pr*u/(rho(0)**2+eps)                    ! u''(RHO_0)
          dtu=0.50_pr*u/(Abs(tau(0)-0.250_pr*lrho(0))+eps)  ! u'(TAU_0)   
          dlu=-0.250_pr*dtu                                 ! u'(DeltaRHO_0) 
       Endif
    Endif
    !
    ! Partial optimiztion
    u2=u*u; u3=u2*u; u4=u3*u; u5=u4*u; u6=u5*u; u7=u6*u; u8=u7*u; u9=u8*u; u10=u9*u; u11=u10*u; u12=u11*u;
    ual=1.0_pr+4.0_pr*u2; lual=Log(ual); atu=Atan(2.0_pr*u); asqu=Sqrt(1.0_pr+u2); asqu4=Sqrt(4.0_pr+u2)
    !
    ! A and B functions and their partial derivatives with respect of u
    !
    !  LO, 2N terms
    !
    If (dmeorder.Ge.0) Then
       If (u.Gt.ucut) Then          
          arhorho=(gA2*(4.0_pr*u2*(21.0_pr-498.0_pr*u2-64.0_pr*u4+16.0_pr*u6)+48.0_pr*u3 &
               *(35.0_pr+4.0_pr*u2)*atu+3.0_pr*(-7.0_pr+16.0_pr*u2*(-8.0_pr+9.0_pr*u2))*lual)) &
               /(1024.0_pr*fpi2*u8)
          darhorho=(gA2*(4.0_pr*u2*(-21.0_pr+279.0_pr*u2+16.0_pr*u4)-6.0_pr*u3*(175.0_pr &
               +12.0_pr*u2)*atu+3.0_pr*(7.0_pr+96.0_pr*u2-72.0_pr*u4)*lual))/(128.0_pr*fpi2*u9)
          ddarhorho=(-3.0_pr*gA2*(4.0_pr*u2*(-63.0_pr+504.0_pr*u2+16.0_pr*u4)-12.0_pr*u3*(175.0_pr &
               +8.0_pr*u2)*atu+(63.0_pr+672.0_pr*u2-360.0_pr*u4)*lual))/(128.0_pr*fpi2*u10)
          brhorho=2.0_pr*arhorho   
          dbrhorho=2.0_pr*darhorho   
          ddbrhorho=2.0_pr*ddarhorho
          !
          arhodrho=(35.0_pr*gA2*(-4.0_pr*u2*(-3.0_pr+72.0_pr*u2+4.0_pr*u4-60.0_pr*u*atu) &
               +3.0_pr*(-1.0_pr-18.0_pr*u2+24.0_pr*u4)*lual))/(12288.0_pr*fpi2*mpi2*u10)
          darhodrho=(35.0_pr*gA2*(4.0_pr*u2*(-15.0_pr+234.0_pr*u2+8.0_pr*u4 &
               -210.0_pr*u*atu)+3.0_pr*(5.0_pr+72.0_pr*u2-72.0_pr*u4)*lual)) &
               /(6144.0_pr*fpi2*mpi2*u11)
          ddarhodrho=(35.0_pr*gA2*(4.0_pr*u2*(165.0_pr-1746.0_pr*u2-40.0_pr*u4+1680.0_pr*u &
               *atu)+3.0_pr*(-55.0_pr+72.0_pr*u2*(-9.0_pr+7.0_pr*u2))*lual))/(6144.0_pr*fpi2*mpi2*u12)
          !
          brhodrho=2.0_pr*arhodrho
          dbrhodrho=2.0_pr*darhodrho
          ddbrhodrho=2.0_pr*ddarhodrho
          ! 
          arhotau=(35.0_pr*gA2*(4.0_pr*u2*(-3.0_pr+72.0_pr*u2+4.0_pr*u4)-240.0_pr*u3 &
               *atu+(3.0_pr+54.0_pr*u2-72.0_pr*u4)*lual))/(3072.0_pr*fpi2*mpi2*u10)
          darhotau=(35.0_pr*gA2*(4.0_pr*u2*(15.0_pr-234.0_pr*u2-8.0_pr*u4+210.0_pr*u &
               *atu)+3.0_pr*(-5.0_pr+72.0_pr*u2*(-1.0_pr+u2))*lual))/(1536.0_pr*fpi2*mpi2*u11)
          ddarhotau=(35.0_pr*gA2*(4.0_pr*u2*(-165.0_pr+1746.0_pr*u2+40.0_pr*u4-1680.0_pr*u*atu) &
               +3.0_pr*(55.0_pr+72.0_pr*u2*(9.0_pr-7.0_pr*u2))*lual))/(1536.0_pr*fpi2*mpi2*u12)
          brhotau=2.0_pr*arhotau
          dbrhotau=2.0_pr*darhotau
          ddbrhotau=2.0_pr*ddarhotau
          !
          ajj=(3.0_pr*gA2*(-4.0_pr*u2+8.0_pr*u4+lual))/(512.0_pr*fpi2*mpi2*u6)
          dajj=(-3.0_pr*gA2*(4.0_pr*u2*(-3.0_pr-6.0_pr*u2+8.0_pr*u4)+3.0_pr*(ual)*lual)) &
               /(256.0_pr*fpi2*mpi2*u7*(ual))
          bjj=2.0_pr*ajj
          dbjj=2.0_pr*dajj            
       Else
          Arhorho=(gA2*u4*(121.0_pr-448.0_pr*u2))/(1155.0_pr*fpi2)
          dArhorho=(4.0_pr*gA2*u3*(121.0_pr-672.0_pr*u2))/(1155.0_pr*fpi2)
          ddArhorho=(4.0_pr*gA2*u2*(1573.0_pr+560.0_pr*u2*(-26.0_pr+153.0_pr*u2)))/(5005.0_pr*fpi2)
          Brhorho=2.0_pr*Arhorho
          dBrhorho=2.0_pr*dArhorho
          ddBrhorho=2.0_pr*ddArhorho
          !     
          Arhotau=(gA2*(1287.0_pr-4004.0_pr*u2+11232.0_pr*u4-31680.0_pr*u6))/(10296.0_pr*fpi2*mpi2)
          dArhotau=(gA2*u*(-1001.0_pr+432.0_pr*u2*(13.0_pr-55.0_pr*u2)))/(1287.0_pr*fpi2*mpi2)
          ddArhotau=(gA2*(-1001.0_pr+16.0_pr*u2*(1053.0_pr-7425.0_pr*u2+40040.0_pr*u4)))/(1287.0_pr*fpi2*mpi2)
          Brhotau=2.0_pr*Arhotau
          dBrhotau=2.0_pr*dArhotau
          ddBrhotau=2.0_pr*ddArhotau
          !
          ArhoDrho=-Arhotau/4.0_pr
          dArhoDrho=-dArhotau/4.0_pr
          ddArhoDrho=-ddArhotau/4.0_pr
          BrhoDrho=2.0_pr*ArhoDrho
          dBrhoDrho=2.0_pr*dArhoDrho
          ddBrhoDrho=2.0_pr*ddArhoDrho
          !
          AJJ=(gA2*(5.0_pr-15.0_pr*u2+48.0_pr*u4-160.0_pr*u6))/(40.0_pr*fpi2*mpi2)
          dAJJ=(-3.0_pr*gA2*u*(5.0_pr-32.0_pr*u2+160.0_pr*u4))/(20.0_pr*fpi2*mpi2)
          Bjj=2.0_pr*Ajj; 
          dBjj=2.0_pr*dAjj   
       End If
    End If
    !
    ! NLO, 2N terms
    !
    If (dmeorder.Ge.1) Then
       If (u.Gt.ucut) Then
          arhorho=arhorho+(mpi2*(4.0_pr*u2*(11025.0_pr*(-1.0_pr + 10.0_pr*gA2 + 127.0_pr*gA4) &
               - 525.0_pr*(-839.0_pr + 3014.0_pr*gA2 + 50489.0_pr*gA4)*u2 - 4200.0_pr*(-17.0_pr &
               - 6.0_pr*gA2 + 495.0_pr*gA4)*u4 - 140.0_pr*(-133.0_pr - 718.0_pr*gA2 &
               + 107.0_pr*gA4)*u6 + 1536.0_pr*(1.0_pr + 10.0_pr*gA2 + 13.0_pr*gA4)*u8) &
               - 525.0_pr*Log(1.0_pr + 2.0_pr*u*(u + asqu))*(4.0_pr*u*asqu*(21.0_pr*(-1.0_pr &
               + 10.0_pr*gA2 + 127.0_pr*gA4) - 2.0_pr*(-167.0_pr + 518.0_pr*gA2 + 9305.0_pr*gA4)*u2 &
               + 8.0_pr*(7.0_pr + 10.0_pr*gA2 - 153.0_pr*gA4)*u4 + 16.0_pr*(1.0_pr + 6.0_pr*gA2 &
               + gA4)*u6) + 3.0_pr*(7.0_pr - 70.0_pr*gA2 - 889.0_pr*gA4 - 64.0_pr*(-1.0_pr + 6.0_pr*gA2 &
               + 83.0_pr*gA4)*u2 + 48.0_pr*(-1.0_pr + 2.0_pr*gA2 + 47.0_pr*gA4)*u4)*Log(1.0_pr &
               + 2.0_pr*u*(u + asqu)))))/(1.72032e7_pr*fpi4*Pi**2*u8)

          darhorho=darhorho+(mpi2*(4.0_pr*u2*(-3675.0_pr*(-1.0_pr+10.0_pr*gA2+127.0_pr*gA4) &
               +175.0_pr*(-503.0_pr+1766.0_pr*gA2+29897.0_pr*gA4)*u2+2800.0_pr*(-3.0_pr-2.0_pr*gA2 &
               +81.0_pr*gA4)*u4-700.0_pr*(1.0_pr+6.0_pr*gA2+gA4)*u6+128.0_pr*(1.0_pr+10.0_pr*gA2 &
               +13.0_pr*gA4)*u8)*(asqu+2.0_pr*u*(1.0_pr+u*(u+asqu))) &
               -700.0_pr*u*(1.0_pr+u2)*(21.0_pr-2*u2*(95.0_pr+8.0_pr*u2)+gA2*(-210.0_pr+556.0_pr*u2 &
               -32.0_pr*u4)+gA4*(-2667.0_pr+10306.0_pr*u2+304.0_pr*u4))*(1.0_pr+2.0_pr*u*(u+Sqrt(1.0_pr &
               +u2)))*Log(1.0_pr+2.0_pr*u*(u+asqu))+525.0_pr*(7.0_pr-70.0_pr*gA2 &
               -889.0_pr*gA4-48.0_pr*(-1.0_pr+6.0_pr*gA2+83.0_pr*gA4)*u2+24.0_pr*(-1.0_pr+2.0_pr*gA2 &
               +47.0_pr*gA4)*u4)*(asqu+2.0_pr*u*(1.0_pr+u*(u+asqu)))*Log(1.0_pr &
               +2.0_pr*u*(u+asqu))**2))/(716800.0_pr*fpi4*Pi**2*u9*asqu*(1.0_pr &
               +2.0_pr*u*(u+asqu)))

          ddarhorho=ddarhorho+(mpi2*(4.0_pr*u2*(33075.0_pr*(-1.0_pr+10.0_pr*gA2+127.0_pr*gA4) &
               -525.0_pr*(-965.0_pr+3314.0_pr*gA2+56699.0_pr*gA4)*u2-2800.0_pr*(-11.0_pr-10.0_pr*gA2 &
               +281.0_pr*gA4)*u4+700.0_pr*(1.0_pr+6.0_pr*gA2+gA4)*u6+128.0_pr*(1.0_pr+10.0_pr*gA2 &
               +13.0_pr*gA4)*u8)*(asqu+4.0_pr*(u+u3)*(1.0_pr+2.0_pr*u*(u &
               +asqu)))+525.0_pr*Log(1.0_pr+2.0_pr*u*(u+asqu))*(4.0_pr*u*(1.0_pr &
               +u2)*(63.0_pr-346.0_pr*u2-16.0_pr*u4+gA2*(-630.0_pr+964.0_pr*u2-32.0_pr*u4) &
               +gA4*(-8001.0_pr+18406.0_pr*u2+304.0_pr*u4))*(1.0_pr+4.0_pr*u*(asqu &
               +2.0_pr*u*(1.0_pr+u*(u+asqu))))-3.0_pr*(-21.0_pr*(-1.0_pr+10.0_pr*gA2 &
               +127.0_pr*gA4)-112.0_pr*(-1.0_pr+6.0_pr*gA2+83.0_pr*gA4)*u2+40.0_pr*(-1.0_pr &
               +2.0_pr*gA2+47.0_pr*gA4)*u4)*(asqu+4.0_pr*(u+u3)*(1.0_pr+2.0_pr*u*(u &
               +asqu)))*Log(1.0_pr+2.0_pr*u*(u+asqu)))))/(716800.0_pr*fpi4*Pi**2*u10*asqu &
               *(1.0_pr+2.0_pr*u*(u+asqu))**2)

          brhorho=brhorho+(mpi2*(4.0_pr*u2*(11025.0_pr*(-1.0_pr + 10.0_pr*gA2 + 43.0_pr*gA4) &
               - 525.0_pr*(-839.0_pr + 3014.0_pr*gA2 + 12269.0_pr*gA4)*u2 - 4200.0_pr*(-17.0_pr &
               - 6.0_pr*gA2 + 123.0_pr*gA4)*u4 - 140.0_pr*(-133.0_pr - 718.0_pr*gA2 &
               + 1223.0_pr*gA4)*u6 - 1536.0_pr*(-1.0_pr - 10.0_pr*gA2 + 23.0_pr*gA4)*u8) &
               + 525.0_pr*Log(1.0_pr + 2.0_pr*u*(u + asqu))*(4.0_pr*u*asqu*(21.0_pr &
               - 2.0_pr*u2*(167.0_pr + 28.0_pr*u2 + 8.0_pr*u4) - 2.0_pr*gA2*(105.0_pr &
               - 518.0_pr*u2 + 40.0_pr*u4 + 48.0_pr*u6) + gA4*(-903.0_pr + 4378.0_pr*u2 &
               + 360.0_pr*u4 + 176.0_pr*u6)) - 3.0_pr*(7.0_pr - 70.0_pr*gA2 - 301.0_pr*gA4 &
               - 64.0_pr*(-1.0_pr + 6.0_pr*gA2 + 23.0_pr*gA4)*u2 + 48.0_pr*(-1.0_pr + 2.0_pr*gA2 &
               + 11.0_pr*gA4)*u4)*Log(1.0_pr + 2.0_pr*u*(u + asqu)))))/(8.6016e6_pr*fpi4*Pi**2*u8)

          dbrhorho=dbrhorho+(mpi2*(-4.0_pr*u2*(3675.0_pr*(-1.0_pr+10.0_pr*gA2+43.0_pr*gA4) &
               -175.0_pr*(-503.0_pr+1766.0_pr*gA2+7229.0_pr*gA4)*u2-2800.0_pr*(-3.0_pr-2.0_pr*gA2 &
               +21.0_pr*gA4)*u4-700.0_pr*(-1.0_pr-6.0_pr*gA2+11.0_pr*gA4)*u6+128.0_pr*(-1.0_pr &
               -10.0_pr*gA2+23.0_pr*gA4)*u8)*(asqu+2.0_pr*u*(1.0_pr+u*(u+Sqrt(1.0_pr &
               +u2))))-700.0_pr*u*(1.0_pr+u2)*(21.0_pr-2.0_pr*u2*(95.0_pr+8.0_pr*u2)+gA2*(-210.0_pr &
               +556.0_pr*u2-32.0_pr*u4)+gA4*(-903.0_pr+2410.0_pr*u2+112.0_pr*u4))*(1.0_pr+2.0_pr*u*(u &
               +asqu))*Log(1.0_pr+2.0_pr*u*(u+asqu))+525.0_pr*(7.0_pr-70.0_pr*gA2 &
               -301.0_pr*gA4-48.0_pr*(-1.0_pr+6.0_pr*gA2+23.0_pr*gA4)*u2+24.0_pr*(-1.0_pr+2.0_pr*gA2 &
               +11.0_pr*gA4)*u4)*(asqu+2.0_pr*u*(1.0_pr+u*(u+asqu)))*Log(1.0_pr &
               +2.0_pr*u*(u+asqu))**2))/(358400.0_pr*fpi4*Pi**2*u9*asqu*(1.0_pr &
               +2.0_pr*u*(u+asqu)))

          ddbrhorho=ddbrhorho+(mpi2*(-4.0_pr*u2*(-33075.0_pr*(-1.0_pr+10.0_pr*gA2+43.0_pr*gA4) &
               +525.0_pr*(-965.0_pr+3314.0_pr*gA2+13655.0_pr*gA4)*u2+2800.0_pr*(-11.0_pr-10.0_pr*gA2 &
               +77.0_pr*gA4)*u4+700.0_pr*(-1.0_pr-6.0_pr*gA2+11.0_pr*gA4)*u6+128.0_pr*(-1.0_pr &
               -10.0_pr*gA2+23.0_pr*gA4)*u8)*(asqu+4.0_pr*(u+u3)*(1.0_pr+2.0_pr*u*(u &
               +asqu)))+525.0_pr*Log(1.0_pr+2.0_pr*u*(u+asqu))*(4.0_pr*u*(1.0_pr &
               +u2)*(-63.0_pr*(-1.0_pr+10.0_pr*gA2+43.0_pr*gA4)+2.0_pr*(-173.0_pr+482.0_pr*gA2 &
               +2159.0_pr*gA4)*u2+16.0_pr*(-1.0_pr-2.0_pr*gA2+7.0_pr*gA4)*u4)*(1.0_pr &
               +4.0_pr*u*(asqu+2.0_pr*u*(1.0_pr+u*(u+asqu))))-3.0_pr*( &
               -21.0_pr*(-1.0_pr+10.0_pr*gA2+43.0_pr*gA4)-112.0_pr*(-1.0_pr+6.0_pr*gA2 &
               +23.0_pr*gA4)*u2+40.0_pr*(-1.0_pr+2.0_pr*gA2+11.0_pr*gA4)*u4)*(asqu &
               +4.0_pr*(u+u3)*(1.0_pr+2.0_pr*u*(u+asqu)))*Log(1.0_pr+2.0_pr*u*(u &
               +asqu)))))/(358400.0_pr*fpi4*Pi**2*u10*asqu*(1.0_pr &
               +2.0_pr*u*(u+asqu))**2)

          arhodrho=arhodrho -(-44100.0_pr*(-1.0_pr+10.0_pr*gA2+127.0_pr*gA4)*u2+4200.0_pr*(-421.0_pr &
               +1516.0_pr*gA2+25369.0_pr*gA4)*u4+420.0_pr*(-283.0_pr-30.0_pr*gA2+8641.0_pr*gA4)*u6 &
               +1680.0_pr*(-19.0_pr-106.0_pr*gA2+5.0_pr*gA4)*u8+464.0_pr*(1.0_pr+10.0_pr*gA2 &
               +13.0_pr*gA4)*u10-420.0_pr*u*asqu*(105.0_pr-1685.0_pr*u2-134.0_pr*u4 &
               -8.0_pr*u6+16.0_pr*u8+10.0_pr*gA2*(-105.0_pr+527.0_pr*u2-22.0_pr*u4-8.0_pr*u6 &
               +16.0_pr*u8)+gA4*(-13335.0_pr+94295.0_pr*u2+2738.0_pr*u4-104.0_pr*u6+208.0_pr*u8)) &
               *Log(1.0_pr+2.0_pr*u*(u+asqu))+11025.0_pr*(1.0_pr-10.0_pr*gA2-127.0_pr*gA4 &
               -9.0_pr*(-1.0_pr+6.0_pr*gA2+83.0_pr*gA4)*u2+8.0_pr*(-1.0_pr+2.0_pr*gA2 &
               +47.0_pr*gA4)*u4)*Log(1.0_pr+2.0_pr*u*(u+asqu))**2-128.0_pr*u3*(33600.0_pr &
               *(-1.0_pr+4.0_pr*gA2+16.0_pr*gA4)*u+560.0_pr*(-29.0_pr-10.0_pr*gA2+212.0_pr*gA4)*u3 &
               +420.0_pr*(-3.0_pr-16.0_pr*gA2+27.0_pr*gA4)*u5+33.0_pr*(-1.0_pr-10.0_pr*gA2 &
               +23.0_pr*gA4)*u7+16800.0_pr*(-1.0_pr+4.0_pr*gA2+16.0_pr*gA4)*asqu4*Log(2.0_pr) &
               +1680.0_pr*(-4.0_pr-5.0_pr*gA2+22.0_pr*gA4)*u2*asqu4*Log(2.0_pr)+210.0_pr &
               *(-1.0_pr-10.0_pr*gA2+23.0_pr*gA4)*u4*asqu4*Log(2.0_pr)+105.0_pr*(1.0_pr &
               +10.0_pr*gA2-23.0_pr*gA4)*u6*asqu4*Log(2.0_pr)+105.0_pr*asqu4 &
               *(-((-10.0_pr+u2)*(4.0_pr+u2)**2)-10.0_pr*gA2*(64.0_pr-8.0_pr*u2-2.0_pr*u4+u6) &
               +gA4*(-2560.0_pr-352.0_pr*u2-46.0_pr*u4+23.0_pr*u6))*Log(2.0_pr+u*(u+Sqrt(4.0_pr &
               +u2)))))/(4.128768e7_pr*fpi4*Pi**2*u10) 

          darhodrho=darhodrho+(-420.0_pr*u*(1.0_pr+u2)*asqu4*(15.0_pr-158.0_pr*u2 &
               -8.0_pr*u4-2.0_pr*gA2*(75.0_pr-238.0_pr*u2+8.0_pr*u4)+gA4*(-1905.0_pr+8690.0_pr*u2 &
               +152.0_pr*u4))*Log(1.0_pr+2.0_pr*u*(u+asqu))+315.0_pr*asqu &
               *asqu4*(5.0_pr-50.0_pr*gA2-635.0_pr*gA4-36.0_pr*(-1.0_pr+6.0_pr*gA2 &
               +83.0_pr*gA4)*u2+24.0_pr*(-1.0_pr+2.0_pr*gA2+47.0_pr*gA4)*u4)*Log(1.0_pr+2.0_pr*u*(u &
               +asqu))**2+4.0_pr*u2*asqu*(1575.0_pr*asqu4+gA4 & 
               *(-200025.0_pr*asqu4+u*(u*(845775.0_pr*asqu4+4.0_pr*u*(u*(-47705.0_pr &
               *asqu4+3.0_pr*u*(u*asqu4*(-1253.0_pr+236.0_pr*u2) &
               -7840.0_pr*Log(2.0_pr)))-268800.0_pr*Log(2.0_pr)))-3440640.0_pr*Log(2.0_pr))) &
               +u*(64575.0_pr*u*asqu4+33740.0_pr*u3*asqu4+1092.0_pr*u5*asqu4 &
               -48.0_pr*u7*asqu4+13440.0_pr*(4.0_pr+u2)**2*Log(2.0_pr))-2.0_pr*gA2*(7875.0_pr &
               *asqu4+u*(138915.0_pr*u*asqu4-8540.0_pr*u3*asqu4 &
               -3276.0_pr*u5*asqu4+240.0_pr*u7*asqu4-13440.0_pr*(-8.0_pr+u2) &
               *(4.0_pr+u2)*Log(2.0_pr)))+13440.0_pr*u*(-(4.0_pr+u2)**2+gA2*(64.0_pr+8.0_pr*u2 &
               -2.0_pr*u4)+gA4*(256.0_pr+80.0_pr*u2+7.0_pr*u4))*Log(2.0_pr+u*(u+Sqrt(4.0_pr &
               +u2)))))/(589824.0_pr*fpi4*Pi**2*u11*asqu*asqu4)

          ddarhodrho=ddarhodrho+(420.0_pr*u*asqu*(4.0_pr+u2)**1.5_pr*(-165.0_pr*(-1.0_pr &
               +10.0_pr*gA2+127.0_pr*gA4)+2.0_pr*(-593.0_pr+1730.0_pr*gA2+32183.0_pr*gA4)*u2 &
               +40.0_pr*(-1.0_pr-2.0_pr*gA2+19.0_pr*gA4)*u4)*Log(1.0_pr+2.0_pr*u*(u+asqu)) &
               -315.0_pr*(4.0_pr+u2)**1.5_pr*(-55.0_pr*(-1.0_pr+10.0_pr*gA2+127.0_pr*gA4)-324.0_pr &
               *(-1.0_pr+6.0_pr*gA2+83.0_pr*gA4)*u2+168.0_pr*(-1.0_pr+2.0_pr*gA2+47.0_pr*gA4)*u4) &
               *Log(1.0_pr+2.0_pr*u*(u+asqu))**2-4.0_pr*u2*(-((4.0_pr+u2)*(-17325.0_pr*asqu4 &
               +u*(u*(-526365.0_pr*asqu4+4.0_pr*u*(u*(-48475.0_pr*asqu4+3.0_pr*u &
               *(u*asqu4*(-273.0_pr+4.0_pr*u2)-5600.0_pr*Log(2.0_pr)))-174720.0_pr*Log(2.0_pr))) &
               -1720320.0_pr*Log(2.0_pr))))+gA4*(-8801100.0_pr*asqu4+21899745.0_pr*u2*Sqrt(4.0_pr &
               +u2)+1906205.0_pr*u4*asqu4-1290772.0_pr*u6*asqu4-33780.0_pr*u8 &
               *asqu4+2832.0_pr*u10*asqu4-13440.0_pr*u*(8192.0_pr+4224.0_pr*u2 &
               +672.0_pr*u4+35.0_pr*u6)*Log(2.0_pr))-2.0_pr*gA2*(4.0_pr+u2)*(86625.0_pr*asqu4 &
               +u*(3440640.0_pr*Log(2.0_pr)+u*(1137465.0_pr*asqu4+4.0_pr*u*(u*(-16975.0_pr*Sqrt(4.0_pr &
               +u2)+3.0_pr*u*(u*asqu4*(-819.0_pr+20.0_pr*u2)-5600.0_pr*Log(2.0_pr))) &
               +107520.0_pr*Log(2.0_pr)))))+13440.0_pr*u*(512.0_pr*(-1.0_pr+4.0_pr*gA2+16.0_pr*gA4) &
               +48.0_pr*(-7.0_pr+16.0_pr*gA2+88.0_pr*gA4)*u2+24.0_pr*(-3.0_pr+gA2+28.0_pr*gA4)*u4 &
               +5.0_pr*(-1.0_pr-2.0_pr*gA2+7.0_pr*gA4)*u6)*Log(2.0_pr+u*(u+asqu4)))) &
               /(589824.0_pr*fpi4*Pi**2*u12*(4.0_pr+u2)**1.5_pr)

          brhodrho=brhodrho -(-44100.0_pr*(-1.0_pr+10.0_pr*gA2+43.0_pr*gA4)*u2+4200.0_pr*(-421.0_pr &
               +1516.0_pr*gA2+6169.0_pr*gA4)*u4+420.0_pr*(-283.0_pr-30.0_pr*gA2+2029.0_pr*gA4)*u6 &
               +1680.0_pr*(-19.0_pr-106.0_pr*gA2+185.0_pr*gA4)*u8-464.0_pr*(-1.0_pr-10.0_pr*gA2 &
               +23.0_pr*gA4)*u10+420.0_pr*u*asqu*(-105.0_pr+1685.0_pr*u2+134.0_pr*u4 &
               +8.0_pr*u6-16.0_pr*u8+10.0_pr*gA2*(105.0_pr-527.0_pr*u2+22.0_pr*u4+8.0_pr*u6 &
               -16.0_pr*u8)+gA4*(4515.0_pr-22235.0_pr*u2-842.0_pr*u4-184.0_pr*u6+368.0_pr*u8)) &
               *Log(1.0_pr+2.0_pr*u*(u+asqu))+11025.0_pr*(1.0_pr+9.0_pr*u2-8.0_pr*u4 &
               +2.0_pr*gA2*(-5.0_pr-27.0_pr*u2+8.0_pr*u4)+gA4*(-43.0_pr-207.0_pr*u2+88.0_pr*u4)) &
               *Log(1.0_pr+2.0_pr*u*(u+asqu))**2+64.0_pr*u3*(33600.0_pr*(-1.0_pr+4.0_pr*gA2 &
               +16.0_pr*gA4)*u+560.0_pr*(-29.0_pr-10.0_pr*gA2+212.0_pr*gA4)*u3+420.0_pr*(-3.0_pr &
               -16.0_pr*gA2+27.0_pr*gA4)*u5+33.0_pr*(-1.0_pr-10.0_pr*gA2+23.0_pr*gA4)*u7 &
               +16800.0_pr*(-1.0_pr+4.0_pr*gA2+16.0_pr*gA4)*asqu4*Log(2.0_pr)+1680.0_pr*(-4.0_pr &
               -5.0_pr*gA2+22.0_pr*gA4)*u2*asqu4*Log(2.0_pr)+210.0_pr*(-1.0_pr-10.0_pr*gA2 &
               +23.0_pr*gA4)*u4*asqu4*Log(2.0_pr)+105.0_pr*(1.0_pr+10.0_pr*gA2 &
               -23.0_pr*gA4)*u6*asqu4*Log(2.0_pr)+105.0_pr*asqu4*(-((-10.0_pr &
               +u2)*(4.0_pr+u2)**2)-10.0_pr*gA2*(64.0_pr-8*u2-2*u4+u6)+gA4*(-2560.0_pr &
               -352.0_pr*u2-46.0_pr*u4+23.0_pr*u6))*Log(2.0_pr+u*(u+asqu4)))) &
               /(2.064384e7_pr*fpi4*Pi**2*u10)

          dbrhodrho=dbrhodrho+(-420.0_pr*u*(1.0_pr+u2)*asqu4*(15.0_pr-158.0_pr*u2 &
               -8.0_pr*u4-2.0_pr*gA2*(75.0_pr-238.0_pr*u2+8.0_pr*u4)+gA4*(-645.0_pr+2042.0_pr*u2 &
               +56.0_pr*u4))*Log(1.0_pr+2.0_pr*u*(u+asqu))+315.0_pr*asqu &
               *asqu4*(5.0_pr-50.0_pr*gA2-215.0_pr*gA4-36.0_pr*(-1.0_pr+6.0_pr*gA2 & 
               +23.0_pr*gA4)*u2+24.0_pr*(-1.0_pr+2.0_pr*gA2+11.0_pr*gA4)*u4)*Log(1.0_pr+2.0_pr*u*(u &
               +asqu))**2-4.0_pr*u2*asqu*(-1575.0_pr*asqu4 &
               +gA4*(67725.0_pr*asqu4+u*(u*(-1482075.0_pr*asqu4+4.0_pr*u*(u &
               *(-35035.0_pr*asqu4+3.0_pr*u*(u*asqu4*(-847.0_pr+184.0_pr*u2) &
               -3920.0_pr*Log(2.0_pr)))-134400.0_pr*Log(2.0_pr)))-1720320.0_pr*Log(2.0_pr))) &
               +u*(96705.0_pr*u*asqu4+20020.0_pr*u3*asqu4+924.0_pr*u5*asqu4 &
               -96.0_pr*u7*asqu4+6720.0_pr*(4.0_pr+u2)**2*Log(2.0_pr))+2.0_pr*gA2*(7875.0_pr &
               *asqu4+u*(-183645.0_pr*u*asqu4+4900.0_pr*u3*asqu4 &
               +2772.0_pr*u5*asqu4-480.0_pr*u7*asqu4+6720.0_pr*(-8.0_pr+u2) &
               *(4.0_pr+u2)*Log(2.0_pr)))+6720.0_pr*u*(-(4.0_pr+u2)**2+gA2*(64.0_pr+8.0_pr*u2 &
               -2.0_pr*u4)+gA4*(256.0_pr+80.0_pr*u2+7.0_pr*u4))*Log(2.0_pr+u*(u+asqu4)))) &
               /(294912.0_pr*fpi4*Pi**2*u11*asqu*asqu4)

          ddbrhodrho=ddbrhodrho+(420.0_pr*u*asqu*(4.0_pr+u2)**1.5_pr*(-165.0_pr*(-1.0_pr &
               +10.0_pr*gA2+43.0_pr*gA4)+2.0_pr*(-593.0_pr+1730.0_pr*gA2+7571.0_pr*gA4)*u2 &
               +40.0_pr*(-1.0_pr-2.0_pr*gA2+7.0_pr*gA4)*u4)*Log(1.0_pr+2.0_pr*u*(u+asqu)) &
               -315.0_pr*(4.0_pr+u2)**1.5_pr*(-55.0_pr*(-1.0_pr+10.0_pr*gA2+43.0_pr*gA4)-324.0_pr*(-1.0_pr &
               +6.0_pr*gA2+23.0_pr*gA4)*u2+168.0_pr*(-1.0_pr+2.0_pr*gA2+11.0_pr*gA4)*u4)*Log(1.0_pr &
               +2.0_pr*u*(u+asqu))**2+4.0_pr*u2*(-((4.0_pr+u2)*(17325.0_pr*asqu4 &
               +u*(u*(-763875.0_pr*asqu4+4.0_pr*u*(u*(-28805.0_pr*asqu4+3.0_pr*u*(u &
               *asqu4*(-231.0_pr+8*u2)-2800.0_pr*Log(2.0_pr)))-87360.0_pr*Log(2.0_pr))) &
               -860160.0_pr*Log(2.0_pr))))+ gA4*(2979900.0_pr*asqu4-45909045.0_pr*u2*Sqrt(4.0_pr &
               +u2)-14728385.0_pr*u4*asqu4-928508.0_pr*u6*asqu4-21660.0_pr*u8 &
               *asqu4+2208.0_pr*u10*asqu4-6720.0_pr*u*(8192.0_pr+4224.0_pr*u2 &
               +672.0_pr*u4+35.0_pr*u6)*Log(2.0_pr))-2.0_pr*gA2*(4.0_pr+u2)*(-86625.0_pr*asqu4 &
               +u*(1720320.0_pr*Log(2.0_pr)+u*(1443015.0_pr*asqu4+4.0_pr*u*(u*(-9905.0_pr*Sqrt(4.0_pr &
               +u2)+3.0_pr*u*(u*asqu4*(-693.0_pr+40.0_pr*u2)-2800.0_pr*Log(2.0_pr))) &
               +53760.0_pr*Log(2.0_pr)))))+6720.0_pr*u*(512.0_pr*(-1.0_pr+4.0_pr*gA2+16.0_pr*gA4) &
               +48.0_pr*(-7.0_pr+16.0_pr*gA2+88.0_pr*gA4)*u2+24.0_pr*(-3.0_pr+gA2+28.0_pr*gA4)*u4 &
               +5.0_pr*(-1.0_pr-2.0_pr*gA2+7.0_pr*gA4)*u6)*Log(2.0_pr+u*(u+asqu4)))) &
               /(294912.0_pr*fpi4*Pi**2*u12*(4.0_pr+u2)**1.5_pr) 

          adrdr=adrdr +0.0_pr
          dadrdr=dadrdr +0.0_pr
          bdrdr=bdrdr +0.0_pr
          dbdrdr=dbdrdr +0.0_pr

          arhotau=arhotau+(-44100.0_pr*(-1.0_pr+10.0_pr*gA2+127.0_pr*gA4)*u2+4200.0_pr*(-421.0_pr &
               +1516.0_pr*gA2+25369.0_pr*gA4)*u4+420.0_pr*(-283.0_pr-30.0_pr*gA2+8641.0_pr*gA4)*u6 &
               +1680.0_pr*(-19.0_pr-106.0_pr*gA2+5.0_pr*gA4)*u8+464.0_pr*(1.0_pr+10.0_pr*gA2 &
               +13.0_pr*gA4)*u10-420.0_pr*u*asqu*(105.0_pr-1685.0_pr*u2-134.0_pr*u4 &
               -8.0_pr*u6+16.0_pr*u8+10.0_pr*gA2*(-105.0_pr+527.0_pr*u2-22.0_pr*u4-8.0_pr*u6 &
               +16.0_pr*u8)+gA4*(-13335.0_pr+94295.0_pr*u2+2738.0_pr*u4-104.0_pr*u6+208.0_pr*u8)) &
               *Log(1.0_pr+2.0_pr*u*(u+asqu))+11025.0_pr*(1.0_pr-10.0_pr*gA2-127.0_pr*gA4 &
               -9.0_pr*(-1.0_pr+6.0_pr*gA2+83.0_pr*gA4)*u2+8.0_pr*(-1.0_pr+2.0_pr*gA2 &
               +47.0_pr*gA4)*u4)*Log(1.0_pr+2.0_pr*u*(u+asqu))**2)/(1.032192e7_pr*fpi4*Pi**2*u10)

          darhotau=darhotau+(-4.0_pr*u2*(-525.0_pr*(-1.0_pr+10.0_pr*gA2+127.0_pr*gA4)+35.0_pr &
               *(-409.0_pr+1450.0_pr*gA2+24439.0_pr*gA4)*u2+140.0_pr*(-5.0_pr-2.0_pr*gA2 &
               +143.0_pr*gA4)*u4-84.0_pr*(1.0_pr+6.0_pr*gA2+gA4)*u6+16.0_pr*(1.0_pr+10.0_pr*gA2 &
               +13.0_pr*gA4)*u8)*(asqu+2.0_pr*u*(1.0_pr+u*(u+asqu)))+35.0_pr &
               *Log(1.0_pr+2.0_pr*u*(u+asqu))*(4.0_pr*u*(1.0_pr+u2)*(15.0_pr-158.0_pr*u2 &
               -8.0_pr*u4-2.0_pr*gA2*(75.0_pr-238.0_pr*u2+8.0_pr*u4)+gA4*(-1905.0_pr+8690.0_pr*u2 &
               +152.0_pr*u4))*(1.0_pr+2.0_pr*u*(u+asqu))-3.0_pr*(5.0_pr-50.0_pr*gA2 &
               -635.0_pr*gA4-36.0_pr*(-1.0_pr+6.0_pr*gA2+83.0_pr*gA4)*u2+24.0_pr*(-1.0_pr+2.0_pr*gA2 &
               +47.0_pr*gA4)*u4)*(asqu+2.0_pr*u*(1.0_pr+u*(u+asqu)))*Log(1.0_pr &
               +2.0_pr*u*(u+asqu))))/(49152.0_pr*fpi4*Pi**2*u11*asqu*(1.0_pr &
               +2.0_pr*u*(u+asqu)))
          
          ddarhotau=ddarhotau+(4.0_pr*u2*(-5775.0_pr*(-1.0_pr+10.0_pr*gA2+127.0_pr*gA4)+35.0_pr &
               *(-3179.0_pr+11102.0_pr*gA2+188453.0_pr*gA4)*u2+140.0_pr*(-29.0_pr-18.0_pr*gA2 &
               +791.0_pr*gA4)*u4-252.0_pr*(1.0_pr+6.0_pr*gA2+gA4)*u6+16.0_pr*(1.0_pr+10.0_pr*gA2 &
               +13.0_pr*gA4)*u8)*(asqu+4.0_pr*(u+u3)*(1.0_pr+2.0_pr*u*(u+Sqrt(1.0_pr &
               +u2))))-35.0_pr*Log(1.0_pr+2.0_pr*u*(u+asqu))*(4.0_pr*u*(1.0_pr+u2)*(-165.0_pr &
               *(-1.0_pr+10.0_pr*gA2+127.0_pr*gA4)+2.0_pr*(-593.0_pr+1730.0_pr*gA2+32183.0_pr*gA4)*u2 &
               +40.0_pr*(-1.0_pr-2.0_pr*gA2+19.0_pr*gA4)*u4)*(1.0_pr+4.0_pr*u*(asqu &
               +2.0_pr*u*(1.0_pr+u*(u+asqu))))-3.0_pr*(-55.0_pr*(-1.0_pr+10.0_pr*gA2 &
               +127.0_pr*gA4)-324.0_pr*(-1.0_pr+6.0_pr*gA2+83.0_pr*gA4)*u2+168.0_pr*(-1.0_pr &
               +2.0_pr*gA2+47.0_pr*gA4)*u4)*(asqu+4.0_pr*(u+u3)*(1.0_pr+2.0_pr*u*(u &
               +asqu)))*Log(1.0_pr+2.0_pr*u*(u+asqu))))/(49152.0_pr*fpi4*Pi**2*u12 &
               *asqu*(1.0_pr+2.0_pr*u*(u+asqu))**2)

          brhotau=brhotau+(-44100.0_pr*(-1.0_pr+10.0_pr*gA2+43.0_pr*gA4)*u2+4200.0_pr*(-421.0_pr &
               +1516.0_pr*gA2+6169.0_pr*gA4)*u4+420.0_pr*(-283.0_pr-30.0_pr*gA2+2029.0_pr*gA4)*u6 &
               +1680.0_pr*(-19.0_pr-106.0_pr*gA2+185.0_pr*gA4)*u8-464.0_pr*(-1.0_pr-10.0_pr*gA2 &
               +23.0_pr*gA4)*u10+105.0_pr*Log(1.0_pr+2.0_pr*u*(u+asqu))*(4.0_pr*u*Sqrt(1.0_pr &
               +u2)*(-105.0_pr+1685.0_pr*u2+134.0_pr*u4+8.0_pr*u6-16.0_pr*u8+10.0_pr*gA2*(105.0_pr &
               -527.0_pr*u2+22.0_pr*u4+8.0_pr*u6-16.0_pr*u8)+gA4*(4515.0_pr-22235.0_pr*u2 &
               -842.0_pr*u4-184.0_pr*u6+368.0_pr*u8))+105.0_pr*(1.0_pr+9.0_pr*u2-8.0_pr*u4 &
               +2.0_pr*gA2*(-5.0_pr-27.0_pr*u2+8.0_pr*u4)+gA4*(-43.0_pr-207.0_pr*u2+88.0_pr*u4)) &
               *Log(1.0_pr+2.0_pr*u*(u+asqu))))/(5.16096e6*fpi4*Pi**2*u10)

          dbrhotau=dbrhotau+(4.0_pr*u2*(525.0_pr*(-1.0_pr+10.0_pr*gA2+43.0_pr*gA4)-35.0_pr*(-409.0_pr &
               +1450.0_pr*gA2+5923.0_pr*gA4)*u2+140.0_pr*(5.0_pr+2.0_pr*gA2-35.0_pr*gA4)*u4 &
               +84.0_pr*(1.0_pr+6.0_pr*gA2-11.0_pr*gA4)*u6+16.0_pr*(-1.0_pr-10.0_pr*gA2 &
               +23.0_pr*gA4)*u8)*(asqu+2.0_pr*u*(1.0_pr+u*(u+asqu)))+35.0_pr &
               *Log(1.0_pr+2.0_pr*u*(u+asqu))*(4.0_pr*u*(1.0_pr+u2)*(15.0_pr-158.0_pr*u2 &
               -8.0_pr*u4-2.0_pr*gA2*(75.0_pr-238.0_pr*u2+8.0_pr*u4)+gA4*(-645.0_pr+2042.0_pr*u2 &
               +56.0_pr*u4))*(1.0_pr+2.0_pr*u*(u+asqu))-3.0_pr*(5.0_pr-50.0_pr*gA2 &
               -215.0_pr*gA4-36.0_pr*(-1.0_pr+6.0_pr*gA2+23.0_pr*gA4)*u2+24.0_pr*(-1.0_pr+2.0_pr*gA2 &
               +11.0_pr*gA4)*u4)*(asqu+2.0_pr*u*(1.0_pr+u*(u+asqu)))*Log(1.0_pr &
               +2.0_pr*u*(u+asqu))))/(24576.0_pr*fpi4*Pi**2*u11*asqu*(1.0_pr &
               +2.0_pr*u*(u+asqu)))

          ddbrhotau=ddbrhotau+(-4.0_pr*u2*(5775.0_pr*(-1.0_pr+10.0_pr*gA2+43.0_pr*gA4)-35.0_pr &
               *(-3179.0_pr+11102.0_pr*gA2+45545.0_pr*gA4)*u2+140.0_pr*(29.0_pr+18.0_pr*gA2 &
               -203.0_pr*gA4)*u4-252.0_pr*(-1.0_pr-6.0_pr*gA2+11.0_pr*gA4)*u6+16.0_pr*(-1.0_pr &
               -10.0_pr*gA2+23.0_pr*gA4)*u8)*(asqu+4.0_pr*(u+u3)*(1.0_pr+2.0_pr*u*(u &
               +asqu)))-35.0_pr*Log(1.0_pr+2.0_pr*u*(u+asqu))*(4.0_pr*u*(1.0_pr &
               +u2)*(-165.0_pr*(-1.0_pr+10.0_pr*gA2+43.0_pr*gA4)+2.0_pr*(-593.0_pr+1730.0_pr*gA2 &
               +7571.0_pr*gA4)*u2+40.0_pr*(-1.0_pr-2.0_pr*gA2+7.0_pr*gA4)*u4)*(1.0_pr+4.0_pr*u &
               *(asqu+2.0_pr*u*(1.0_pr+u*(u+asqu))))-3.0_pr*(-55.0_pr*(-1.0_pr &
               +10.0_pr*gA2+43.0_pr*gA4)-324.0_pr*(-1.0_pr+6.0_pr*gA2+23.0_pr*gA4)*u2 &
               +168.0_pr*(-1.0_pr+2.0_pr*gA2+11.0_pr*gA4)*u4)*(asqu+4.0_pr*(u+u3)*(1.0_pr &
               +2.0_pr*u*(u+asqu)))*Log(1.0_pr+2.0_pr*u*(u+asqu)))) &
               /(24576.0_pr*fpi4*Pi**2*u12*asqu*(1.0_pr+2.0_pr*u*(u+asqu))**2)

          ajj=ajj+(4.0_pr*u2*(-9.0_pr+24.0_pr*u2+u4+gA4*(18.0_pr-363.0_pr*u2-113.0_pr*u4) &
               +2.0_pr*gA2*(9.0_pr+66.0_pr*u2+5.0_pr*u4))-12.0_pr*u*asqu*(-3.0_pr+u2 &
               -2.0_pr*u4+2.0_pr*gA2*(3.0_pr+5.0_pr*u2-10.0_pr*u4)+gA4*(6.0_pr-59.0_pr*u2 &
               +10.0_pr*u4))*Log(1.0_pr+2.0_pr*u*(u+asqu))+9.0_pr*(-1.0_pr+2.0_pr*gA2 &
               +2.0_pr*gA4+3.0_pr*(-1.0_pr-2.0_pr*gA2+gA4)*u2)*Log(1.0_pr+2.0_pr*u*(u &
               +asqu))**2)/(73728.0_pr*fpi4*Pi**2*u6)

          dajj=dajj+(-4.0_pr*u2*(-9.0_pr+9.0_pr*u2-2.0_pr*u4+2.0_pr*gA2*(9.0_pr+27.0_pr*u2 &
               -10.0_pr*u4)+2.0_pr*gA4*(9.0_pr-90.0_pr*u2+5.0_pr*u4))*(asqu+2.0_pr*u &
               *(1.0_pr+u*(u+asqu)))-9.0_pr*Log(1.0_pr+2.0_pr*u*(u+asqu)) &
               *(4.0_pr*u*(1.0_pr+u2-2.0_pr*gA2*(1.0_pr+u2)+gA4*(-2.0_pr+8.0_pr*u2+6.0_pr*u4)) &
               *(1.0_pr+2.0_pr*u*(u+asqu))+(-1.0_pr-2.0_pr*u2+2.0_pr*gA2*(1.0_pr+gA2 &
               +(-2.0_pr+gA2)*u2))*(asqu+2.0_pr*u*(1.0_pr+u*(u+asqu))) &
               *Log(1.0_pr+2.0_pr*u*(u+asqu))))/(12288.0_pr*fpi4*Pi**2*u7*asqu &
               *(1.0_pr+2.0_pr*u*(u+asqu)))

          bjj=bjj+(4.0_pr*u2*(-9.0_pr+24.0_pr*u2+u4+gA4*(99.0_pr-228.0_pr*u2-23.0_pr*u4) &
               +2.0_pr*gA2*(9.0_pr+66.0_pr*u2+5.0_pr*u4))-12.0_pr*u*asqu*(-3.0_pr+u2 &
               -2.0_pr*u4+2.0_pr*gA2*(3.0_pr+5.0_pr*u2-10.0_pr*u4)+gA4*(33.0_pr-23.0_pr*u2 &
               +46.0_pr*u4))*Log(1.0_pr+2.0_pr*u*(u+asqu))+9.0_pr*(-1.0_pr+2.0_pr*gA2 &
               +11.0_pr*gA4+3.0_pr*(-1.0_pr-2.0_pr*gA2+7.0_pr*gA4)*u2)*Log(1.0_pr+2.0_pr*u*(u &
               +asqu))**2)/(36864.0_pr*fpi4*Pi**2*u6)

          dbjj=dbjj+(-4.0_pr*u2*(-9.0_pr+9.0_pr*u2-2.0_pr*u4+2.0_pr*gA2*(9.0_pr+27.0_pr*u2 &
               -10.0_pr*u4)+gA4*(99.0_pr-99.0_pr*u2+46.0_pr*u4))*(asqu+2.0_pr*u*(1.0_pr &
               +u*(u+asqu)))+36.0_pr*u*(-1.0_pr-u2+2.0_pr*gA2*(1.0_pr+u2)+gA4*(11.0_pr &
               +7.0_pr*u2))*(1.0_pr+2.0_pr*u*(u+asqu))*Log(1.0_pr+2.0_pr*u*(u+Sqrt(1.0_pr &
               +u2)))-9.0_pr*(-1.0_pr+2.0_pr*gA2+11.0_pr*gA4+2.0_pr*(-1.0_pr-2.0_pr*gA2 &
               +7.0_pr*gA4)*u2)*(asqu+2.0_pr*u*(1.0_pr+u*(u+asqu)))*Log(1.0_pr &
               +2.0_pr*u*(u+asqu))**2)/(6144.0_pr*fpi4*Pi**2*u7*asqu*(1.0_pr &
               +2.0_pr*u*(u+asqu)))
       Else    !! u smaller than ucut
          arhorho=arhorho +((-1.0_pr - 4.0_pr*gA2 + 8.0_pr*gA**4)*mpi2)/(384.0_pr*fpi4*Pi**2) &
               + (11.0_pr*(1.0_pr + 14.0_pr*gA2 + 17.0_pr*gA**4)*mpi2*u4)/(201600.0_pr*fpi4*Pi**2) &
               - ((1.0_pr + 18.0_pr*gA2 + 13.0_pr*gA**4)*mpi2*u6)/(69300.0_pr*fpi4*Pi**2)
          darhorho=darhorho+(mpi2*u3*(121.0_pr*(1.0_pr+14.0_pr*gA2+17.0_pr*gA4)-48.0_pr*(1.0_pr &
               +18.0_pr*gA2+13.0_pr*gA4)*u2))/(554400.0_pr*fpi4*Pi**2)
          ddarhorho=ddarhorho+(mpi2*u2*(1573.0_pr*(1.0_pr+14.0_pr*gA2+17.0_pr*gA4)-1040.0_pr*(1.0_pr &
               +18.0_pr*gA2+13.0_pr*gA4)*u2+680.0_pr*(1.0_pr+22.0_pr*gA2+gA4)*u4)) &
               /(2.4024e6_pr*fpi4*Pi**2)
          
          brhorho=brhorho +((-1.0_pr - 4.0_pr*gA2 + 8.0_pr*gA**4)*mpi2)/(192.0_pr*fpi4*Pi**2) &
               - (11.0_pr*(-1.0_pr - 14.0_pr*gA2 + 43.0_pr*gA**4)*mpi2*u4)/(100800.0_pr*fpi4*Pi**2) &
               + ((-1.0_pr - 18.0_pr*gA2 + 71.0_pr*gA**4)*mpi2*u6)/(34650.0_pr*fpi4*Pi**2)
          dbrhorho=dbrhorho+(mpi2*u3*(121.0_pr*(1.0_pr+14.0_pr*gA2-43.0_pr*gA4)+48.0_pr*(-1.0_pr &
               -18.0_pr*gA2+71.0_pr*gA4)*u2))/(277200.0_pr*fpi4*Pi**2)
          ddbrhorho=ddbrhorho+(mpi2*u2*(-1573.0_pr*(-1.0_pr-14.0_pr*gA2+43.0_pr*gA4)+1040.0_pr &
               *(-1.0_pr-18.0_pr*gA2+71.0_pr*gA4)*u2-680.0_pr*(-1.0_pr-22.0_pr*gA2 &
               +107.0_pr*gA4)*u4))/(1.2012e6_pr*fpi4*Pi**2)

          arhodrho=arhodrho+(120120.0_pr*(-2.0_pr-17.0_pr*gA2+88.0_pr*gA4)+8008.0_pr*(1.0_pr &
               +14.0_pr*gA2+167.0_pr*gA4)*u2-39.0_pr*(109.0_pr+1962.0_pr*gA2+4357.0_pr*gA4)*u4 &
               +540.0_pr*(3.0_pr+66.0_pr*gA2+31.0_pr*gA4)*u6)/(5.5351296e8_pr*fpi4*Pi**2)
          darhodrho=darhodrho+(4004.0_pr*(1.0_pr+14.0_pr*gA2+167.0_pr*gA4)*u-39.0_pr*(109.0_pr &
               +1962.0_pr*gA2+4357.0_pr*gA4)*u3+810.0_pr*(3.0_pr+66.0_pr*gA2+31.0_pr*gA4)*u5) &
               /(1.3837824e8_pr*fpi4*Pi**2)
          ddarhodrho=ddarhodrho+(12012.0_pr*(1.0_pr+14.0_pr*gA2+167.0_pr*gA4)-351.0_pr*(109.0_pr &
               +1962.0_pr*gA2+4357.0_pr*gA4)*u2+12150.0_pr*(3.0_pr+66.0_pr*gA2+31.0_pr*gA4)*u4 &
               +35.0_pr*(-811.0_pr-21086.0_pr*gA2+12637.0_pr*gA4)*u6)/(4.1513472e8_pr*fpi4*Pi**2)

          brhodrho=brhodrho -(480480.0_pr*(-2.0_pr-17.0_pr*gA2+34.0_pr*gA4)+76076.0_pr*(-1.0_pr &
               -14.0_pr*gA2+43.0_pr*gA4)*u2-12597.0_pr*(-1.0_pr-18.0_pr*gA2+71.0_pr*gA4)*u4 &
               +3660.0_pr*(-1.0_pr-22.0_pr*gA2+107.0_pr*gA4)*u6)/(5.5351296e8_pr*fpi4*Pi**2) 
          dbrhodrho=dbrhodrho+(-38038.0_pr*(-1.0_pr-14.0_pr*gA2+43.0_pr*gA4)*u+12597.0_pr*(-1.0_pr &
               -18.0_pr*gA2+71.0_pr*gA4)*u3-5490.0_pr*(-1.0_pr-22.0_pr*gA2+107.0_pr*gA4)*u5) &
               /(1.3837824e8_pr*fpi4*Pi**2)
          ddbrhodrho=ddbrhodrho+(-114114.0_pr*(-1.0_pr-14.0_pr*gA2+43.0_pr*gA4)+113373.0_pr*(-1.0_pr &
               -18.0_pr*gA2+71.0_pr*gA4)*u2-82350.0_pr*(-1.0_pr-22.0_pr*gA2+107.0_pr*gA4)*u4 &
               +58975.0_pr*(-1.0_pr-26.0_pr*gA2+151.0_pr*gA4)*u6)/(4.1513472e8_pr*fpi4*Pi**2)

          adrdr=adrdr +0.0_pr
          dadrdr=dadrdr +0.0_pr
          bdrdr=bdrdr +0.0_pr
          dbdrdr=dbdrdr +0.0_pr

          arhotau=arhotau -(30030.0_pr*(2.0_pr+17.0_pr*gA2+20.0_pr*gA4)+7007.0_pr*(1.0_pr+14.0_pr*gA2 &
               +17.0_pr*gA4)*u2-1404.0_pr*(1.0_pr+18.0_pr*gA2+13.0_pr*gA4)*u4+440.0_pr*(1.0_pr &
               +22.0_pr*gA2+gA4)*u6)/(3.459456e7_pr*fpi4*Pi**2)
          darhotau=darhotau+(-7007.0_pr*(1.0_pr+14.0_pr*gA2+17.0_pr*gA4)*u+2808.0_pr*(1.0_pr &
               +18.0_pr*gA2+13.0_pr*gA4)*u3-1320.0_pr*(1.0_pr+22.0_pr*gA2+gA4)*u5) &
               /(1.729728e7_pr*fpi4*Pi**2)
          ddarhotau=ddarhotau -(21021.0_pr*(1.0_pr+14.0_pr*gA2+17.0_pr*gA4)-25272.0_pr*(1.0_pr &
               +18.0_pr*gA2+13.0_pr*gA4)*u2+19800.0_pr*(1.0_pr+22.0_pr*gA2+gA4)*u4+14560.0_pr &
               *(-1.0_pr-26.0_pr*gA2+19.0_pr*gA4)*u6)/(5.189184e7_pr*fpi4*Pi**2) 

          brhotau=brhotau+(30030.0_pr*(-2.0_pr-17.0_pr*gA2+34.0_pr*gA4)+7007.0_pr*(-1.0_pr &
               -14.0_pr*gA2+43.0_pr*gA4)*u2-1404.0_pr*(-1.0_pr-18.0_pr*gA2+71.0_pr*gA4)*u4 &
               +440.0_pr*(-1.0_pr-22.0_pr*gA2+107.0_pr*gA4)*u6)/(1.729728e7_pr*fpi4*Pi**2)
          dbrhotau=dbrhotau+(7007.0_pr*(-1.0_pr-14.0_pr*gA2+43.0_pr*gA4)*u-2808.0_pr*(-1.0_pr &
               -18.0_pr*gA2+71.0_pr*gA4)*u3+1320.0_pr*(-1.0_pr-22.0_pr*gA2+107.0_pr*gA4)*u5) &
               /(8.64864e6_pr*fpi4*Pi**2)
          ddbrhotau=ddbrhotau+(21021.0_pr*(-1.0_pr-14.0_pr*gA2+43.0_pr*gA4)-25272.0_pr*(-1.0_pr &
               -18.0_pr*gA2+71.0_pr*gA4)*u2+19800.0_pr*(-1.0_pr-22.0_pr*gA2+107.0_pr*gA4)*u4 &
               -14560.0_pr*(-1.0_pr-26.0_pr*gA2+151.0_pr*gA4)*u6)/(2.594592e7_pr*fpi4*Pi**2)

          ajj=ajj+(-1050.0_pr*(-2.0_pr-17.0_pr*gA2+7.0_pr*gA4)+315.0_pr*(1.0_pr+14.0_pr*gA2 &
               -28.0_pr*gA4)*u2+81.0_pr*(-1.0_pr-18.0_pr*gA2+57.0_pr*gA4)*u4+16.0_pr*(2.0_pr &
               +44.0_pr*gA2-187.0_pr*gA4)*u6)/(2.4192e6_pr*fpi4*Pi**2)
          dajj=dajj+(105.0_pr*(1.0_pr+14.0_pr*gA2-28.0_pr*gA4)*u+54.0_pr*(-1.0_pr-18.0_pr*gA2 &
               +57.0_pr*gA4)*u3+16.0_pr*(2.0_pr+44.0_pr*gA2-187.0_pr*gA4)*u5)/(403200.0_pr*fpi4*Pi**2)

          bjj=bjj+(-1050.0_pr*(-2.0_pr-17.0_pr*gA2+34.0_pr*gA4)-315.0_pr*(-1.0_pr-14.0_pr*gA2 &
               +43.0_pr*gA4)*u2+81.0_pr*(-1.0_pr-18.0_pr*gA2+71.0_pr*gA4)*u4+32.0_pr*(1.0_pr &
               +22.0_pr*gA2-107.0_pr*gA4)*u6)/(1.2096e6_pr*fpi4*Pi**2)
          dbjj=dbjj+(105.0_pr*(1.0_pr+14.0_pr*gA2-43.0_pr*gA4)*u+54.0_pr*(-1.0_pr-18.0_pr*gA2 &
               +71.0_pr*gA4)*u3+32.0_pr*(1.0_pr+22.0_pr*gA2-107.0_pr*gA4)*u5)/(201600.0_pr*fpi4*Pi**2)

       End If     !! if (u.gt.ucut...
    End If    !! if (dmeorder.ge.1....
    !
    ! N2LO, 2N terms
    !
    If (dmeorder.Ge.2) Then
       If (u.Gt.ucut) Then
          arhorho=arhorho +(gA2*mpi**3*(u2*(210.0_pr*(-129.0_pr*c3 + 56.0_pr*c4) + 6.0_pr*(38607.0_pr*c3 &
               - 27325.0_pr*c4)*u2 + 7.0_pr*(3165.0_pr*c3 - 2014.0_pr*c4)*u4 + 2714.0_pr*(3.0_pr*c3 &
               + c4)*u6 + 570.0_pr*(3.0_pr*c3 + c4)*u8 - 66.0_pr*c1*(1050.0_pr - 6366.0_pr*u2 + 299.0_pr*u4 &
               + 237.0_pr*u6)) + 3.0_pr*u3*(-242550.0_pr*c1 + 6237.0_pr*(2.0_pr*c1 - c3)*u4 &
               + 572.0_pr*(3.0_pr*c1 - 3.0_pr*c3 - c4)*u6 + 190.0_pr*(3.0_pr*c3 + c4)*u8 - 1155.0_pr*(3.0_pr*c3 &
               - 2.0_pr*c4)*(35.0_pr + 2.0_pr*u2))*Atan(u) - 6.0_pr*(-35.0_pr*(330.0_pr*c1 + 129.0_pr*c3 &
               - 56.0_pr*c4) - 352.0_pr*(162.0_pr*c1 + 69.0_pr*c3 - 40.0_pr*c4)*u2 + 891.0_pr*(14.0_pr*c1 &
               + 11.0_pr*c3 - 8.0_pr*c4)*u4)*Log(1.0_pr + u2)))/(110880.0_pr*fpi4*Pi*u8)

          darhorho=darhorho+(gA2*mpi**3*(1680.0_pr*(330.0_pr*c1+129.0_pr*c3-56.0_pr*c4)*u2 &
               -3.0_pr*(620862.0_pr*c1+351039.0_pr*c3-250970.0_pr*c4)*u4+(71742.0_pr*c1-56163.0_pr*c3 &
               +30482.0_pr*c4)*u6+18.0_pr*(286.0_pr*c1-127.0_pr*(3.0_pr*c3+c4))*u8+1710.0_pr*(3.0_pr*c3 &
               +c4)*u10+3.0_pr*u3*(1212750.0_pr*c1-6237.0_pr*(2.0_pr*c1-c3)*u4+572.0_pr*(3.0_pr*c1 &
               -3.0_pr*c3-c4)*u6+570.0_pr*(3.0_pr*c3+c4)*u8+1155.0_pr*(3.0_pr*c3-2.0_pr*c4)*(175.0_pr &
               +6.0_pr*u2))*Atan(u)+24.0_pr*(-70.0_pr*(330.0_pr*c1+129.0_pr*c3-56.0_pr*c4)-528.0_pr*(162.0_pr*c1 &
               +69.0_pr*c3-40.0_pr*c4)*u2+891.0_pr*(14.0_pr*c1+11.0_pr*c3-8.0_pr*c4)*u4)*Log(1.0_pr+u2))) &
               /(110880.0_pr*fpi4*Pi*u9)

          ddarhorho=ddarhorho+(gA2*mpi**3*(-2520.0_pr*(330.0_pr*c1+129.0_pr*c3-56.0_pr*c4)*u2 &
               +21.0_pr*(79002.0_pr*c1+45789.0_pr*c3-32950.0_pr*c4)*u4-9.0_pr*(4774.0_pr*c1-3657.0_pr*c3 &
               +1630.0_pr*c4)*u6-190.0_pr*(3.0_pr*c3+c4)*u8+570.0_pr*(3.0_pr*c3+c4)*u10 &
               +3.0_pr*(u3*(-1212750.0_pr*c1-2079.0_pr*(-2.0_pr*c1+c3)*u4+190.0_pr*(3.0_pr*c3+c4)*u8 &
               -1155.0_pr*(3.0_pr*c3-2.0_pr*c4)*(175.0_pr+4.0_pr*u2))*Atan(u)+4.0_pr*(210.0_pr*(330.0_pr*c1 &
               +129.0_pr*c3-56.0_pr*c4)+1232.0_pr*(162.0_pr*c1+69.0_pr*c3-40.0_pr*c4)*u2-1485.0_pr*(14.0_pr*c1 &
               +11.0_pr*c3-8.0_pr*c4)*u4)*Log(1.0_pr+u2))))/(18480.0_pr*fpi4*Pi*u10)

          brhorho=brhorho +(c4*gA2*mpi**3*(u2*(5880.0_pr - 81975.0_pr*u2 - 7049.0_pr*u4 + 1357.0_pr*u6 &
               + 285.0_pr*u8) + 3.0_pr*u3*(40425.0_pr + 2310.0_pr*u2 - 286.0_pr*u6 + 95.0_pr*u8)*Atan(u) &
               + 24.0_pr*(-245.0_pr - 1760.0_pr*u2 + 891.0_pr*u4)*Log(1.0_pr + u2)))/(27720.0_pr*fpi4*Pi*u8)

          dbrhorho=dbrhorho+(c4*gA2*mpi**3*(u2*(-47040.0_pr+376455.0_pr*u2+15241.0_pr*u4 &
               -1143.0_pr*u6+855.0_pr*u8)+3.0_pr*u3*(-202125.0_pr-6930.0_pr*u2-286.0_pr*u6 &
               +285.0_pr*u8)*Atan(u)-96.0_pr*(-490.0_pr-2640.0_pr*u2+891.0_pr*u4)*Log(1.0_pr+u2))) &
               /(27720.0_pr*fpi4*Pi*u9)

          ddbrhorho=ddbrhorho+(c4*gA2*mpi**3*(u2*(14112.0_pr-69195.0_pr*u2-1467.0_pr*u4-19.0_pr*u6 &
               +57.0_pr*u8)+3.0_pr*u3*(40425.0_pr+924.0_pr*u2+19.0_pr*u8)*Atan(u)+48.0_pr*(-294.0_pr &
               -1232.0_pr*u2+297.0_pr*u4)*Log(1.0_pr+u2)))/(924.0_pr*fpi4*Pi*u10)

          arhodrho=arhodrho+(gA2*mpi*(10395.0_pr*u3*(4.0_pr+u2)*(8.0_pr*c1*(40.0_pr-10.0_pr*u2+u4) &
               +c3*(160.0_pr+8.0_pr*u2+4.0_pr*u4-3.0_pr*u6))*Atan(0.5_pr*u)-2.0_pr*(480.0_pr*(330.0_pr*c1 &
               +129.0_pr*c3-56.0_pr*c4)*u2+48.0_pr*(49038.0_pr*c1+23511.0_pr*c3+7870.0_pr*c4)*u4 &
               +32.0_pr*(-7953.0_pr*c1+10545.0_pr*c3+479.0_pr*c4)*u6-12.0_pr*(5874.0_pr*c1-2769.0_pr*c3 &
               +232.0_pr*c4)*u8+27.0_pr*(147.0_pr*c3+16.0_pr*c4)*u10-48.0_pr*u3*(-5775.0_pr*(6.0_pr*c1 &
               +3.0_pr*c3-2.0_pr*c4)+297.0_pr*(2.0_pr*c1-c3)*u4+88.0_pr*(-3.0_pr*c1+3.0_pr*c3+c4)*u6 &
               +90.0_pr*(3.0_pr*c3+c4)*u8)*Atan(u)+48.0_pr*(-1290.0_pr*c3+560.0_pr*c4+33.0_pr*(-100.0_pr*c1 &
               -3.0_pr*(162.0_pr*c1+69.0_pr*c3-40.0_pr*c4)*u2+9.0_pr*(14.0_pr*c1+11.0_pr*c3 &
               -8.0_pr*c4)*u4))*Log(1.0_pr+u2))))/(1.216512e6_pr*fpi4*Pi*u10)

          darhodrho=darhodrho+(gA2*mpi*(-10395.0_pr*u3*(8960.0_pr*c1+72.0_pr*(-2.0_pr*c1+c3)*u4 &
               +8.0_pr*(c1-c3)*u6+3.0_pr*c3*u8+320.0_pr*c3*(14.0_pr+3.0_pr*u2))*Atan(0.5_pr*u) &
               +2.0_pr*(4800.0_pr*(330.0_pr*c1+129.0_pr*c3-56.0_pr*c4)*u2+48.0_pr*(354354.0_pr*c1+169473.0_pr*c3 &
               +51970.0_pr*c4)*u4+8.0_pr*(-226050.0_pr*c1+177369.0_pr*c3+7676.0_pr*c4)*u6 &
               -12.0_pr*(5874.0_pr*c1-8979.0_pr*c3+472.0_pr*c4)*u8+135.0_pr*(-135.0_pr*c3+32.0_pr*c4)*u10 &
               +48.0_pr*u3*(40425.0_pr*(6.0_pr*c1+3.0_pr*c3-2.0_pr*c4)+891.0_pr*(-2.0_pr*c1+c3)*u4 &
               +88.0_pr*(3.0_pr*c1-3.0_pr*c3-c4)*u6+90.0_pr*(3.0_pr*c3+c4)*u8)*Atan(u) &
               +96.0_pr*(-50.0_pr*(330.0_pr*c1+129.0_pr*c3-56.0_pr*c4)-396.0_pr*(162.0_pr*c1+69.0_pr*c3 &
               -40.0_pr*c4)*u2+891.0_pr*(14.0_pr*c1+11.0_pr*c3-8.0_pr*c4)*u4)*Log(1.0_pr+u2)))) &
               /(1.216512e6_pr*fpi4*Pi*u11)

          ddarhodrho=ddarhodrho+(gA2*mpi*(-2400.0_pr*(330.0_pr*c1+129.0_pr*c3-56.0_pr*c4)*u2 &
               -24.0_pr*(273126.0_pr*c1+129687.0_pr*c3+34280.0_pr*c4)*u4-4.0_pr*(229530.0_pr*c1+264813.0_pr*c3 &
               +56912.0_pr*c4)*u6+16.0_pr*(8052.0_pr*c1-6513.0_pr*c3-188.0_pr*c4)*u8+6.0_pr*(267.0_pr*(c1 &
               -c3)+16.0_pr*c4)*u10+3.0_pr*(4.0_pr+u2)*(315.0_pr*u3*(2240.0_pr*(2.0_pr*c1+c3) &
               +360.0_pr*c3*u2+18.0_pr*(-2.0_pr*c1+c3)*u4+(c1-c3)*u6)*Atan(0.5_pr*u) &
               -4.0_pr*(2.0_pr*u3*(7350.0_pr*(6.0_pr*c1+3.0_pr*c3-2.0_pr*c4)+81.0_pr*(-2.0_pr*c1+c3)*u4 &
               -4.0_pr*(-3.0_pr*c1+3.0_pr*c3+c4)*u6)*Atan(u)+(-50.0_pr*(330.0_pr*c1+129.0_pr*c3-56.0_pr*c4) &
               -324.0_pr*(162.0_pr*c1+69.0_pr*c3-40.0_pr*c4)*u2+567.0_pr*(14.0_pr*c1+11.0_pr*c3 &
               -8.0_pr*c4)*u4)*Log(1.0_pr+u2)))))/(6912.0_pr*fpi4*Pi*u12*(4.0_pr+u2))

          brhodrho=brhodrho+(gA2*mpi*(-99.0_pr*u3*(33600.0_pr*(2.0_pr*c1+c3)*u+560.0_pr*(-10.0_pr*c1 &
               +13.0_pr*c3)*u3+840.0_pr*(-2.0_pr*c1+c3)*u5+54.0_pr*c3*u7-105.0_pr*(4.0_pr+u2) &
               *(8.0_pr*c1*(40.0_pr-10.0_pr*u2+u4)+c3*(160.0_pr+8.0_pr*u2+4.0_pr*u4-3.0_pr*u6)) &
               *Atan(0.5_pr*u))+64.0_pr*c4*(u2*(1680.0_pr-23610.0_pr*u2-958.0_pr*u4+174.0_pr*u6 &
               -27.0_pr*u8)+6.0_pr*u3*(5775.0_pr+44.0_pr*u6+45.0_pr*u8)*Atan(u)+24.0_pr*(-70.0_pr &
               +99.0_pr*u2*(-5.0_pr+3.0_pr*u2))*Log(1.0_pr+u2))))/(1.216512e6_pr*fpi4*Pi*u10)

          dbrhodrho=dbrhodrho+(gA2*mpi*(2.0_pr*u2*(11642400.0_pr*(2.0_pr*c1+c3)*u2+64.0_pr*c4*( &
               -8400.0_pr+77955.0_pr*u2+1919.0_pr*u4-177.0_pr*u6+135.0_pr*u8)-3465.0_pr*u4 &
               *(8.0_pr*c1*(70+3*u2)+c3*(-440.0_pr+9.0_pr*u2*(-4.0_pr+u2))))-3.0_pr*(3465.0_pr*u3 &
               *(8960.0_pr*c1+72.0_pr*(-2.0_pr*c1+c3)*u4+8.0_pr*(c1-c3)*u6+3.0_pr*c3*u8+320.0_pr*c3 &
               *(14.0_pr+3.0_pr*u2))*Atan(0.5_pr*u)-128.0_pr*c4*(u3*(-40425.0_pr-44.0_pr*u6+45.0_pr*u8) &
               *Atan(u)+8.0_pr*(350.0_pr+99.0_pr*u2*(20.0_pr-9.0_pr*u2))*Log(1.0_pr+u2))))) &
               /(1.216512e6_pr*fpi4*Pi*u11)

          ddbrhodrho=ddbrhodrho+(gA2*mpi*(2.0_pr*u2*(32.0_pr*c4*(4.0_pr+u2)*(1050.0_pr-6690.0_pr*u2 &
               -106.0_pr*u4+3.0_pr*u6)+315.0_pr*u2*(-6720.0_pr*(2.0_pr*c1+c3)-40.0_pr*(56.0_pr*c1 &
               +55.0_pr*c3)*u2+2.0_pr*(110.0_pr*c1-89.0_pr*c3)*u4+3.0_pr*(c1-c3)*u6))+3.0_pr*(4.0_pr &
               +u2)*(315.0_pr*u3*(2240.0_pr*(2.0_pr*c1+c3)+360.0_pr*c3*u2+18.0_pr*(-2.0_pr*c1+c3)*u4+(c1 &
               -c3)*u6)*Atan(0.5_pr*u)+64.0_pr*c4*(u3*(3675.0_pr+u6)*Atan(u)+(-350.0_pr+81.0_pr*u2 &
               *(-20.0_pr+7.0_pr*u2))*Log(1.0_pr+u2)))))/(6912.0_pr*fpi4*Pi*u12*(4.0_pr+u2))

          adrdr=adrdr+0.0_pr
          dadrdr=dadrdr+0.0_pr
          bdrdr=bdrdr+0.0_pr
          dbdrdr=dbdrdr+0.0_pr

          arhotau=arhotau+(gA2*mpi*(60.0_pr*(330.0_pr*c1+129.0_pr*c3-56.0_pr*c4)*u2-6.0_pr*(20262.0_pr*c1 &
               +11139.0_pr*c3-7870.0_pr*c4)*u4+(2838.0_pr*c1-2865.0_pr*c3+1916.0_pr*c4)*u6 &
               +12.0_pr*(132.0_pr*c1-29.0_pr*(3.0_pr*c3+c4))*u8+54.0_pr*(3.0_pr*c3+c4)*u10 &
               -6.0_pr*u3*(-5775.0_pr*(6.0_pr*c1+3.0_pr*c3-2.0_pr*c4)+297.0_pr*(2.0_pr*c1-c3)*u4 &
               +88.0_pr*(-3.0_pr*c1+3.0_pr*c3+c4)*u6+90.0_pr*(3.0_pr*c3+c4)*u8)*Atan(u) &
               +6.0_pr*(-1290.0_pr*c3+560.0_pr*c4+33.0_pr*(-100.0_pr*c1-3.0_pr*(162.0_pr*c1+69.0_pr*c3 &
               -40.0_pr*c4)*u2+9.0_pr*(14.0_pr*c1+11.0_pr*c3-8.0_pr*c4)*u4))*Log(1.0_pr+u2))) &
               /(19008.0_pr*fpi4*Pi*u10)

          darhotau=darhotau -(gA2*mpi*(300.0_pr*(330.0_pr*c1+129.0_pr*c3-56.0_pr*c4)*u2 &
               -3.0_pr*(130746.0_pr*c1+73077.0_pr*c3-51970.0_pr*c4)*u4+(8250.0_pr*c1-6603.0_pr*c3 &
               +3838.0_pr*c4)*u6+6.0_pr*(132.0_pr*c1-59.0_pr*(3.0_pr*c3+c4))*u8+270.0_pr*(3.0_pr*c3 &
               +c4)*u10+3.0_pr*u3*(40425.0_pr*(6.0_pr*c1+3.0_pr*c3-2.0_pr*c4)+891.0_pr*(-2.0_pr*c1 &
               +c3)*u4+88.0_pr*(3.0_pr*c1-3.0_pr*c3-c4)*u6+90.0_pr*(3.0_pr*c3+c4)*u8)*Atan(u) &
               +6.0_pr*(-50.0_pr*(330.0_pr*c1+129.0_pr*c3-56.0_pr*c4)-396.0_pr*(162.0_pr*c1+69.0_pr*c3 &
               -40.0_pr*c4)*u2+891.0_pr*(14.0_pr*c1+11.0_pr*c3-8.0_pr*c4)*u4)*Log(1.0_pr+u2))) &
               /(9504.0_pr*fpi4*Pi*u11)

          ddarhotau=ddarhotau+(gA2*mpi*(150.0_pr*(330.0_pr*c1+129.0_pr*c3-56.0_pr*c4)*u2 &
               -3.0_pr*(43962.0_pr*c1+24969.0_pr*c3-17840.0_pr*c4)*u4+(2154.0_pr*c1-1695.0_pr*c3 &
               +848.0_pr*c4)*u6-24.0_pr*(-3.0_pr*c1+3.0_pr*c3+c4)*u8+6.0_pr*u3*(7350.0_pr*(6.0_pr*c1 &
               +3.0_pr*c3-2.0_pr*c4)+81.0_pr*(-2.0_pr*c1+c3)*u4-4.0_pr*(-3.0_pr*c1+3.0_pr*c3+c4)*u6) &
               *Atan(u)+3.0_pr*(-50.0_pr*(330.0_pr*c1+129.0_pr*c3-56.0_pr*c4)-324.0_pr*(162.0_pr*c1+69.0_pr*c3 &
               -40.0_pr*c4)*u2+567.0_pr*(14.0_pr*c1+11.0_pr*c3-8.0_pr*c4)*u4)*Log(1.0_pr+u2))) &
               /(432.0_pr*fpi4*Pi*u12)

          brhotau=brhotau+(c4*gA2*mpi*(u2*(-1680.0_pr+23610.0_pr*u2+958.0_pr*u4-174.0_pr*u6 &
               +27.0_pr*u8)-6.0_pr*u3*(5775.0_pr+44.0_pr*u6+45.0_pr*u8)*Atan(u)+24.0_pr*(70.0_pr &
               +99.0_pr*u2*(5.0_pr-3.0_pr*u2))*Log(1.0_pr+u2)))/(4752.0_pr*fpi4*Pi*u10)

          dbrhotau=dbrhotau+(c4*gA2*mpi*(u2*(8400.0_pr-77955.0_pr*u2-1919.0_pr*u4+177.0_pr*u6 &
               -135.0_pr*u8)+3.0_pr*u3*(40425.0_pr+44.0_pr*u6-45.0_pr*u8)*Atan(u)+24.0_pr*(-350.0_pr &
               +99.0_pr*u2*(-20.0_pr+9.0_pr*u2))*Log(1.0_pr+u2)))/(2376.0_pr*fpi4*Pi*u11)

          ddbrhotau=ddbrhotau+(c4*gA2*mpi*(-1050.0_pr*u2+6690.0_pr*u4+106.0_pr*u6-3.0_pr*u8 &
               -3.0_pr*u3*(3675.0_pr+u6)*Atan(u)+3.0_pr*(350.0_pr+81.0_pr*u2*(20.0_pr-7.0_pr*u2)) &
               *Log(1.0_pr+u2)))/(27.0_pr*fpi4*Pi*u12)

          ajj=ajj+(gA2*mpi*(u2*(-84.0_pr*(c1+2.0_pr*c1*u2)+6.0_pr*c3*(-11.0_pr+16.0_pr*u2+u4) &
               -c4*(12.0_pr+11.0_pr*u2*(2.0_pr+u2)))+2.0_pr*u3*(210.0_pr*c1-105.0_pr*c3 &
               +28.0_pr*(-3.0_pr*c1+3.0_pr*c3+c4)*u2+12.0_pr*(9.0_pr*c3+c4)*u4)*Atan(u)+(84.0_pr*c1 &
               +66.0_pr*c3+12.0_pr*c4+7.0_pr*(-30.0_pr*c1+21.0_pr*c3+4.0_pr*c4)*u2)*Log(1.0_pr+u2))) &
               /(4480.0_pr*fpi4*Pi*u6)

          dajj=dajj+(gA2*mpi*(u3*(315.0_pr*(-2.0_pr*c1+c3)+28.0_pr*(3.0_pr*c1-3.0_pr*c3-c4)*u2 &
               +12.0_pr*(9.0_pr*c3+c4)*u4)*Atan(u)+2.0_pr*(9.0_pr*(14.0_pr*c1+11.0_pr*c3+2.0_pr*c4)*u2 &
               +(42.0_pr*c1-60.0_pr*c3+19.0_pr*c4)*u4+6.0_pr*(9.0_pr*c3+c4)*u6+(-9.0_pr*(14.0_pr*c1 &
               +11.0_pr*c3+2.0_pr*c4)+7.0_pr*(30.0_pr*c1-21.0_pr*c3-4.0_pr*c4)*u2)*Log(1.0_pr+u2)))) &
               /(2240.0_pr*fpi4*Pi*u7)

          bjj=bjj+(c4*gA2*mpi*(-(u2*(12.0_pr+11.0_pr*u2*(2.0_pr+u2)))+8.0_pr*u5*(7.0_pr &
               +3.0_pr*u2)*Atan(u)+4.0_pr*(3.0_pr+7.0_pr*u2)*Log(1.0_pr+u2)))/(2240.0_pr*fpi4*Pi*u6)

          dbjj=dbjj+(c4*gA2*mpi*(u2*(18.0_pr+19.0_pr*u2+6.0_pr*u4)+2.0_pr*u5*(-7.0_pr &
               +3.0_pr*u2)*Atan(u)-2.0_pr*(9.0_pr+14.0_pr*u2)*Log(1.0_pr+u2)))/(560.0_pr*fpi4*Pi*u7)

       Else  !! if (u.gt.ucut...
          arhorho=arhorho +(3.0_pr*(2.0_pr*c1 - c3)*gA2*mpi**3)/(64.0_pr*fpi4*Pi) + (11.0_pr*(42.0_pr*c1 &
               + 129.0_pr*c3 + 40.0_pr*c4)*gA2*mpi**3*u4)/(100800.0_pr*fpi4*Pi) - ((162.0_pr*c1 &
               + 213.0_pr*c3 + 56.0_pr*c4)*gA2*mpi**3*u6)/(69300.0_pr*fpi4*Pi)
          darhorho=darhorho+(gA2*mpi**3*u3*(121.0_pr*(42.0_pr*c1+129.0_pr*c3+40.0_pr*c4) &
               -24.0_pr*(162.0_pr*c1+213.0_pr*c3+56.0_pr*c4)*u2))/(277200.0_pr*fpi4*Pi)
          ddarhorho=ddarhorho+(gA2*mpi**3*u2*(1573.0_pr*(42.0_pr*c1+129.0_pr*c3+40.0_pr*c4) &
               -520.0_pr*(162.0_pr*c1+213.0_pr*c3+56.0_pr*c4)*u2+765.0_pr*(110.0_pr*c1+107.0_pr*c3 &
               +24.0_pr*c4)*u4))/(1.2012e6_pr*fpi4*Pi)
 
          brhorho=brhorho +(11.0_pr*c4*gA2*mpi**3*u4)/(1260.0_pr*fpi4*Pi) &
               - (4.0_pr*c4*gA2*mpi**3*u6)/(2475.0_pr*fpi4*Pi)
          dbrhorho=dbrhorho+(c4*gA2*mpi**3*u3*(605.0_pr-168.0_pr*u2))/(17325.0_pr*fpi4*Pi)
          ddbrhorho=ddbrhorho+(c4*gA2*mpi**3*u2*(1573.0_pr-728.0_pr*u2+459.0_pr*u4)) &
               /(15015.0_pr*fpi4*Pi)

          arhodrho=arhodrho+(gA2*mpi*(1081080.0_pr*(10.0_pr*c1-11.0_pr*c3+4.0_pr*c4)+16016.0_pr &
               *(42.0_pr*c1+129.0_pr*c3+140.0_pr*c4)*u2-117.0_pr*(5886.0_pr*c1+7739.0_pr*c3+2688.0_pr*c4)*u4 &
               +135.0_pr*(2970.0_pr*c1+2889.0_pr*c3+704.0_pr*c4)*u6))/(5.5351296e8_pr*fpi4*Pi)
          darhodrho=darhodrho+(gA2*mpi*u*(16016.0_pr*(42.0_pr*c1+129.0_pr*c3+140.0_pr*c4)-234.0_pr &
               *(5886.0_pr*c1+7739.0_pr*c3+2688.0_pr*c4)*u2+405.0_pr*(2970.0_pr*c1+2889.0_pr*c3 &
               +704.0_pr*c4)*u4))/(2.7675648e8_pr*fpi4*Pi)
          ddarhodrho=ddarhodrho+(gA2*mpi*(192192.0_pr*(42.0_pr*c1+129.0_pr*c3+140.0_pr*c4)-8424.0_pr &
               *(5886.0_pr*c1+7739.0_pr*c3+2688.0_pr*c4)*u2+24300.0_pr*(2970.0_pr*c1+2889.0_pr*c3 &
               +704.0_pr*c4)*u4-175.0_pr*(442806.0_pr*c1+367383.0_pr*c3+73216.0_pr*c4)*u6)) &
               /(3.32107776e9_pr*fpi4*Pi)

          brhodrho=brhodrho+(gA2*mpi*(2162160.0_pr*(10.0_pr*c1-11.0_pr*c3+4*c4)-40040.0_pr*(42.0_pr*c1 &
               +129.0_pr*c3-112.0_pr*c4)*u2+819.0_pr*(270.0_pr*c1+355.0_pr*c3-768.0_pr*c4)*u4 &
               -45.0_pr*(770.0_pr*c1+749.0_pr*c3-4224.0_pr*c4)*u6))/(5.5351296e8_pr*fpi4*Pi)
          dbrhodrho=dbrhodrho+(gA2*mpi*u*(-40040.0_pr*(42.0_pr*c1+129.0_pr*c3-112.0_pr*c4)+1638.0_pr &
               *(270.0_pr*c1+355.0_pr*c3-768.0_pr*c4)*u2-135.0_pr*(770.0_pr*c1+749.0_pr*c3 &
               -4224.0_pr*c4)*u4))/(2.7675648e8_pr*fpi4*Pi)
          ddbrhodrho=ddbrhodrho+(gA2*mpi*(-480480.0_pr*(42.0_pr*c1+129.0_pr*c3-112.0_pr*c4)+58968.0_pr &
               *(270.0_pr*c1+355.0_pr*c3-768.0_pr*c4)*u2-8100.0_pr*(770.0_pr*c1+749.0_pr*c3 &
               -4224.0_pr*c4)*u4+175.0_pr*(11466.0_pr*c1+9513.0_pr*c3-146432.0_pr*c4)*u6)) &
               /(3.32107776e9_pr*fpi4*Pi)

          adrdr=adrdr+0.0_pr
          dadrdr=dadrdr+0.0_pr
          bdrdr=bdrdr+0.0_pr
          dbdrdr=dbdrdr+0.0_pr

          arhotau=arhotau+(gA2*mpi*(135135.0_pr*(10.0_pr*c1-11.0_pr*c3-4.0_pr*c4)-7007.0_pr*(42.0_pr*c1 &
               +129.0_pr*c3+40.0_pr*c4)*u2+702.0_pr*(162.0_pr*c1+213.0_pr*c3+56.0_pr*c4)*u4-495.0_pr &
               *(110.0_pr*c1+107.0_pr*c3+24.0_pr*c4)*u6))/(1.729728e7_pr*fpi4*Pi)
          darhotau=darhotau+(gA2*mpi*u*(-7007.0_pr*(42.0_pr*c1+129.0_pr*c3+40.0_pr*c4)+1404.0_pr &
               *(162.0_pr*c1+213.0_pr*c3+56.0_pr*c4)*u2-1485.0_pr*(110.0_pr*c1+107.0_pr*c3+24.0_pr*c4)*u4)) &
               /(8.64864e6_pr*fpi4*Pi)
          ddarhotau=ddarhotau+(gA2*mpi*(-21021.0_pr*(42.0_pr*c1+129.0_pr*c3+40.0_pr*c4)+12636.0_pr &
               *(162.0_pr*c1+213.0_pr*c3+56.0_pr*c4)*u2-22275.0_pr*(110.0_pr*c1+107.0_pr*c3+24.0_pr*c4)*u4 &
               +4550.0_pr*(546.0_pr*c1+453.0_pr*c3+88.0_pr*c4)*u6))/(2.594592e7_pr*fpi4*Pi)

          brhotau=brhotau -(c4*gA2*mpi*(135135.0_pr+70070.0_pr*u2-9828.0_pr*u4+2970.0_pr*u6)) &
               /(2.16216e6_pr*fpi4*Pi)
          dbrhotau=dbrhotau -(c4*gA2*mpi*u*(35035.0_pr-9828.0_pr*u2+4455.0_pr*u4))/(540540.0_pr*fpi4*Pi)
          ddbrhotau=ddbrhotau+(c4*gA2*mpi*(-105105.0_pr+88452.0_pr*u2-66825.0_pr*u4+50050.0_pr*u6)) &
               /(1.62162e6_pr*fpi4*Pi)

          ajj=ajj+(gA2*mpi*(-1050.0_pr*(10.0_pr*c1-11.0_pr*c3-2.0_pr*c4)+70.0_pr*(42.0_pr*c1 &
               +129.0_pr*c3+10.0_pr*c4)*u2-3.0_pr*(486.0_pr*c1+639.0_pr*c3+28.0_pr*c4)*u4+8.0_pr &
               *(110.0_pr*c1+107.0_pr*c3+3.0_pr*c4)*u6))/(268800.0_pr*fpi4*Pi)
          dajj=dajj+(gA2*mpi*u*(35.0_pr*(42.0_pr*c1+129.0_pr*c3+10.0_pr*c4)-3.0_pr*(486.0_pr*c1 &
               +639.0_pr*c3+28.0_pr*c4)*u2+12.0_pr*(110.0_pr*c1+107.0_pr*c3+3.0_pr*c4)*u4)) &
               /(67200.0_pr*fpi4*Pi)

          bjj=bjj+(c4*gA2*mpi*(525.0_pr+175.0_pr*u2-21.0_pr*u4+6.0_pr*u6))/(33600.0_pr*fpi4*Pi)
          dbjj=dbjj+(c4*gA2*mpi*u*(175.0_pr-42.0_pr*u2+18.0_pr*u4))/(16800.0_pr*fpi4*Pi)
       End If  !! if (u.gt.ucut...
       !
       ! N2LO, 3N terms
       If (use_DME3N_terms) Then
          If (u.Gt.ucut3n) Then
             y=1.0_pr/u
             dy=-y*y
             ddy=2.0_pr*y*y*y
             marc=atu
             dmarc=2.0_pr/(1.0_pr+ 4.0_pr*u2)
             ddmarc=-16.0_pr*u/((1.0_pr+ 4.0_pr*u2)**2)
             mlog=lual
             dmlog=8.0_pr*u/(1.0_pr+ 4.0_pr*u2)
             ddmlog=(8.0_pr-32.0_pr*u2)/((1.0_pr+ 4.0_pr*u2)**2)
             Do l=1,33
                Do j=1,3
                   Do k=1,3
                      aux=((y**(l-1))*(atu**(j-1))*(lual**(k-1)))*mevfm
                      daux=(Real(-1+j,pr)*marc**(-2+j)*mlog**(-1+k)*y**(-1+l)*dmarc &     
                           +Real(-1+k,pr)*marc**(-1+j)*mlog**(-2+k)*y**(-1+l)*dmlog &
                           +Real(-1+l,pr)*marc**(-1+j)*mlog**(-1+k)*y**(-2+l)*dy)*mevfm
                      ddaux=((2.0_pr*Real(-1+l,pr)*y**(-2+l)*(Real(-1+j,pr) &
                           *marc**(-2+j)*mlog**(-1+k)*dmarc+Real(-1+k,pr)*marc**(-1+j)*mlog**(-2+k) &
                           *dmlog)*dy+y**(-1+l)*(2.0_pr*Real((-1+j)*(-1+k),pr)*marc**(-2+j)*mlog**(-2+k) &
                           *dmarc*dmlog+mlog**(-1+k)*(Real((-2+j)*(-1+j),pr)*marc**(-3+j)*dmarc**2 &
                           +Real(-1+j,pr)*marc**(-2+j)*ddmarc)+marc**(-1+j)*(Real((-2+k)*(-1+k),pr) &
                           *mlog**(-3+k)*dmlog**2+Real(-1+k,pr)*mlog**(-2+k)*ddmlog))+marc**(-1+j) &
                           *mlog**(-1+k)*(Real((-2+l)*(-1+l),pr)*y**(-3+l)*dy**2+Real(-1+l,pr) &
                           *y**(-2+l)*ddy)))*mevfm
                      !
                      hrho0rho0 =hrho0rho0 +ctr0r0(k,j,l)*aux
                      hrho1rho1 =hrho1rho1 +ctr1r1(k,j,l)*aux
                      hdr0dr0   =hdr0dr0+ctdr0dr0(k,j,l)*aux
                      hdr1dr1   =hdr1dr1+ctdr1dr1(k,j,l)*aux
                      hrho0Drho0=hrho0Drho0+ctr0Dr0(k,j,l)*aux
                      hrho1Drho0=hrho1Drho0+ctr1Dr0(k,j,l)*aux
                      hrho1Drho1=hrho1Drho1+ctr1Dr1(k,j,l)*aux
                      hrho0tau0 =hrho0tau0+ctr0t0(k,j,l)*aux
                      hrho1tau0 =hrho1tau0+ctr1t0(k,j,l)*aux
                      hrho1tau1 =hrho1tau1+ctr1t1(k,j,l)*aux
                      hJ0dr0    =hJ0dr0+ctJ0dr0(k,j,l)*aux
                      hrho0DJ0  =hrho0DJ0+ctr0dJ0(k,j,l)*aux
                      hJ1dr1    =hJ1dr1+ctJ1dr1(k,j,l)*aux
                      hrho1DJ1  =hrho1DJ1+ctr1dJ1(k,j,l)*aux
                      hJ0dr1    =hJ0dr1+ctJ0dr1(k,j,l)*aux
                      hrho1DJ0  =hrho1DJ0+ctr1dJ0(k,j,l)*aux
                      hJ1dr0    =hJ1dr0+ctJ1dr0(k,j,l)*aux
                      hJ0J0     =hJ0J0+ctJ0J0(k,j,l)*aux
                      hJ0J1     =hJ0J1+ctJ0J1(k,j,l)*aux        
                      hJ1J1     =hJ1J1+ctJ1J1(k,j,l)*aux
                      !
                      dhrho0rho0 =dhrho0rho0 +ctr0r0(k,j,l)*daux
                      dhrho1rho1 =dhrho1rho1 +ctr1r1(k,j,l)*daux
                      dhdr0dr0   =dhdr0dr0+ctdr0dr0(k,j,l)*daux
                      dhdr1dr1   =dhdr1dr1+ctdr1dr1(k,j,l)*daux
                      dhrho0Drho0=dhrho0Drho0+ctr0Dr0(k,j,l)*daux
                      dhrho1Drho0=dhrho1Drho0+ctr1Dr0(k,j,l)*daux
                      dhrho1Drho1=dhrho1Drho1+ctr1Dr1(k,j,l)*daux
                      dhrho0tau0 =dhrho0tau0+ctr0t0(k,j,l)*daux
                      dhrho1tau0 =dhrho1tau0+ctr1t0(k,j,l)*daux
                      dhrho1tau1 =dhrho1tau1+ctr1t1(k,j,l)*daux
                      dhJ0dr0    =dhJ0dr0+ctJ0dr0(k,j,l)*daux
                      dhrho0DJ0  =dhrho0DJ0+ctr0dJ0(k,j,l)*daux
                      dhJ1dr1    =dhJ1dr1+ctJ1dr1(k,j,l)*daux
                      dhrho1DJ1  =dhrho1DJ1+ctr1dJ1(k,j,l)*daux
                      dhJ0dr1    =dhJ0dr1+ctJ0dr1(k,j,l)*daux
                      dhrho1DJ0  =dhrho1DJ0+ctr1dJ0(k,j,l)*daux
                      dhJ1dr0    =dhJ1dr0+ctJ1dr0(k,j,l)*daux
                      dhJ0J0     =dhJ0J0+ctJ0J0(k,j,l)*daux
                      dhJ0J1     =dhJ0J1+ctJ0J1(k,j,l)*daux        
                      dhJ1J1     =dhJ1J1+ctJ1J1(k,j,l)*daux
                      !
                      ddhrho0rho0 =ddhrho0rho0 +ctr0r0(k,j,l)*ddaux
                      ddhrho1rho1 =ddhrho1rho1 +ctr1r1(k,j,l)*ddaux
                      ddhrho0Drho0=ddhrho0Drho0+ctr0Dr0(k,j,l)*ddaux
                      ddhrho1Drho0=ddhrho1Drho0+ctr1Dr0(k,j,l)*ddaux
                      ddhrho1Drho1=ddhrho1Drho1+ctr1Dr1(k,j,l)*ddaux
                      ddhrho0tau0 =ddhrho0tau0+ctr0t0(k,j,l)*ddaux
                      ddhrho1tau0 =ddhrho1tau0+ctr1t0(k,j,l)*ddaux
                      ddhrho1tau1 =ddhrho1tau1+ctr1t1(k,j,l)*ddaux
                   End Do
                End Do
             End Do  !! end of l,j,k loops
          Else  !! if (u.gt.ucut3n..
             hrho0rho0=mevfm*(2.0555896e-8_pr*ce*(-15.058202_pr + u)*(13.851257_pr + u)*(218.02762_pr &
                  - 15.661674_pr*u + u2)*(200.58157_pr + 13.247785_pr*u + u2) + gA*(-0.042893802_pr*cd*(-1.5948724_pr &
                  + u)*(-0.01657426_pr + u)*(1.8884833_pr - 2.1431293_pr*u + u2)*(0.029641853_pr - 0.28437579_pr*u &
                  + u2) + gA*LambdaX*(6.0619551_pr*c3*(-1.1935357_pr + u)*(-0.30214838_pr + u)*(0.9281019_pr &
                  - 1.5964577_pr*u + u2)*(0.15916821_pr - 0.63445995_pr*u + u2) + 3.9928539_pr*c1*(-1.2431741_pr &
                  + u)*(-0.19155888_pr + u)*(1.1456958_pr - 1.8138841_pr*u + u2)*(0.19109424_pr - 0.36771486_pr*u &
                  + u2) - 0.06402411_pr*c4*(-1.3982905_pr + u)*(0.1480126_pr + u)*(1.6779335_pr - 2.2114154_pr*u &
                  + u2)*(0.041603529_pr - 0.35726143_pr*u + u2))))/(fpi4*LambdaX)

             hrho1rho1=mevfm*(2.0555896e-8_pr*ce*(-15.058202_pr + u)*(13.851257_pr + u)*(218.02762_pr &
                  - 15.661674_pr*u + u2)*(200.58157_pr + 13.247785_pr*u + u2) + gA*(-0.042893802_pr*cd*(-1.5948724_pr &
                  + u)*(-0.01657426_pr + u)*(1.8884833_pr - 2.1431293_pr*u + u2)*(0.029641853_pr - 0.28437579_pr*u &
                  + u2) + gA*LambdaX*(6.0619551_pr*c3*(-1.1935357_pr + u)*(-0.30214838_pr + u)*(0.9281019_pr &
                  - 1.5964577_pr*u + u2)*(0.15916821_pr - 0.63445995_pr*u + u2) + 3.9928539_pr*c1*(-1.2431741_pr &
                  + u)*(-0.19155888_pr + u)*(1.1456958_pr - 1.8138841_pr*u + u2)*(0.19109424_pr - 0.36771486_pr*u &
                  + u2) - 0.06402411_pr*c4*(-1.3982905_pr + u)*(0.1480126_pr + u)*(1.6779335_pr - 2.2114154_pr*u &
                  + u2)*(0.041603529_pr - 0.35726143_pr*u + u2))))/(fpi4*LambdaX)

             hdr0dr0=0.0_pr
             hdr1dr1=0.0_pr

             hrho0Drho0=mevfm*(gA*(0.12666864_pr*cd*(-1.2705742_pr + u)*(0.21652154_pr + u)*(1.4119605_pr &
                  - 2.1693922_pr*u + u2)*(0.89941341_pr - 1.1919922_pr*u + u2) + gA*LambdaX*(29.501949_pr*c1*( &
                  -1.0215543_pr + u)*(-0.15813736_pr + u)*(0.84479502_pr - 1.6998479_pr*u + u2)*(0.34169853_pr &
                  - 0.81578924_pr*u + u2) - 7.1108952_pr*c3*(1.1461026_pr - 2.0823268_pr*u + u2)*(0.62212787_pr &
                  - 1.1642433_pr*u + u2)*(0.074190685_pr - 0.4633705_pr*u + u2) + 0.18892679_pr*c4*(1.7714304_pr &
                  - 2.5914415_pr*u + u2)*(1.2438813_pr - 1.6683493_pr*u + u2)*(0.004127797_pr - 0.089415137_pr*u &
                  + u2))))/(fpi4*LambdaX*mpi2)

             hrho1Drho0=mevfm*(gA*(-0.042222876_pr*cd*(-1.2705742_pr + u)*(0.21652155_pr + u)*(1.4119605_pr &
                  - 2.1693922_pr*u + u2)*(0.89941343_pr - 1.1919922_pr*u + u2) + gA*LambdaX*(-0.064338673_pr*c1*( &
                  -1.9302829_pr + u)*(0.24441857_pr + u)*(2.1104361_pr - 2.7720023_pr*u + u2)*(1.3417224_pr &
                  - 1.5814849_pr*u + u2) + 0.049739131_pr*c3*(1.8967607_pr - 2.6742154_pr*u + u2)*(1.316844_pr &
                  - 1.6740809_pr*u + u2)*(0.011061538_pr - 0.13317506_pr*u + u2) - 0.073720916_pr*c4*(1.6783675_pr &
                  - 2.5203342_pr*u + u2)*(1.1903356_pr - 1.6163511_pr*u + u2)*(0.0074741816_pr - 0.10943007_pr*u &
                  + u2))))/(fpi4*LambdaX*mpi2)

             hrho1Drho1=mevfm*(gA*(-0.084445761_pr*cd*(-1.2705742_pr + u)*(0.21652154_pr + u)*(1.4119605_pr &
                  - 2.1693922_pr*u + u2)*(0.89941341_pr - 1.1919922_pr*u + u2) + gA*LambdaX*(-7.0472043_pr*c1*( &
                  -1.0402373_pr + u)*(-0.15610243_pr + u)*(0.87447681_pr - 1.7182557_pr*u + u2)*(0.33211898_pr &
                  - 0.74186157_pr*u + u2) + 8.0775475_pr*c3*(0.95424896_pr - 1.9113384_pr*u + u2)*(0.50394896_pr &
                  - 1.1611245_pr*u + u2)*(0.11279874_pr - 0.61804716_pr*u + u2) - 0.1259512_pr*c4*(1.7714304_pr &
                  - 2.5914415_pr*u + u2)*(1.2438813_pr - 1.6683493_pr*u + u2)*(0.004127797_pr - 0.089415137_pr*u &
                  + u2))))/(fpi4*LambdaX*mpi2)

             hrho0tau0=mevfm*(ga*(-0.25333726_pr*cd*(-1.2705742_pr+u)*(0.21652155_pr+u)*(1.4119605_pr &
                  +(-2.1693922_pr+u)*u)*(0.89941343_pr+(-1.1919922_pr+u)*u)+ga*LambdaX*(-4.0039062_pr*c1 &
                  *(-1.2352256_pr+u)*(0.064279963_pr+u)*(1.2516998_pr+(-1.9866561_pr+u)*u)*(0.62481483_pr &
                  +(-0.6277641_pr+u)*u)-0.43884277_pr*c4*(1.682325_pr+(-2.523347_pr+u)*u)*(1.1930406_pr &
                  +(-1.6187124_pr+u)*u)*(0.0072756559_pr+(-0.10828832_pr+u)*u)-1.3046875_pr*c3*(-1.3097655_pr &
                  +u)*(-0.12575226_pr+u)*(1.337577_pr+(-1.9544714_pr+u)*u)*(0.15931999_pr+u*(0.30346213_pr+u))))) &
                  /(fpi4*LambdaX*mpi2)

             hrho1tau0=mevfm*(ga*(0.084445755_pr*cd*(-1.2705742_pr+u)*(0.21652155_pr+u)*(1.4119605_pr &
                  +(-2.1693922_pr+u)*u)*(0.89941343_pr+(-1.1919922_pr+u)*u)+ga*LambdaX*(0.12695312_pr*c1 &
                  *(-1.9629389_pr+u)*(0.24499103_pr+u)*(2.1016515_pr+(-2.7692262_pr+u)*u)*(1.3407016_pr &
                  +(-1.5830183_pr+u)*u)-0.10644531_pr*c3*(1.8516394_pr+(-2.6412277_pr+u)*u)*(1.2914728_pr &
                  +(-1.6504171_pr+u)*u)*(0.012431285_pr+(-0.14092406_pr+u)*u)+0.14648438_pr*c4*(1.6816422_pr &
                  +(-2.5228331_pr+u)*u)*(1.1925378_pr+(-1.6182745_pr+u)*u)*(0.007307093_pr+(-0.10847576_pr &
                  +u)*u))))/(fpi4*LambdaX*mpi2)

             hrho1tau1=mevfm*(ga*(0.16889151_pr*cd*(-1.2705742_pr+u)*(0.21652155_pr+u)*(1.4119605_pr &
                  +(-2.1693922_pr+u)*u)*(0.89941343_pr+(-1.1919922_pr+u)*u)+ga*LambdaX*(1.0390625_pr*c1 &
                  *(-1.2278564_pr+u)*(0.017559313_pr+u)*(1.2287066_pr+(-1.9487414_pr+u)*u)*(0.66412923_pr &
                  +(-0.34133743_pr+u)*u)-0.19921875_pr*c3*(1.86082_pr+(-2.5829231_pr+u)*u)*(1.9047944_pr &
                  +(-1.441557_pr+u)*u)*(0.025980569_pr+(-0.2323826_pr+u)*u)+0.29296875_pr*c4*(1.6816422_pr &
                  +(-2.5228331_pr+u)*u)*(1.1925378_pr+(-1.6182745_pr+u)*u)*(0.007307093_pr+(-0.10847576_pr &
                  +u)*u))))/(fpi4*LambdaX*mpi2)

             hJ0dr0=0.0_pr

             hrho0DJ0=mevfm*(gA2*(0.87488139_pr*c1*(-1.5075509_pr+u)*(0.26375366_pr+u)*(1.6807042_pr &
                  +(-2.4330383_pr+u)*u)*(0.96407512_pr+(-1.3041604_pr+u)*u)+0.10945568_pr*c4*(1.6868327_pr &
                  +(-2.5235789_pr+u)*u)*(1.16087_pr+(-1.5798009_pr+u)*u)*(0.0058674843_pr+(-0.099090543_pr+u)*u) &
                  -0.65769729_pr*c3*(1.7722509_pr+(-2.5823827_pr+u)*u)*(1.1921659_pr+(-1.56672_pr+u)*u) &
                  *(0.0031379608_pr+(-0.079284979_pr+u)*u)))/(fpi4*mpi2)

             hJ1dr1=0.0_pr

             hrho1DJ1=mevfm*(gA2*(-0.43565926_pr*c1*(-1.2316322_pr+u)*(0.20486088_pr+u)*(1.3126963_pr &
                  +(-2.0776323_pr+u)*u)*(0.80436474_pr+(-1.0724984_pr+u)*u)-0.07297045_pr*c4*(1.6868327_pr &
                  +(-2.5235789_pr+u)*u)*(1.1608701_pr+(-1.5798009_pr+u)*u)*(0.0058674831_pr+(-0.099090535_pr &
                  +u)*u)+0.1942317_pr*c3*(1.7488022_pr+(-2.5635214_pr+u)*u)*(1.1781067_pr+(-1.5454099_pr+u)*u) &
                  *(0.0037519521_pr+(-0.082717466_pr+u)*u)))/(fpi4*mpi2)

             hJ0dr1=0.0_pr

             hrho1DJ0=mevfm*(gA2*(-0.49880616_pr*c1*(-1.2658085_pr+u)*(0.20574562_pr+u)*(1.4174942_pr &
                  +(-2.1861549_pr+u)*u)*(0.9423041_pr+(-1.257487_pr+u)*u)-0.036485225_pr*c4*(1.6868327_pr &
                  +(-2.5235789_pr+u)*u)*(1.1608701_pr+(-1.5798009_pr+u)*u)*(0.0058674831_pr+(-0.099090536_pr &
                  +u)*u)+0.10945568_pr*c3*(1.6868327_pr+(-2.5235789_pr+u)*u)*(1.1608701_pr+(-1.5798009_pr+u)*u) &
                  *(0.0058674829_pr+(-0.099090534_pr+u)*u)))/(fpi4*mpi2)

             hJ1dr0=0.0_pr

             hJ0J0=mevfm*(ga*(-0.1536163_pr*cd*(-1.3967122_pr+u)*(0.25293929_pr+u)*(1.6675202_pr+(-2.3021441_pr &
                  +u)*u)*(0.98775885_pr+(-1.1088032_pr+u)*u)+ga*LambdaX*(0.37890625_pr*c1*(-1.9915809_pr+u) &
                  *(-1.0930869_pr+u)*(-0.66138682_pr+u)*(0.62037829_pr+u)*(0.88993989_pr+(-1.6302515_pr+u)*u) &
                  -0.82470703_pr*c3*(-0.1151617_pr+u)*(0.19519195_pr+u)*(1.3633551_pr+(-2.2799728_pr+u)*u) &
                  *(0.92255094_pr+(-1.4901995_pr+u)*u)-0.31591797_pr*c4*(1.6836216_pr+(-2.5209696_pr+u)*u) &
                  *(1.1565142_pr+(-1.5751323_pr+u)*u)*(0.0053910501_pr+(-0.095764354_pr+u)*u)))) &
                  /(fpi4*LambdaX*mpi2)

             hJ0J1=mevfm*(ga*(0.10241087_pr*cd*(-1.3967122_pr+u)*(0.25293929_pr+u)*(1.6675202_pr+(-2.3021441_pr &
                  +u)*u)*(0.98775885_pr+(-1.1088032_pr+u)*u)+ga*LambdaX*(0.19000244_pr*c3*(-0.078125417_pr+u) &
                  *(0.032069683_pr+u)*(1.5685634_pr+(-2.4365485_pr+u)*u)*(1.0625904_pr+(-1.537248_pr+u)*u) &
                  -0.69067383_pr*c1*(-1.1098034_pr+u)*(0.18815441_pr+u)*(1.1047942_pr+(-1.9744345_pr+u)*u) &
                  *(0.7614037_pr+(-1.2677199_pr+u)*u)+0.21069336_pr*c4*(1.6833299_pr+(-2.5207351_pr+u)*u) &
                  *(1.1564102_pr+(-1.5750045_pr+u)*u)*(0.0053966658_pr+(-0.095801508_pr+u)*u)))) &
                  /(fpi4*LambdaX*mpi2)

             hJ1J1=mevfm*(ga*(0.051205435_pr*cd*(-1.3967122_pr+u)*(0.25293929_pr+u)*(1.6675202_pr+(-2.3021441_pr &
                  +u)*u)*(0.98775885_pr+(-1.1088032_pr+u)*u)+ga*LambdaX*(0.19219971_pr*c3*(-0.12213139_pr+u) &
                  *(0.2951145_pr+u)*(2.0521898_pr+(-2.8194623_pr+u)*u)*(1.2084447_pr+(-1.7226538_pr+u)*u) &
                  -0.54418945_pr*c1*(-1.7111589_pr+u)*(0.30206023_pr+u)*(1.421294_pr+(-2.2931824_pr+u)*u) &
                  *(0.85528206_pr+(-1.3180868_pr+u)*u)+0.10534668_pr*c4*(1.6833299_pr+(-2.5207351_pr+u)*u) &
                  *(1.1564102_pr+(-1.5750045_pr+u)*u)*(0.0053966658_pr+(-0.095801508_pr+u)*u)))) &
                  /(fpi4*LambdaX*mpi2)

             dhrho0rho0=mevfm*(-3.0696805e-6_pr*ce*(-0.63337387_pr + u)*(-0.6_pr + u)*(0.37421487_pr &
                  - 1.2218226_pr*u + u2)*(0.33405954_pr - 1.1537321_pr*u + u2) + gA*(0.27912917_pr*cd*(&
                  1.7611632_pr - 2.5821217_pr*u + u2)*(1.2266141_pr - 1.6507188_pr*u + u2)*(0.029143369_pr &
                  - 0.28917996_pr*u + u2) + gA*LambdaX*(-1491.7558_pr*c1*(0.67170782_pr - 1.62489_pr*u &
                  + u2)*(0.4525586_pr - 1.2543926_pr*u + u2)*(0.17617549_pr - 0.80139711_pr*u + u2) &
                  - 536.43232_pr*c3*(0.76316673_pr - 1.7218477_pr*u + u2)*(0.43361641_pr - 1.1835313_pr*u &
                  + u2)*(0.16367811_pr - 0.78054496_pr*u + u2) + 0.30876998_pr*c4*(-1.5784873_pr + u)*( &
                  -1.0937068_pr + u)*(1.340452_pr - 2.04474_pr*u + u2)*(0.019873806_pr - 0.25332432_pr*u &
                  + u2))))/(fpi4*LambdaX)

             dhrho1rho1=mevfm*(-3.0696805e-6_pr*ce*(-0.63337387_pr + u)*(-0.6_pr + u)*(0.37421487_pr &
                  - 1.2218226_pr*u + u2)*(0.33405954_pr - 1.1537321_pr*u + u2) + gA*(0.27912917_pr*cd*(&
                  1.7611632_pr - 2.5821217_pr*u + u2)*(1.2266141_pr - 1.6507188_pr*u + u2)*(0.029143369_pr &
                  - 0.28917996_pr*u + u2) + gA*LambdaX*(-1491.7558_pr*c1*(0.67170782_pr - 1.62489_pr*u &
                  + u2)*(0.4525586_pr - 1.2543926_pr*u + u2)*(0.17617549_pr - 0.80139711_pr*u + u2) &
                  - 536.43232_pr*c3*(0.76316673_pr - 1.7218477_pr*u + u2)*(0.43361641_pr - 1.1835313_pr*u &
                  + u2)*(0.16367811_pr - 0.78054496_pr*u + u2) + 0.30876998_pr*c4*(-1.5784873_pr + u)*( &
                  -1.0937068_pr + u)*(1.340452_pr - 2.04474_pr*u + u2)*(0.019873806_pr - 0.25332432_pr*u &
                  + u2))))/(fpi4*LambdaX)

             dhdr0dr0=0.0_pr
             dhdr1dr1=0.0_pr

             dhrho0Drho0=mevfm*(gA*(-0.52109887_pr*cd*(-1.3082043_pr + u)*(-0.071686644_pr + u)*(1.4677685_pr &
                  - 2.2766738_pr*u + u2)*(0.93721725_pr - 1.4019146_pr*u + u2) + gA*LambdaX*(-1.0505013_pr*c4*( &
                  -0.6756734_pr + u)*(-0.093758568_pr + u)*(1.59727_pr - 2.4899591_pr*u + u2)*(1.0589336_pr &
                  - 1.6598738_pr*u + u2) + 410.5668_pr*c3*(-0.82531999_pr + u)*(-0.33506221_pr + u)*(0.60822284_pr &
                  - 1.5136238_pr*u + u2)*(0.31121003_pr - 0.98997717_pr*u + u2) - 1232.118_pr*c1*(-0.8439295_pr &
                  + u)*(-0.39116927_pr + u)*(0.58509589_pr - 1.4743171_pr*u + u2)*(0.28266076_pr - 0.97625946_pr*u &
                  + u2))))/(fpi4*LambdaX*mpi2)

             dhrho1Drho0=mevfm*(gA*(0.17369909_pr*cd*(-1.308206_pr + u)*(-0.071686588_pr + u)*(1.4677702_pr &
                  - 2.2766756_pr*u + u2)*(0.9372174_pr - 1.4019153_pr*u + u2) + gA*LambdaX*(0.0083633968_pr*c3*( &
                  -1.1273967_pr + u)*(-0.75552081_pr + u)*(-0.07564609_pr + u)*(36.068809_pr + u)*(1.033597_pr &
                  - 1.7618699_pr*u + u2) + 0.36997868_pr*c4*(-0.67567294_pr + u)*(-0.091577817_pr + u)*(1.4806242_pr &
                  - 2.3819186_pr*u + u2)*(1.075619_pr - 1.644617_pr*u + u2) - 0.68655766_pr*c1*(-0.063343379_pr &
                  + u)*(0.97369203_pr + u)*(1.3870134_pr - 2.3075684_pr*u + u2)*(1.0431426_pr - 1.6344504_pr*u &
                  + u2))))/(fpi4*LambdaX*mpi2)

             dhrho1Drho1=mevfm*(gA*(0.34739925_pr*cd*(-1.3082043_pr + u)*(-0.071686644_pr + u)*(1.4677685_pr &
                  - 2.2766738_pr*u + u2)*(0.93721725_pr - 1.4019146_pr*u + u2) + gA*LambdaX*(0.7003342_pr*c4*( &
                  -0.6756734_pr + u)*(-0.093758568_pr + u)*(1.59727_pr - 2.4899591_pr*u + u2)*(1.0589336_pr &
                  - 1.6598738_pr*u + u2) - 352.88094_pr*c3*(-0.80527266_pr + u)*(-0.38439748_pr + u)*(0.56781414_pr &
                  - 1.468113_pr*u + u2)*(0.30457752_pr - 1.0189296_pr*u + u2) + 388.57352_pr*c1*(-0.83954784_pr &
                  + u)*(-0.4308896_pr + u)*(0.57229209_pr - 1.4557589_pr*u + u2)*(0.25241536_pr - 0.93218873_pr*u &
                  + u2))))/(fpi4*LambdaX*mpi2)

             dhrho0tau0=mevfm*(ga*(1.0421949_pr*cd*(-1.3082058_pr+u)*(-0.071686595_pr+u)*(1.46777_pr &
                  +(-2.2766754_pr+u)*u)*(0.93721738_pr+(-1.4019152_pr+u)*u)+ga*LambdaX*(2.1171875_pr*c4 &
                  *(-0.6756739_pr+u)*(-0.090082162_pr+u)*(1.5215283_pr+(-2.4175155_pr+u)*u)*(1.0854982_pr &
                  +(-1.6625771_pr+u)*u)+224.0_pr*c1*(-0.94326159_pr+u)*(-0.29152041_pr+u)*(0.71677264_pr &
                  +(-1.5877363_pr+u)*u)*(0.25328282_pr+(-0.77748171_pr+u)*u)+48.0_pr*c3*(0.88506991_pr &
                  +(-1.8677526_pr+u)*u)*(0.70765726_pr+(-1.4865692_pr+u)*u)*(0.079022134_pr+(-0.37067813_pr &
                  +u)*u))))/(fpi4*LambdaX*mpi2)

             dhrho1tau0=mevfm*(ga*(-0.34739831_pr*cd*(-1.3082058_pr+u)*(-0.071686595_pr+u)*(1.46777_pr &
                  +(-2.2766754_pr+u)*u)*(0.93721738_pr+(-1.4019152_pr+u)*u)+ga*LambdaX*(0.3046875_pr*c3 &
                  *(-0.75536572_pr+u)*(-0.092756738_pr+u)*(2.1347117_pr+(-2.8953677_pr+u)*u)*(1.2457416_pr &
                  +(-1.8629201_pr+u)*u)-0.6953125_pr*c4*(-0.67567303_pr+u)*(-0.089866675_pr+u)*(1.5384947_pr &
                  +(-2.4324091_pr+u)*u)*(1.0870855_pr+(-1.6682029_pr+u)*u)+1.65625_pr*c1*(-0.058760606_pr+u) &
                  *(0.81179488_pr+u)*(1.3491153_pr+(-2.2757768_pr+u)*u)*(1.0158947_pr+(-1.6126348_pr+u)*u)))) &
                  /(fpi4*LambdaX*mpi2)

             dhrho1tau1=mevfm*(ga*(-0.69479662_pr*cd*(-1.3082058_pr+u)*(-0.071686595_pr+u)*(1.46777_pr &
                  +(-2.2766754_pr+u)*u)*(0.93721738_pr+(-1.4019152_pr+u)*u)+ga*LambdaX*(-1.390625_pr*c4 &
                  *(-0.67567303_pr+u)*(-0.089866675_pr+u)*(1.5384947_pr+(-2.4324091_pr+u)*u)*(1.0870855_pr &
                  +(-1.6682029_pr+u)*u)-12.0_pr*c3*(-0.2307474_pr+u)*(0.76898229_pr+(-1.7297015_pr+u)*u) &
                  *(0.4881705_pr+(-1.0916344_pr+u)*u)-192.0_pr*c1*(-0.89170462_pr+u)*(-0.40511316_pr+u) &
                  *(0.6397114_pr+(-1.5139956_pr+u)*u)*(0.21220628_pr+(-0.78918661_pr+u)*u)))) &
                  /(fpi4*LambdaX*mpi2)

             dhJ0dr0=0.0_pr

             dhrho0DJ0=mevfm*(gA2*(-0.59709561_pr*c4*(-0.69515033_pr+u)*(-0.089020409_pr+u)*(1.4150964_pr &
                  +(-2.3274531_pr+u)*u)*(1.0076893_pr+(-1.5882571_pr+u)*u)+4.125_pr*c3*(-0.74030576_pr+u) &
                  *(-0.084829197_pr+u)*(1.3684104_pr+(-2.2855723_pr+u)*u)*(0.95092906_pr+(-1.51202_pr+u)*u) &
                  -20.0_pr*c1*(-1.0733108_pr+u)*(-0.097980712_pr+u)*(0.99914461_pr+(-1.8457061_pr+u)*u) &
                  *(0.66726597_pr+(-1.0330025_pr+u)*u)))/(fpi4*mpi2)

             dhJ1dr1=0.0_pr

             dhrho1DJ1=mevfm*(gA2*(0.39806361_pr*c4*(-0.69515033_pr+u)*(-0.089020402_pr+u)*(1.4150967_pr &
                  +(-2.3274533_pr+u)*u)*(1.0076893_pr+(-1.5882572_pr+u)*u)- 1.125_pr*c3*(-0.74849274_pr+u) &
                  *(-0.080617806_pr+u)*(1.3642178_pr+(-2.2788157_pr+u)*u)*(0.96130355_pr+(-1.5129071_pr+u)*u) &
                  -5.0_pr*c1*(1.0009125_pr+(-1.9641805_pr+u)*u)*(0.6986326_pr+(-1.3789259_pr+u)*u)*(0.041493177_pr &
                  +u*(0.16810641_pr+u))))/(fpi4*mpi2)

             dhJ0dr1=0.0_pr

             dhrho1DJ0=mevfm*(gA2*(0.19903181_pr*c4*(-0.69515033_pr+u)*(-0.089020402_pr+u)*(1.4150967_pr &
                  +(-2.3274533_pr+u)*u)*(1.0076893_pr+(-1.5882572_pr+u)*u)-0.59709555_pr*c3*(-0.69515033_pr+u) &
                  *(-0.089020406_pr+u)*(1.4150964_pr+(-2.3274531_pr+u)*u)*(1.0076893_pr+(-1.5882571_pr+u)*u) &
                  +1.4395216_pr*c1*(-1.6910704_pr+u)*(-0.073466262_pr+u)*(1.5355865_pr+(-2.3975331_pr+u)*u) &
                  *(0.99872048_pr+(-1.5169799_pr+u)*u)))/(fpi4*mpi2)

             dhJ1dr0=0.0_pr

             dhJ0J0=mevfm*(ga*(0.45817098_pr*cd*(-1.6176653_pr+u)*(-0.066866022_pr+u)*(1.7318817_pr &
                  +(-2.5016073_pr+u)*u)*(1.0139312_pr+(-1.425551_pr+u)*u)+ga*LambdaX*(1.7695313_pr*c4 &
                  *(-0.69501265_pr+u)*(-0.088068636_pr+u)*(1.3968124_pr+(-2.3120281_pr+u)*u)*(0.99464383_pr &
                  +(-1.5741511_pr+u)*u)+28.0_pr*c3*(-0.52322774_pr+u)*(-0.14878162_pr+u)*(0.83449184_pr &
                  +(-1.7952477_pr+u)*u)*(0.5636391_pr+(-1.2398858_pr+u)*u)-48.0_pr*c1*(-0.86033423_pr+u) &
                  *(-0.098046912_pr+u)*(0.71197564_pr+(-1.6379394_pr+u)*u)*(0.50452901_pr+(-1.1286795_pr &
                  +u)*u))))/(fpi4*LambdaX*mpi2)

             dhJ0J1=mevfm*(ga*(-0.30544732_pr*cd*(-1.6176653_pr+u)*(-0.066866022_pr+u)*(1.7318817_pr &
                  +(-2.5016073_pr+u)*u)*(1.0139312_pr+(-1.425551_pr+u)*u)+ga*LambdaX*(-1.1796875_pr*c4 &
                  *(-0.69501214_pr+u)*(-0.088062144_pr+u)*(1.3949349_pr+(-2.3100216_pr+u)*u)*(0.99576969_pr &
                  +(-1.5747849_pr+u)*u)-1.5332031_pr*c3*(-0.63533554_pr+u)*(-0.083219793_pr+u)*(1.2047515_pr &
                  +(-2.1485114_pr+u)*u)*(0.85574473_pr+(-1.4759269_pr+u)*u)+4.515625_pr*c1*(-1.0974449_pr+u) &
                  *(-0.076646725_pr+u)*(1.0942329_pr+(-1.9814273_pr+u)*u)*(0.7814348_pr+(-1.3562458_pr &
                  +u)*u))))/(fpi4*LambdaX*mpi2)

             dhJ1J1=mevfm*(ga*(-0.15272366_pr*cd*(-1.6176653_pr+u)*(-0.066866022_pr+u)*(1.7318817_pr &
                  +(-2.5016073_pr+u)*u)*(1.0139312_pr+(-1.425551_pr+u)*u)+ga*LambdaX*(-0.58984375_pr*c4 &
                  *(-0.69501214_pr+u)*(-0.088062144_pr+u)*(1.3949349_pr+(-2.3100216_pr+u)*u)*(0.99576969_pr &
                  +(-1.5747849_pr+u)*u)-4.0_pr*c3*(-0.59708253_pr+u)*(-0.031303824_pr+u)*(1.029716_pr &
                  +(-1.979428_pr+u)*u)*(0.81581869_pr+(-1.3671856_pr+u)*u)-16.0_pr*c1*(0.93008679_pr &
                  +(-1.8984052_pr+u)*u)*(0.65743897_pr+(-1.3677632_pr+u)*u)*(0.048712336_pr+u*(0.22866833_pr &
                  +u)))))/(fpi4*LambdaX*mpi2)

             ddhrho0rho0=mevfm*(3.5082063e-6_pr*ce*(-4.2415409_pr + u)*(-0.63600549_pr + u)*(0.36430595_pr &
                  - 1.2064733_pr*u + u2)*(0.36384534_pr - 1.2034803_pr*u + u2) + gA*(-0.10526469_pr*cd*(-15.717486_pr &
                  + u)*(-1.1063208_pr + u)*(-0.79219406_pr + u)*(-0.15821661_pr + u)*(0.99686003_pr - 1.7359229_pr*u &
                  + u2) + gA*LambdaX*(-23.140197_pr*c4*(-0.54937402_pr + u)*(-0.25617028_pr + u)*(0.87042847_pr &
                  - 1.8342813_pr*u + u2)*(0.55052287_pr - 1.1703549_pr*u + u2) + 34417.155_pr*c3*(-0.75220388_pr &
                  + u)*(-0.45847411_pr + u)*(0.49790159_pr - 1.3890715_pr*u + u2)*(0.31420079_pr - 1.0830145_pr*u &
                  + u2) + 150844.82_pr*c1*(0.5097462_pr - 1.4229463_pr*u + u2)*(0.38532363_pr - 1.2176864_pr*u &
                  + u2)*(0.27148791_pr - 1.0367952_pr*u + u2))))/(fpi4*LambdaX)

             ddhrho1rho1=mevfm*(3.5082063e-6_pr*ce*(-4.2415409_pr + u)*(-0.63600549_pr + u)*(0.36430595_pr &
                  - 1.2064733_pr*u + u2)*(0.36384534_pr - 1.2034803_pr*u + u2) + gA*(-0.10526469_pr*cd*(-15.717486_pr &
                  + u)*(-1.1063208_pr + u)*(-0.79219406_pr + u)*(-0.15821661_pr + u)*(0.99686003_pr - 1.7359229_pr*u &
                  + u2) + gA*LambdaX*(-23.140197_pr*c4*(-0.54937402_pr + u)*(-0.25617028_pr + u)*(0.87042847_pr &
                  - 1.8342813_pr*u + u2)*(0.55052287_pr - 1.1703549_pr*u + u2) + 34417.155_pr*c3*(-0.75220388_pr &
                  + u)*(-0.45847411_pr + u)*(0.49790159_pr - 1.3890715_pr*u + u2)*(0.31420079_pr - 1.0830145_pr*u &
                  + u2) + 150844.82_pr*c1*(0.5097462_pr - 1.4229463_pr*u + u2)*(0.38532363_pr - 1.2176864_pr*u &
                  + u2)*(0.27148791_pr - 1.0367952_pr*u + u2))))/(fpi4*LambdaX)

             ddhrho0Drho0=mevfm*(gA*(-3.1120954_pr*cd*(-0.30605132_pr + u)*(1.2680842_pr + u)*(1.0861033_pr &
                  - 2.0506502_pr*u + u2)*(0.79950278_pr - 1.5067227_pr*u + u2) + gA*LambdaX*(-24514.431_pr*c3*( &
                  -0.76031522_pr + u)*(-0.46096893_pr + u)*(0.49710047_pr - 1.3844361_pr*u + u2)*(0.29795986_pr &
                  - 1.055072_pr*u + u2) + 22229.743_pr*c1*(-0.74615955_pr + u)*(-0.61188783_pr + u)*(0.46154959_pr &
                  - 1.3315221_pr*u + u2)*(0.25673397_pr - 0.99266282_pr*u + u2) + 110.78144_pr*c4*(-0.8714267_pr &
                  + u)*(-0.31340402_pr + u)*(0.6979966_pr - 1.6133393_pr*u + u2)*(0.37679963_pr - 0.97187797_pr*u &
                  + u2))))/(fpi4*LambdaX*mpi2)

             ddhrho1Drho0=mevfm*(gA*(1.0374387_pr*cd*(-0.30605117_pr + u)*(1.2679976_pr + u)*(1.0860961_pr &
                  - 2.0506436_pr*u + u2)*(0.79949758_pr - 1.5067185_pr*u + u2) + gA*LambdaX*(7.4928249_pr*c1*( &
                  -0.37847001_pr + u)*(0.20959238_pr + u)*(1.3329648_pr - 2.2776684_pr*u + u2)*(0.96918292_pr &
                  - 1.6804594_pr*u + u2) + 0.50449085_pr*c4*(-0.25756953_pr + u)*(4.642167_pr + u)*(1.0022598_pr &
                  - 1.987984_pr*u + u2)*(0.89301348_pr - 1.6569412_pr*u + u2) - 8.2338865_pr*c3*(-0.24176677_pr &
                  + u)*(-0.021931235_pr + u)*(0.86956532_pr - 1.8470984_pr*u + u2)*(0.70044277_pr - 1.4791249_pr*u &
                  + u2))))/(fpi4*LambdaX*mpi2)

             ddhrho1Drho1=mevfm*(gA*(2.0747303_pr*cd*(-0.30605132_pr + u)*(1.2680842_pr + u)*(1.0861033_pr &
                  - 2.0506502_pr*u + u2)*(0.79950278_pr - 1.5067227_pr*u + u2) + gA*LambdaX*(15284.793_pr*c3*( &
                  -0.74604143_pr + u)*(-0.48901435_pr + u)*(0.48038865_pr - 1.3647474_pr*u + u2)*(0.30523896_pr &
                  - 1.0777475_pr*u + u2) - 73.854292_pr*c4*(-0.8714267_pr + u)*(-0.31340402_pr + u)*(0.6979966_pr &
                  - 1.6133393_pr*u + u2)*(0.37679963_pr - 0.97187797_pr*u + u2) - 14523.513_pr*c1*(0.51615934_pr &
                  - 1.4339319_pr*u + u2)*(0.42639291_pr - 1.2743751_pr*u + u2)*(0.23481515_pr - 0.95144731_pr*u &
                  + u2))))/(fpi4*LambdaX*mpi2)

             ddhrho0tau0=mevfm*(ga*(6.2246138_pr*cd*(-0.30605117_pr+u)*(1.2680013_pr+u)*(1.0860964_pr &
                  +(-2.0506438_pr+u)*u)*(0.79949779_pr+(-1.5067187_pr+u)*u)+ga*LambdaX*(7.25_pr*c4*(-0.25490416_pr &
                  +u)*(1.9314619_pr+u)*(0.97416501_pr+(-1.9598149_pr+u)*u)*(0.85402263_pr+(-1.6270877_pr+u)*u) &
                  -4096.0_pr*c1*(-0.82877841_pr+u)*(-0.61205527_pr+u)*(0.55294169_pr+(-1.4322212_pr+u)*u) &
                  *(0.21133499_pr+(-0.85194512_pr+u)*u)-1024.0_pr*c3*(-1.5110662_pr+u)*(-0.81113397_pr+u) &
                  *(0.48220899_pr+(-1.3083223_pr+u)*u)*(0.13559828_pr+(-0.71947752_pr+u)*u))))/(fpi4*LambdaX*mpi2)

             ddhrho1tau0=mevfm*(ga*(-2.0748713_pr*cd*(-0.30605117_pr+u)*(1.2680013_pr+u)*(1.0860964_pr &
                  +(-2.0506438_pr+u)*u)*(0.79949779_pr+(-1.5067187_pr+u)*u)+ga*LambdaX*(-2.1875_pr*c4 &
                  *(-0.25526539_pr+u)*(2.1267165_pr+u)*(0.98082879_pr+(-1.9667092_pr+u)*u)*(0.86027632_pr &
                  +(-1.6333133_pr+u)*u)+4.0_pr*c3*(-0.27578203_pr+u)*(0.73913647_pr+u)*(0.98670704_pr &
                  +(-1.9658775_pr+u)*u)*(0.85430872_pr+(-1.6131019_pr+u)*u)-29.0_pr*c1*(-0.37708308_pr+u) &
                  *(0.063860656_pr+u)*(1.1337991_pr+(-2.0962155_pr+u)*u)*(0.84554078_pr+(-1.5461655_pr+u)*u)))) &
                  /(fpi4*LambdaX*mpi2)

             ddhrho1tau1=mevfm*(ga*(-4.1497425_pr*cd*(-0.30605117_pr+u)*(1.2680013_pr+u)*(1.0860964_pr &
                  +(-2.0506438_pr+u)*u)*(0.79949779_pr+(-1.5067187_pr+u)*u)+ga*LambdaX*(-4.375_pr*c4 &
                  *(-0.25526539_pr+u)*(2.1267165_pr+u)*(0.98082879_pr+(-1.9667092_pr+u)*u)*(0.86027632_pr &
                  +(-1.6333133_pr+u)*u)-9728.0_pr*c1*(-0.72811509_pr+u)*(-0.40683586_pr+u)*(0.51101775_pr &
                  +(-1.4100026_pr+u)*u)*(0.32463579_pr+(-1.0747833_pr+u)*u)+1536.0_pr*c3*(0.61725539_pr &
                  +(-1.5571261_pr+u)*u)*(0.39877632_pr+(-1.1610973_pr+u)*u)*(0.15498418_pr+(-0.77760994_pr &
                  +u)*u))))/(fpi4*LambdaX*mpi2)

          End If !! if (u.gt.ucut3n..
       End If !! if(use_dme3N_terms
       !
    End If !! if (dmeorder.ge.2....
    !
    Urhorho=0.0_pr   ; Urhotau=0.0_pr
    UrhoDrho=0.0_pr  ; Unablarho=0.0_pr
    UJnablarho=0.0_pr; UrhonablaJ=0.0_pr
    Urhorhopr=0.0_pr ; UJJ=0.0_pr
    !
    ! Notations for Uamplitudes(0:3,0:7)
    ! t for Uamplitudes(t,*)
    ! 0 -> 0,0
    ! 1 -> 1,1
    ! 2 -> 0,1
    ! 3 -> 1,0
    ! n for Uamplitudes(*,n)
    ! 0 -> U
    ! 1 -> dU/dRHO_0
    ! 2 -> dU/dRHO_1
    ! 3 -> d2U/(dRHO_0*dRHO_0)
    ! 4 -> d2U/(dRHO_1*dRHO_1) 
    ! 5 -> d2U/(dRHO_0*dRHO_1) 
    ! 6 -> dU/d(TAU_0)   
    ! 7 -> dU/d(Delta RHO_0)   
    !
    !! 2N terms
    Do t=0,1
       ph=1.0_pr
       If(t.Eq.1) ph=-1.0_pr
       Urhorho(t,0)=Crho(t)+Cdrho(t)*rho(0)**sigma &
            +0.50_pr*(arhorho+ph*brhorho)*mevfm
       Urhotau(t,0)=Ctau(t)+0.50_pr*(arhotau+ph*brhotau)*mevfm
       UrhoDrho(t,0)=Crdr(t)+ac2*0.50_pr*(arhoDrho+ph*brhoDrho)*mevfm
       UJJ(t,0)=CJ(t)+0.50_pr*(ajj+ph*bjj)*mevfm
       Unablarho(t,0)=Cnrho(t)+0.50_pr*(adrdr+ph*bdrdr)*mevfm
       UrhonablaJ(t,0)=Crdj(t)
       UJnablarho(t,0)=Cjdr(t)
!!       Urhorhopr(t,0)=CpV0(t)+CpV1(t)*rho(0)

       Urhorho(t,1)=sigma*Cdrho(t)*(rho(0)**sigma)/(rho(0)+eps) &
            +0.50_pr*(darhorho+ph*dbrhorho)*du*mevfm
       Urhotau(t,1)=0.50_pr*(darhotau+ph*dbrhotau)*du*mevfm
       UrhoDrho(t,1)=ac2*0.50_pr*(darhoDrho+ph*dbrhoDrho)*du*mevfm
       UJJ(t,1)=0.50_pr*(dajj+ph*dbjj)*du*mevfm
       Unablarho(t,1)=0.50_pr*(dadrdr+ph*dbdrdr)*du*mevfm

       Urhorho(t,6)=0.50_pr*(darhorho+ph*dbrhorho)*dtu*mevfm
       Urhotau(t,6)=0.50_pr*(darhotau+ph*dbrhotau)*dtu*mevfm
       UrhoDrho(t,6)=ac2*0.50_pr*(darhoDrho+ph*dbrhoDrho)*dtu*mevfm
       UJJ(t,6)=0.50_pr*(dajj+ph*dbjj)*dtu*mevfm
       Unablarho(t,6)=0.50_pr*(dadrdr+ph*dbdrdr)*dtu*mevfm

       Urhorho(t,7)=0.50_pr*(darhorho+ph*dbrhorho)*dlu*mevfm
       Urhotau(t,7)=0.50_pr*(darhotau+ph*dbrhotau)*dlu*mevfm
       UrhoDrho(t,7)=ac2*0.50_pr*(darhoDrho+ph*dbrhoDrho)*dlu*mevfm
       UJJ(t,7)=0.50_pr*(dajj+ph*dbjj)*dlu*mevfm
       Unablarho(t,7)=0.50_pr*(dadrdr+ph*dbdrdr)*dlu*mevfm


       Urhorho(t,3)=sigma*(sigma-1.0_pr)*Cdrho(t)*(rho(0)**sigma)/(rho(0)**2+eps) &
            +0.50_pr*(darhorho+ph*dbrhorho)*ddu*mevfm &
            +0.50_pr*(ddarhorho+ph*ddbrhorho)*du*du*mevfm
       Urhotau(t,3)=0.50_pr*(darhotau+ph*dbrhotau)*ddu*mevfm &
            +0.50_pr*(ddarhotau+ph*ddbrhotau)*du*du*mevfm
       UrhoDrho(t,3)=ac2*0.50_pr*(darhoDrho+ph*dbrhoDrho)*ddu*mevfm &
            +ac2*0.50_pr*(ddarhoDrho+ph*ddbrhoDrho)*du*du*mevfm

!!       Urhorhopr(t,1)=CpV1(t)
    End Do
    Urhorhopr(0,0) = CpV0(0)*(1.0_pr-CpV1(0)*rho(0)/0.16_pr)          &
                    +CpV0(1)*(1.0_pr-CpV1(1)*rho(0)/0.16_pr)
    Urhorhopr(1,0) = CpV0(0)*(1.0_pr-CpV1(0)*rho(0)/0.16_pr)          &
                    +CpV0(1)*(1.0_pr-CpV1(1)*rho(0)/0.16_pr)
    Urhorhopr(2,0) = (CpV0(0)*(1.0_pr-CpV1(0)*rho(0)/0.16_pr)         &
                     -CpV0(1)*(1.0_pr-CpV1(1)*rho(0)/0.16_pr))*2.0_pr
    Urhorhopr(0,1) = (-CpV0(0)*CpV1(0)-CpV0(1)*CpV1(1))/0.16_pr
    Urhorhopr(1,1) = (-CpV0(0)*CpV1(0)-CpV0(1)*CpV1(1))/0.16_pr
    Urhorhopr(2,1) = 2.0_pr*(-CpV0(0)*CpV1(0)+CpV0(1)*CpV1(1))/0.16_pr
    Urhorhopr=Urhorhopr/16.0_pr

    !! 3N terms
    If (use_DME3N_terms) Then 
       Urhorho(0,0)=Urhorho(0,0)+hrho0rho0*rho(0)
       Urhorho(1,0)=Urhorho(1,0)+hrho1rho1*rho(0)
       Unablarho(0,0)=Unablarho(0,0)+hdr0dr0*rho(0)
       Unablarho(1,0)=Unablarho(1,0)+hdr1dr1*rho(0)
       UrhoDrho(0,0)=UrhoDrho(0,0)+hrho0Drho0*rho(0)*ac3
       UrhoDrho(1,0)=UrhoDrho(1,0)+hrho1Drho1*rho(0)*ac3
       UrhoDrho(3,0)=UrhoDrho(3,0)+hrho1Drho0*rho(1)*ac3
       Urhotau(0,0)=Urhotau(0,0)+hrho0tau0*rho(0)
       Urhotau(1,0)=Urhotau(1,0)+hrho1tau1*rho(0)
       Urhotau(3,0)=Urhotau(3,0)+hrho1tau0*rho(1)
       UJnablarho(0,0)=UJnablarho(0,0)+hJ0dr0*rho(0)
       UJnablarho(1,0)=UJnablarho(1,0)+hJ1dr1*rho(0)
       UJnablarho(2,0)=UJnablarho(2,0)+hJ0dr1*rho(1)
       UJnablarho(3,0)=UJnablarho(3,0)+hJ1dr0*rho(1)
       UrhonablaJ(0,0)=UrhonablaJ(0,0)+hrho0dJ0*rho(0)
       UrhonablaJ(1,0)=UrhonablaJ(1,0)+hrho1dJ1*rho(0)
       UrhonablaJ(3,0)=UrhonablaJ(3,0)+hrho1dJ0*rho(1)
       UJJ(0,0)=UJJ(0,0)+hJ0J0*rho(0)
       UJJ(1,0)=UJJ(1,0)+hJ1J1*rho(0)
       UJJ(2,0)=UJJ(2,0)+hJ0J1*rho(1)

       Urhorho(0,1)=Urhorho(0,1)+dhrho0rho0*du*rho(0) +hrho0rho0
       Urhorho(1,1)=Urhorho(1,1)+dhrho1rho1*du*rho(0) +hrho1rho1
       Unablarho(0,1)=Unablarho(0,1)+dhdr0dr0*du*rho(0) +hdr0dr0
       Unablarho(1,1)=Unablarho(1,1)+dhdr1dr1*du*rho(0) +hdr1dr1
       UrhoDrho(0,1)=UrhoDrho(0,1)+(dhrho0Drho0*du*rho(0) +hrho0Drho0)*ac3
       UrhoDrho(1,1)=UrhoDrho(1,1)+(dhrho1Drho1*du*rho(0) +hrho1Drho1)*ac3
       UrhoDrho(3,1)=UrhoDrho(3,1)+dhrho1Drho0*du*rho(1)*ac3
       Urhotau(0,1)=Urhotau(0,1)+dhrho0tau0*du*rho(0) +hrho0tau0
       Urhotau(1,1)=Urhotau(1,1)+dhrho1tau1*du*rho(0) +hrho1tau1
       Urhotau(3,1)=Urhotau(3,1)+dhrho1tau0*du*rho(1)
       UJnablarho(0,1)=UJnablarho(0,1)+dhJ0dr0*du*rho(0) +hJ0dr0
       UJnablarho(1,1)=UJnablarho(1,1)+dhJ1dr1*du*rho(0) +hJ1dr1
       UJnablarho(2,1)=UJnablarho(2,1)+dhJ0dr1*du*rho(1)
       UJnablarho(3,1)=UJnablarho(3,1)+dhJ1dr0*du*rho(1)
       UrhonablaJ(0,1)=UrhonablaJ(0,1)+dhrho0dJ0*du*rho(0) +hrho0dJ0
       UrhonablaJ(1,1)=UrhonablaJ(1,1)+dhrho1dJ1*du*rho(0) +hrho1dJ1
       UrhonablaJ(3,1)=UrhonablaJ(3,1)+dhrho1dJ0*du*rho(1)
       UJJ(0,1)=UJJ(0,1)+dhJ0J0*du*rho(0) +hJ0J0
       UJJ(1,1)=UJJ(1,1)+dhJ1J1*du*rho(0) +hJ1J1
       UJJ(2,1)=UJJ(2,1)+dhJ0J1*du*rho(1)

       Urhorho(0,6)=Urhorho(0,6)+dhrho0rho0*dtu*rho(0)
       Urhorho(1,6)=Urhorho(1,6)+dhrho1rho1*dtu*rho(0)
       Unablarho(0,6)=Unablarho(0,6)+dhdr0dr0*dtu*rho(0)
       Unablarho(1,6)=Unablarho(1,6)+dhdr1dr1*dtu*rho(0)
       UrhoDrho(0,6)=UrhoDrho(0,6)+dhrho0Drho0*dtu*rho(0)*ac3
       UrhoDrho(1,6)=UrhoDrho(1,6)+dhrho1Drho1*dtu*rho(0)*ac3
       UrhoDrho(3,6)=UrhoDrho(3,6)+dhrho1Drho0*dtu*rho(1)*ac3
       Urhotau(0,6)=Urhotau(0,6)+dhrho0tau0*dtu*rho(0)
       Urhotau(1,6)=Urhotau(1,6)+dhrho1tau1*dtu*rho(0)
       Urhotau(3,6)=Urhotau(3,6)+dhrho1tau0*dtu*rho(1)
       UJnablarho(0,6)=UJnablarho(0,6)+dhJ0dr0*dtu*rho(0)
       UJnablarho(1,6)=UJnablarho(1,6)+dhJ1dr1*dtu*rho(0)
       UJnablarho(2,6)=UJnablarho(2,6)+dhJ0dr1*dtu*rho(1)
       UJnablarho(3,6)=UJnablarho(3,6)+dhJ1dr0*dtu*rho(1)
       UrhonablaJ(0,6)=UrhonablaJ(0,6)+dhrho0dJ0*dtu*rho(0)
       UrhonablaJ(1,6)=UrhonablaJ(1,6)+dhrho1dJ1*dtu*rho(0)
       UrhonablaJ(3,6)=UrhonablaJ(3,6)+dhrho1dJ0*dtu*rho(1)
       UJJ(0,6)=UJJ(0,6)+dhJ0J0*dtu*rho(0)
       UJJ(1,6)=UJJ(1,6)+dhJ1J1*dtu*rho(0)
       UJJ(2,6)=UJJ(2,6)+dhJ0J1*dtu*rho(1)

       Urhorho(0,7)=Urhorho(0,7)+dhrho0rho0*dlu*rho(0)
       Urhorho(1,7)=Urhorho(1,7)+dhrho1rho1*dlu*rho(0)
       Unablarho(0,7)=Unablarho(0,7)+dhdr0dr0*dlu*rho(0)
       Unablarho(1,7)=Unablarho(1,7)+dhdr1dr1*dlu*rho(0)
       UrhoDrho(0,7)=UrhoDrho(0,7)+dhrho0Drho0*dlu*rho(0)*ac3
       UrhoDrho(1,7)=UrhoDrho(1,7)+dhrho1Drho1*dlu*rho(0)*ac3
       UrhoDrho(3,7)=UrhoDrho(3,7)+dhrho1Drho0*dlu*rho(1)*ac3
       Urhotau(0,7)=Urhotau(0,7)+dhrho0tau0*dlu*rho(0)
       Urhotau(1,7)=Urhotau(1,7)+dhrho1tau1*dlu*rho(0)
       Urhotau(3,7)=Urhotau(3,7)+dhrho1tau0*dlu*rho(1)
       UJnablarho(0,7)=UJnablarho(0,7)+dhJ0dr0*dlu*rho(0)
       UJnablarho(1,7)=UJnablarho(1,7)+dhJ1dr1*dlu*rho(0)
       UJnablarho(2,7)=UJnablarho(2,7)+dhJ0dr1*dlu*rho(1)
       UJnablarho(3,7)=UJnablarho(3,7)+dhJ1dr0*dlu*rho(1)
       UrhonablaJ(0,7)=UrhonablaJ(0,7)+dhrho0dJ0*dlu*rho(0)
       UrhonablaJ(1,7)=UrhonablaJ(1,7)+dhrho1dJ1*dlu*rho(0)
       UrhonablaJ(3,7)=UrhonablaJ(3,7)+dhrho1dJ0*dlu*rho(1)
       UJJ(0,7)=UJJ(0,7)+dhJ0J0*dlu*rho(0)
       UJJ(1,7)=UJJ(1,7)+dhJ1J1*dlu*rho(0)
       UJJ(2,7)=UJJ(2,7)+dhJ0J1*dlu*rho(1)


       Urhorho(0,3)=Urhorho(0,3)+2.0_pr*dhrho0rho0*du &
            +ddhrho0rho0*du*du*rho(0) +dhrho0rho0*ddu*rho(0)
       Urhorho(1,3)=Urhorho(1,3)+2.0_pr*dhrho1rho1*du &
            +ddhrho1rho1*du*du*rho(0) +dhrho1rho1*ddu*rho(0)
       UrhoDrho(0,3)=UrhoDrho(0,3)+(2.0_pr*dhrho0Drho0*du &
            +ddhrho0Drho0*du*du*rho(0) +dhrho0Drho0*ddu*rho(0))*ac3
       UrhoDrho(1,3)=UrhoDrho(1,3)+(2.0_pr*dhrho1Drho1*du &
            +ddhrho1Drho1*du*du*rho(0)+dhrho1Drho1*ddu*rho(0))*ac3
       Urhotau(0,3)=Urhotau(0,3)+2.0_pr*dhrho0tau0*du &
            +ddhrho0tau0*du*du*rho(0) +dhrho0tau0*ddu*rho(0)
       Urhotau(1,3)=Urhotau(1,3)+2.0_pr*dhrho1tau1*du &
            +ddhrho1tau1*du*du*rho(0) +dhrho1tau1*ddu*rho(0)
       UrhoDrho(3,3)=UrhoDrho(3,3) +(ddhrho1Drho0*du*du*rho(1) &
            +dhrho1Drho0*ddu*rho(1))*ac3
       Urhotau(3,3)=Urhotau(3,3) +ddhrho1tau0*du*du*rho(1) &
            +dhrho1tau0*ddu*rho(1) 


       UrhoDrho(3,2)=UrhoDrho(3,2)+hrho1Drho0*ac3
       Urhotau(3,2)=Urhotau(3,2)+hrho1tau0
       UJnablarho(3,2)=UJnablarho(3,2)+hJ1dr0
       UJnablarho(2,2)=UJnablarho(2,2)+hJ0dr1
       UrhonablaJ(3,2)=UrhonablaJ(3,2)+hrho1dJ0
       UJJ(2,2)=UJJ(2,2)+hJ0J1
       
       UrhoDrho(3,5)=UrhoDrho(3,5) +dhrho1Drho0*du*ac3
       Urhotau(3,5)=Urhotau(3,5) +dhrho1tau0*du

    End If   !! if(use3Nterm..

    UEnonstdr=0.0_pr; UFnonstdr=0.0_pr; URnonstdr=0.0_pr    
    !
    if (.not.use_j2terms) then
      UJJ=0.0_pr
    end if
    !
  End Subroutine calculate_U_parameters
  !==================================================================================
  !
  !==================================================================================
  Subroutine load_tables
    !==================================================================================
    Implicit None
    !
    !  Urho0rho0
    !
    ctr0r0=0.0_pr
    ctr0r0(1,1,1) = (-0.964246762695464_pr*c3*gA2)/fpi4 - &
         (0.0263462308309038_pr*c4*gA2)/fpi4 - (0.1875_pr*ce)/(fpi4*LambdaX) + &
         (0.046875_pr*cd*ga)/(fpi4*LambdaX)
    ctr0r0(1,1,3) = (-6.84195361981036_pr*c1*gA2)/fpi4 + &
         (5.01410456224811_pr*c3*gA2)/fpi4 + (0.0732776804846939_pr*c4*gA2)/fpi4 &
         - (0.06328125_pr*cd*ga)/(fpi4*LambdaX)
    ctr0r0(2,1,3) = (0.147698198400372_pr*c3*gA2)/fpi4 + &
         (0.0703526785714286_pr*c4*gA2)/fpi4 - &
         (0.02109375_pr*cd*ga)/(fpi4*LambdaX)
    ctr0r0(1,2,4) = (-0.1875_pr*c3*gA2)/fpi4 - (0.375_pr*c4*gA2)/fpi4 + &
         (0.140625_pr*cd*ga)/(fpi4*LambdaX)
    ctr0r0(1,1,5) = (-23.1434396482781_pr*c1*gA2)/fpi4 + &
         (12.2465870768616_pr*c3*gA2)/fpi4 - (0.18795405731824_pr*c4*gA2)/fpi4 + &
         (0.017578125_pr*cd*ga)/(fpi4*LambdaX)
    ctr0r0(2,1,5) = (35.0618960855328_pr*c1*gA2)/fpi4 - &
         (16.8781682906031_pr*c3*gA2)/fpi4 + (0.0543163105867347_pr*c4*gA2)/fpi4 &
         - (0.06328125_pr*cd*ga)/(fpi4*LambdaX)
    ctr0r0(1,2,6) = (-325.455281192602_pr*c1*gA2)/fpi4 + &
         (83.7334611805583_pr*c3*gA2)/fpi4 + (1.3574300625_pr*c4*gA2)/fpi4
    ctr0r0(2,2,6) = (32.9911875098339_pr*c3*gA2)/fpi4 + &
         (0.16875_pr*c4*gA2)/fpi4
    ctr0r0(1,1,7) = (-5761.43588948783_pr*c1*gA2)/fpi4 - &
         (869.283572934387_pr*c3*gA2)/fpi4 - (13.4068326170281_pr*c4*gA2)/fpi4
    ctr0r0(2,1,7) = (2192.10779645869_pr*c1*gA2)/fpi4 + &
         (263.842952909344_pr*c3*gA2)/fpi4 + (3.99388560267857_pr*c4*gA2)/fpi4 - &
         (0.00439453125_pr*cd*ga)/(fpi4*LambdaX)
    ctr0r0(3,1,7) = (-198.153843790565_pr*c1*gA2)/fpi4 - &
         (58.742085950407_pr*c3*gA2)/fpi4 - (0.4904296875_pr*c4*gA2)/fpi4
    ctr0r0(1,3,7) = (-526.213527565944_pr*c3*gA2)/fpi4 - &
         (2.84068526785714_pr*c4*gA2)/fpi4
    ctr0r0(1,2,8) = (11194.2459766741_pr*c1*gA2)/fpi4 - &
         (901.889210563564_pr*c3*gA2)/fpi4 + (1.90516445471939_pr*c4*gA2)/fpi4
    ctr0r0(2,2,8) = (-751.043571428571_pr*c1*gA2)/fpi4 + &
         (1336.68785503856_pr*c3*gA2)/fpi4 + (4.15185267857143_pr*c4*gA2)/fpi4
    ctr0r0(1,1,9) = (-19577.5085802329_pr*c1*gA2)/fpi4 - &
         (20061.3662796935_pr*c3*gA2)/fpi4 - (402.203416845285_pr*c4*gA2)/fpi4
    ctr0r0(2,1,9) = (6927.60941249884_pr*c1*gA2)/fpi4 + &
         (10204.912096572_pr*c3*gA2)/fpi4 + (157.45919188058_pr*c4*gA2)/fpi4
    ctr0r0(3,1,9) = (-1688.44574624066_pr*c1*gA2)/fpi4 - &
         (1848.73711933536_pr*c3*gA2)/fpi4 - (17.251846749442_pr*c4*gA2)/fpi4
    ctr0r0(1,3,9) = (-14639.9109308036_pr*c1*gA2)/fpi4 - &
         (2073.4495546875_pr*c3*gA2)/fpi4 + (12.406921875_pr*c4*gA2)/fpi4
    ctr0r0(1,2,10) = (-6051.26397950415_pr*c1*gA2)/fpi4 + &
         (25318.5711035127_pr*c3*gA2)/fpi4 + (1111.77481741071_pr*c4*gA2)/fpi4
    ctr0r0(2,2,10) = (20263.462438058_pr*c1*gA2)/fpi4 - &
         (645.573171294818_pr*c3*gA2)/fpi4 - (220.10902734375_pr*c4*gA2)/fpi4
    ctr0r0(1,1,11) = (-117612.589511906_pr*c1*gA2)/fpi4 - &
         (22681.6420225835_pr*c3*gA2)/fpi4 + (1494.47871529855_pr*c4*gA2)/fpi4
    ctr0r0(2,1,11) = (78131.8227221231_pr*c1*gA2)/fpi4 + &
         (11306.3195229362_pr*c3*gA2)/fpi4 - (1044.42429449456_pr*c4*gA2)/fpi4
    ctr0r0(3,1,11) = (-19244.1407277278_pr*c1*gA2)/fpi4 - &
         (4031.58809797695_pr*c3*gA2)/fpi4 + (143.952209472656_pr*c4*gA2)/fpi4
    ctr0r0(1,3,11) = (-12782.365790625_pr*c1*gA2)/fpi4 - &
         (19898.5801884375_pr*c3*gA2)/fpi4 - (763.061715_pr*c4*gA2)/fpi4
    ctr0r0(1,2,12) = (112532.892207631_pr*c1*gA2)/fpi4 + &
         (2673.93101274094_pr*c3*gA2)/fpi4 - (3075.39951940848_pr*c4*gA2)/fpi4
    ctr0r0(2,2,12) = (-4174.98147321429_pr*c1*gA2)/fpi4 + &
         (16959.475747232_pr*c3*gA2)/fpi4 + (1249.48156138393_pr*c4*gA2)/fpi4
    ctr0r0(1,1,13) = (-62220.7516704385_pr*c1*gA2)/fpi4 - &
         (37645.4468013683_pr*c3*gA2)/fpi4 - (1458.88122707611_pr*c4*gA2)/fpi4
    ctr0r0(2,1,13) = (49392.5657264478_pr*c1*gA2)/fpi4 + &
         (35938.6848928339_pr*c3*gA2)/fpi4 + (1614.83538151428_pr*c4*gA2)/fpi4
    ctr0r0(3,1,13) = (-21590.8338635122_pr*c1*gA2)/fpi4 - &
         (12971.4689072793_pr*c3*gA2)/fpi4 - (402.76586151123_pr*c4*gA2)/fpi4
    ctr0r0(1,3,13) = (-66293.2611893973_pr*c1*gA2)/fpi4 - &
         (8811.70601861049_pr*c3*gA2)/fpi4 + (1385.87636601563_pr*c4*gA2)/fpi4
    ctr0r0(1,2,14) = (-8634.9144059954_pr*c1*gA2)/fpi4 + &
         (13584.0523217795_pr*c3*gA2)/fpi4 + (1941.14579905622_pr*c4*gA2)/fpi4
    ctr0r0(2,2,14) = (46092.3086405378_pr*c1*gA2)/fpi4 + &
         (6421.96926354563_pr*c3*gA2)/fpi4 - (1169.36919344657_pr*c4*gA2)/fpi4
    ctr0r0(1,1,15) = (-54823.1734859566_pr*c1*gA2)/fpi4 - &
         (21478.1701524643_pr*c3*gA2)/fpi4 + (30.6758968031093_pr*c4*gA2)/fpi4
    ctr0r0(2,1,15) = (79796.8451847046_pr*c1*gA2)/fpi4 + &
         (29550.3190922257_pr*c3*gA2)/fpi4 - (265.149560200718_pr*c4*gA2)/fpi4
    ctr0r0(3,1,15) = (-34549.4910141965_pr*c1*gA2)/fpi4 - &
         (12487.0361763301_pr*c3*gA2)/fpi4 + (129.866342965262_pr*c4*gA2)/fpi4
    ctr0r0(1,3,15) = (-6841.585265625_pr*c1*gA2)/fpi4 - &
         (8394.50421527972_pr*c3*gA2)/fpi4 - (637.487162214007_pr*c4*gA2)/fpi4
    ctr0r0(1,2,16) = (-966.144667675781_pr*c1*gA2)/fpi4 - &
         (1635.80437776282_pr*c3*gA2)/fpi4 - (20.2837476928711_pr*c4*gA2)/fpi4
    ctr0r0(2,2,16) = (10019.4643315377_pr*c1*gA2)/fpi4 + &
         (5806.54125301064_pr*c3*gA2)/fpi4 + (162.342586296387_pr*c4*gA2)/fpi4
    ctr0r0(1,1,17) = (-27328.2660786696_pr*c1*gA2)/fpi4 - &
         (11536.8965413_pr*c3*gA2)/fpi4 - (0.153939957765852_pr*c4*gA2)/fpi4
    ctr0r0(2,1,17) = (51084.8335772702_pr*c1*gA2)/fpi4 + &
         (21317.5006264206_pr*c3*gA2)/fpi4 - (5.04213459735325_pr*c4*gA2)/fpi4
    ctr0r0(3,1,17) = (-23176.714608858_pr*c1*gA2)/fpi4 - &
         (9591.77377013768_pr*c3*gA2)/fpi4 - (7.01374572372437_pr*c4*gA2)/fpi4
    ctr0r0(1,3,17) = (-839.926762520926_pr*c1*gA2)/fpi4
    ctr0r0(1,2,18) = (-71.6191333138602_pr*c1*gA2)/fpi4 - &
         (29.5562121168625_pr*c3*gA2)/fpi4
    ctr0r0(2,2,18) = (1117.2724960968_pr*c1*gA2)/fpi4 + &
         (423.729200499137_pr*c3*gA2)/fpi4 + (5.07093692321777_pr*c4*gA2)/fpi4
    ctr0r0(1,1,19) = (-9253.22855094582_pr*c1*gA2)/fpi4 - &
         (4005.49423137719_pr*c3*gA2)/fpi4
    ctr0r0(2,1,19) = (21870.1711895189_pr*c1*gA2)/fpi4 + &
         (9310.62118848288_pr*c3*gA2)/fpi4 + (0.0769699788829259_pr*c4*gA2)/fpi4
    ctr0r0(3,1,19) = (-11369.3247545611_pr*c1*gA2)/fpi4 - &
         (4767.97117814042_pr*c3*gA2)/fpi4 - (0.656709900856018_pr*c4*gA2)/fpi4
    ctr0r0(2,2,20) = (17.9047833284651_pr*c1*gA2)/fpi4 + &
         (7.38905302921563_pr*c3*gA2)/fpi4
    ctr0r0(1,1,21) = (-2139.34177995088_pr*c1*gA2)/fpi4 - &
         (951.965547431256_pr*c3*gA2)/fpi4
    ctr0r0(2,1,21) = (6585.92097742191_pr*c1*gA2)/fpi4 + &
         (2872.41393631472_pr*c3*gA2)/fpi4
    ctr0r0(3,1,21) = (-4206.97567815619_pr*c1*gA2)/fpi4 - &
         (1804.69962149452_pr*c3*gA2)/fpi4 - &
         (0.00962124736036573_pr*c4*gA2)/fpi4
    ctr0r0(1,1,23) = (-320.600347402137_pr*c1*gA2)/fpi4 - &
         (147.828203709359_pr*c3*gA2)/fpi4
    ctr0r0(2,1,23) = (1373.03667928303_pr*c1*gA2)/fpi4 + &
         (615.472966679238_pr*c3*gA2)/fpi4
    ctr0r0(3,1,23) = (-1139.80667854591_pr*c1*gA2)/fpi4 - &
         (500.614173373695_pr*c3*gA2)/fpi4
    ctr0r0(1,1,25) = (-28.0192319249075_pr*c1*gA2)/fpi4 - &
         (13.7137479594838_pr*c3*gA2)/fpi4
    ctr0r0(2,1,25) = (187.596940698279_pr*c1*gA2)/fpi4 + &
         (87.2234077809484_pr*c3*gA2)/fpi4
    ctr0r0(3,1,25) = (-216.193884091206_pr*c1*gA2)/fpi4 - &
         (97.5972978305762_pr*c3*gA2)/fpi4
    ctr0r0(1,1,27) = (-1.08369739154545_pr*c1*gA2)/fpi4 - &
         (0.619027285041159_pr*c3*gA2)/fpi4
    ctr0r0(2,1,27) = (15.0933133539992_pr*c1*gA2)/fpi4 + &
         (7.47177985304339_pr*c3*gA2)/fpi4
    ctr0r0(3,1,27) = (-27.1326378098226_pr*c1*gA2)/fpi4 - &
         (12.7192853287926_pr*c3*gA2)/fpi4
    ctr0r0(1,1,29) = (-0.00618211760948692_pr*c3*gA2)/fpi4
    ctr0r0(2,1,29) = (0.541848695772724_pr*c1*gA2)/fpi4 + &
         (0.315695760130066_pr*c3*gA2)/fpi4
    ctr0r0(3,1,29) = (-2.02212634319308_pr*c1*gA2)/fpi4 - &
         (1.01238124519548_pr*c3*gA2)/fpi4
    ctr0r0(2,1,31) = (0.00309105880474346_pr*c3*gA2)/fpi4
    ctr0r0(3,1,31) = (-0.0677310869715905_pr*c1*gA2)/fpi4 - &
         (0.0402347347174442_pr*c3*gA2)/fpi4
    ctr0r0(3,1,33) = (-0.000386382350592933_pr*c3*gA2)/fpi4
    !
    !  Urho1rho1
    !
    ctr1r1=0.0_pr
    ctr1r1(1,1,1) = (-0.964246762695464_pr*c3*gA2)/fpi4 - &
         (0.0263462308309038_pr*c4*gA2)/fpi4 - (0.1875_pr*ce)/(fpi4*LambdaX) + &
         (0.046875_pr*cd*ga)/(fpi4*LambdaX)
    ctr1r1(1,1,3) = (-6.84195361981036_pr*c1*gA2)/fpi4 + &
         (5.01410456224811_pr*c3*gA2)/fpi4 + (0.0732776804846939_pr*c4*gA2)/fpi4 &
         - (0.06328125_pr*cd*ga)/(fpi4*LambdaX)
    ctr1r1(2,1,3) = (0.147698198400372_pr*c3*gA2)/fpi4 + &
         (0.0703526785714286_pr*c4*gA2)/fpi4 - &
         (0.02109375_pr*cd*ga)/(fpi4*LambdaX)
    ctr1r1(1,2,4) = (-0.1875_pr*c3*gA2)/fpi4 - (0.375_pr*c4*gA2)/fpi4 + &
         (0.140625_pr*cd*ga)/(fpi4*LambdaX)
    ctr1r1(1,1,5) = (-23.1434396482781_pr*c1*gA2)/fpi4 + &
         (12.2465870768616_pr*c3*gA2)/fpi4 - (0.18795405731824_pr*c4*gA2)/fpi4 + &
         (0.017578125_pr*cd*ga)/(fpi4*LambdaX)
    ctr1r1(2,1,5) = (35.0618960855328_pr*c1*gA2)/fpi4 - &
         (16.8781682906031_pr*c3*gA2)/fpi4 + (0.0543163105867347_pr*c4*gA2)/fpi4 &
         - (0.06328125_pr*cd*ga)/(fpi4*LambdaX)
    ctr1r1(1,2,6) = (-325.455281192602_pr*c1*gA2)/fpi4 + &
         (83.7334611805583_pr*c3*gA2)/fpi4 + (1.3574300625_pr*c4*gA2)/fpi4
    ctr1r1(2,2,6) = (32.9911875098339_pr*c3*gA2)/fpi4 + &
         (0.16875_pr*c4*gA2)/fpi4
    ctr1r1(1,1,7) = (-5761.43588948783_pr*c1*gA2)/fpi4 - &
         (869.283572934387_pr*c3*gA2)/fpi4 - (13.4068326170281_pr*c4*gA2)/fpi4
    ctr1r1(2,1,7) = (2192.10779645869_pr*c1*gA2)/fpi4 + &
         (263.842952909344_pr*c3*gA2)/fpi4 + (3.99388560267857_pr*c4*gA2)/fpi4 - &
         (0.00439453125_pr*cd*ga)/(fpi4*LambdaX)
    ctr1r1(3,1,7) = (-198.153843790565_pr*c1*gA2)/fpi4 - &
         (58.742085950407_pr*c3*gA2)/fpi4 - (0.4904296875_pr*c4*gA2)/fpi4
    ctr1r1(1,3,7) = (-526.213527565944_pr*c3*gA2)/fpi4 - &
         (2.84068526785714_pr*c4*gA2)/fpi4
    ctr1r1(1,2,8) = (11194.2459766741_pr*c1*gA2)/fpi4 - &
         (901.889210563564_pr*c3*gA2)/fpi4 + (1.90516445471939_pr*c4*gA2)/fpi4
    ctr1r1(2,2,8) = (-751.043571428571_pr*c1*gA2)/fpi4 + &
         (1336.68785503856_pr*c3*gA2)/fpi4 + (4.15185267857143_pr*c4*gA2)/fpi4
    ctr1r1(1,1,9) = (-19577.5085802329_pr*c1*gA2)/fpi4 - &
         (20061.3662796935_pr*c3*gA2)/fpi4 - (402.203416845285_pr*c4*gA2)/fpi4
    ctr1r1(2,1,9) = (6927.60941249884_pr*c1*gA2)/fpi4 + &
         (10204.912096572_pr*c3*gA2)/fpi4 + (157.45919188058_pr*c4*gA2)/fpi4
    ctr1r1(3,1,9) = (-1688.44574624066_pr*c1*gA2)/fpi4 - &
         (1848.73711933536_pr*c3*gA2)/fpi4 - (17.251846749442_pr*c4*gA2)/fpi4
    ctr1r1(1,3,9) = (-14639.9109308036_pr*c1*gA2)/fpi4 - &
         (2073.4495546875_pr*c3*gA2)/fpi4 + (12.406921875_pr*c4*gA2)/fpi4
    ctr1r1(1,2,10) = (-6051.26397950415_pr*c1*gA2)/fpi4 + &
         (25318.5711035127_pr*c3*gA2)/fpi4 + (1111.77481741071_pr*c4*gA2)/fpi4
    ctr1r1(2,2,10) = (20263.462438058_pr*c1*gA2)/fpi4 - &
         (645.573171294818_pr*c3*gA2)/fpi4 - (220.10902734375_pr*c4*gA2)/fpi4
    ctr1r1(1,1,11) = (-117612.589511906_pr*c1*gA2)/fpi4 - &
         (22681.6420225835_pr*c3*gA2)/fpi4 + (1494.47871529855_pr*c4*gA2)/fpi4
    ctr1r1(2,1,11) = (78131.8227221231_pr*c1*gA2)/fpi4 + &
         (11306.3195229362_pr*c3*gA2)/fpi4 - (1044.42429449456_pr*c4*gA2)/fpi4
    ctr1r1(3,1,11) = (-19244.1407277278_pr*c1*gA2)/fpi4 - &
         (4031.58809797695_pr*c3*gA2)/fpi4 + (143.952209472656_pr*c4*gA2)/fpi4
    ctr1r1(1,3,11) = (-12782.365790625_pr*c1*gA2)/fpi4 - &
         (19898.5801884375_pr*c3*gA2)/fpi4 - (763.061715_pr*c4*gA2)/fpi4
    ctr1r1(1,2,12) = (112532.892207631_pr*c1*gA2)/fpi4 + &
         (2673.93101274094_pr*c3*gA2)/fpi4 - (3075.39951940848_pr*c4*gA2)/fpi4
    ctr1r1(2,2,12) = (-4174.98147321429_pr*c1*gA2)/fpi4 + &
         (16959.475747232_pr*c3*gA2)/fpi4 + (1249.48156138393_pr*c4*gA2)/fpi4
    ctr1r1(1,1,13) = (-62220.7516704385_pr*c1*gA2)/fpi4 - &
         (37645.4468013683_pr*c3*gA2)/fpi4 - (1458.88122707611_pr*c4*gA2)/fpi4
    ctr1r1(2,1,13) = (49392.5657264478_pr*c1*gA2)/fpi4 + &
         (35938.6848928339_pr*c3*gA2)/fpi4 + (1614.83538151428_pr*c4*gA2)/fpi4
    ctr1r1(3,1,13) = (-21590.8338635122_pr*c1*gA2)/fpi4 - &
         (12971.4689072793_pr*c3*gA2)/fpi4 - (402.76586151123_pr*c4*gA2)/fpi4
    ctr1r1(1,3,13) = (-66293.2611893973_pr*c1*gA2)/fpi4 - &
         (8811.70601861049_pr*c3*gA2)/fpi4 + (1385.87636601563_pr*c4*gA2)/fpi4
    ctr1r1(1,2,14) = (-8634.9144059954_pr*c1*gA2)/fpi4 + &
         (13584.0523217795_pr*c3*gA2)/fpi4 + (1941.14579905622_pr*c4*gA2)/fpi4
    ctr1r1(2,2,14) = (46092.3086405378_pr*c1*gA2)/fpi4 + &
         (6421.96926354563_pr*c3*gA2)/fpi4 - (1169.36919344657_pr*c4*gA2)/fpi4
    ctr1r1(1,1,15) = (-54823.1734859566_pr*c1*gA2)/fpi4 - &
         (21478.1701524643_pr*c3*gA2)/fpi4 + (30.6758968031093_pr*c4*gA2)/fpi4
    ctr1r1(2,1,15) = (79796.8451847046_pr*c1*gA2)/fpi4 + &
         (29550.3190922257_pr*c3*gA2)/fpi4 - (265.149560200718_pr*c4*gA2)/fpi4
    ctr1r1(3,1,15) = (-34549.4910141965_pr*c1*gA2)/fpi4 - &
         (12487.0361763301_pr*c3*gA2)/fpi4 + (129.866342965262_pr*c4*gA2)/fpi4
    ctr1r1(1,3,15) = (-6841.585265625_pr*c1*gA2)/fpi4 - &
         (8394.50421527972_pr*c3*gA2)/fpi4 - (637.487162214007_pr*c4*gA2)/fpi4
    ctr1r1(1,2,16) = (-966.144667675781_pr*c1*gA2)/fpi4 - &
         (1635.80437776282_pr*c3*gA2)/fpi4 - (20.2837476928711_pr*c4*gA2)/fpi4
    ctr1r1(2,2,16) = (10019.4643315377_pr*c1*gA2)/fpi4 + &
         (5806.54125301064_pr*c3*gA2)/fpi4 + (162.342586296387_pr*c4*gA2)/fpi4
    ctr1r1(1,1,17) = (-27328.2660786696_pr*c1*gA2)/fpi4 - &
         (11536.8965413_pr*c3*gA2)/fpi4 - (0.153939957765852_pr*c4*gA2)/fpi4
    ctr1r1(2,1,17) = (51084.8335772702_pr*c1*gA2)/fpi4 + &
         (21317.5006264206_pr*c3*gA2)/fpi4 - (5.04213459735325_pr*c4*gA2)/fpi4
    ctr1r1(3,1,17) = (-23176.714608858_pr*c1*gA2)/fpi4 - &
         (9591.77377013768_pr*c3*gA2)/fpi4 - (7.01374572372437_pr*c4*gA2)/fpi4
    ctr1r1(1,3,17) = (-839.926762520926_pr*c1*gA2)/fpi4
    ctr1r1(1,2,18) = (-71.6191333138602_pr*c1*gA2)/fpi4 - &
         (29.5562121168625_pr*c3*gA2)/fpi4
    ctr1r1(2,2,18) = (1117.2724960968_pr*c1*gA2)/fpi4 + &
         (423.729200499137_pr*c3*gA2)/fpi4 + (5.07093692321777_pr*c4*gA2)/fpi4
    ctr1r1(1,1,19) = (-9253.22855094582_pr*c1*gA2)/fpi4 - &
         (4005.49423137719_pr*c3*gA2)/fpi4
    ctr1r1(2,1,19) = (21870.1711895189_pr*c1*gA2)/fpi4 + &
         (9310.62118848288_pr*c3*gA2)/fpi4 + (0.0769699788829259_pr*c4*gA2)/fpi4
    ctr1r1(3,1,19) = (-11369.3247545611_pr*c1*gA2)/fpi4 - &
         (4767.97117814042_pr*c3*gA2)/fpi4 - (0.656709900856018_pr*c4*gA2)/fpi4
    ctr1r1(2,2,20) = (17.9047833284651_pr*c1*gA2)/fpi4 + &
         (7.38905302921563_pr*c3*gA2)/fpi4
    ctr1r1(1,1,21) = (-2139.34177995088_pr*c1*gA2)/fpi4 - &
         (951.965547431256_pr*c3*gA2)/fpi4
    ctr1r1(2,1,21) = (6585.92097742191_pr*c1*gA2)/fpi4 + &
         (2872.41393631472_pr*c3*gA2)/fpi4
    ctr1r1(3,1,21) = (-4206.97567815619_pr*c1*gA2)/fpi4 - &
         (1804.69962149452_pr*c3*gA2)/fpi4 - &
         (0.00962124736036573_pr*c4*gA2)/fpi4
    ctr1r1(1,1,23) = (-320.600347402137_pr*c1*gA2)/fpi4 - &
         (147.828203709359_pr*c3*gA2)/fpi4
    ctr1r1(2,1,23) = (1373.03667928303_pr*c1*gA2)/fpi4 + &
         (615.472966679238_pr*c3*gA2)/fpi4
    ctr1r1(3,1,23) = (-1139.80667854591_pr*c1*gA2)/fpi4 - &
         (500.614173373695_pr*c3*gA2)/fpi4
    ctr1r1(1,1,25) = (-28.0192319249075_pr*c1*gA2)/fpi4 - &
         (13.7137479594838_pr*c3*gA2)/fpi4
    ctr1r1(2,1,25) = (187.596940698279_pr*c1*gA2)/fpi4 + &
         (87.2234077809484_pr*c3*gA2)/fpi4
    ctr1r1(3,1,25) = (-216.193884091206_pr*c1*gA2)/fpi4 - &
         (97.5972978305762_pr*c3*gA2)/fpi4
    ctr1r1(1,1,27) = (-1.08369739154545_pr*c1*gA2)/fpi4 - &
         (0.619027285041159_pr*c3*gA2)/fpi4
    ctr1r1(2,1,27) = (15.0933133539992_pr*c1*gA2)/fpi4 + &
         (7.47177985304339_pr*c3*gA2)/fpi4
    ctr1r1(3,1,27) = (-27.1326378098226_pr*c1*gA2)/fpi4 - &
         (12.7192853287926_pr*c3*gA2)/fpi4
    ctr1r1(1,1,29) = (-0.00618211760948692_pr*c3*gA2)/fpi4
    ctr1r1(2,1,29) = (0.541848695772724_pr*c1*gA2)/fpi4 + &
         (0.315695760130066_pr*c3*gA2)/fpi4
    ctr1r1(3,1,29) = (-2.02212634319308_pr*c1*gA2)/fpi4 - &
         (1.01238124519548_pr*c3*gA2)/fpi4
    ctr1r1(2,1,31) = (0.00309105880474346_pr*c3*gA2)/fpi4
    ctr1r1(3,1,31) = (-0.0677310869715905_pr*c1*gA2)/fpi4 - &
         (0.0402347347174442_pr*c3*gA2)/fpi4
    ctr1r1(3,1,33) = (-0.000386382350592933_pr*c3*gA2)/fpi4
    !
    !  UDrho0Drho0
    !
    ctdr0dr0=0.0_pr
    !
    !  UDrho1Drho1
    !
    ctdr1dr1=0.0_pr
    !
    !  Urho0DDrho0
    !
    ctr0Dr0=0.0_pr
    ctr0Dr0(1,1,3) = (-0.682809650873706_pr*c3*gA2)/(fpi4*mpi2) + &
         (0.0239679050048591_pr*c4*gA2)/(fpi4*mpi2)
    ctr0Dr0(1,1,5) = (-5.25041224998774_pr*c1*gA2)/(fpi4*mpi2) + &
         (3.77245681259736_pr*c3*gA2)/(fpi4*mpi2) - &
         (0.166505020727041_pr*c4*gA2)/(fpi4*mpi2) + &
         (0.03515625_pr*cd*ga)/(fpi4*mpi2*LambdaX)
    ctr0Dr0(2,1,5) = (0.12308183200031_pr*c3*gA2)/(fpi4*mpi2) + &
         (0.0586272321428571_pr*c4*gA2)/(fpi4*mpi2) - &
         (0.017578125_pr*cd*ga)/(fpi4*mpi2*LambdaX)
    ctr0Dr0(1,1,7) = (-26.0336741183036_pr*c1*gA2)/(fpi4*mpi2) + &
         (12.9213033479161_pr*c3*gA2)/(fpi4*mpi2) + &
         (0.0724766691246811_pr*c4*gA2)/(fpi4*mpi2)
    ctr0Dr0(2,1,7) = (29.218246737944_pr*c1*gA2)/(fpi4*mpi2) - &
         (13.9991785771689_pr*c3*gA2)/(fpi4*mpi2) - &
         (0.0572336176658163_pr*c4*gA2)/(fpi4*mpi2) - &
         (0.0087890625_pr*cd*ga)/(fpi4*mpi2*LambdaX)
    ctr0Dr0(1,2,8) = (-252.855350558036_pr*c1*gA2)/(fpi4*mpi2) + &
         (56.1626339963032_pr*c3*gA2)/(fpi4*mpi2) + &
         (0.49978546875_pr*c4*gA2)/(fpi4*mpi2)
    ctr0Dr0(2,2,8) = (27.4926562581949_pr*c3*gA2)/(fpi4*mpi2) + &
         (0.140625_pr*c4*gA2)/(fpi4*mpi2)
    ctr0Dr0(1,1,9) = (-4737.41799564353_pr*c1*gA2)/(fpi4*mpi2) - &
         (732.936270957556_pr*c3*gA2)/(fpi4*mpi2) - &
         (10.8826855699936_pr*c4*gA2)/(fpi4*mpi2)
    ctr0Dr0(2,1,9) = (1812.39349332203_pr*c1*gA2)/(fpi4*mpi2) + &
         (230.621448631588_pr*c3*gA2)/(fpi4*mpi2) + &
         (3.48044224330357_pr*c4*gA2)/(fpi4*mpi2)
    ctr0Dr0(3,1,9) = (-165.128203158804_pr*c1*gA2)/(fpi4*mpi2) - &
         (48.9517382920058_pr*c3*gA2)/(fpi4*mpi2) - &
         (0.40869140625_pr*c4*gA2)/(fpi4*mpi2)
    ctr0Dr0(1,3,9) = (-412.495287388393_pr*c3*gA2)/(fpi4*mpi2) - &
         (1.89848772321429_pr*c4*gA2)/(fpi4*mpi2)
    ctr0Dr0(1,2,10) = (8987.88523861607_pr*c1*gA2)/(fpi4*mpi2) - &
         (631.430929909134_pr*c3*gA2)/(fpi4*mpi2) + &
         (1.32764820631378_pr*c4*gA2)/(fpi4*mpi2)
    ctr0Dr0(2,2,10) = (-625.869642857143_pr*c1*gA2)/(fpi4*mpi2) + &
         (1045.17490521998_pr*c3*gA2)/(fpi4*mpi2) + &
         (3.10831473214286_pr*c4*gA2)/(fpi4*mpi2)
    ctr0Dr0(1,1,11) = (-17022.0529432446_pr*c1*gA2)/(fpi4*mpi2) - &
         (15425.6442847704_pr*c3*gA2)/(fpi4*mpi2) - &
         (325.368422118792_pr*c4*gA2)/(fpi4*mpi2)
    ctr0Dr0(2,1,11) = (6144.54246637738_pr*c1*gA2)/(fpi4*mpi2) + &
         (7927.36933047731_pr*c3*gA2)/(fpi4*mpi2) + &
         (127.556172677176_pr*c4*gA2)/(fpi4*mpi2)
    ctr0Dr0(3,1,11) = (-1407.03812186722_pr*c1*gA2)/(fpi4*mpi2) - &
         (1455.27334812581_pr*c3*gA2)/(fpi4*mpi2) - &
         (13.9398324148996_pr*c4*gA2)/(fpi4*mpi2)
    ctr0Dr0(1,3,11) = (-11514.015703125_pr*c1*gA2)/(fpi4*mpi2) - &
         (1727.87462890625_pr*c3*gA2)/(fpi4*mpi2) + &
         (10.3391015625_pr*c4*gA2)/(fpi4*mpi2)
    ctr0Dr0(1,2,12) = (-694.446624441964_pr*c1*gA2)/(fpi4*mpi2) + &
         (18247.3109917788_pr*c3*gA2)/(fpi4*mpi2) + &
         (899.399912946429_pr*c4*gA2)/(fpi4*mpi2)
    ctr0Dr0(2,2,12) = (15092.8155175781_pr*c1*gA2)/(fpi4*mpi2) - &
         (116.351373250285_pr*c3*gA2)/(fpi4*mpi2) - &
         (178.470087890625_pr*c4*gA2)/(fpi4*mpi2)
    ctr0Dr0(1,1,13) = (-84816.595261174_pr*c1*gA2)/(fpi4*mpi2) - &
         (21005.6538813155_pr*c3*gA2)/(fpi4*mpi2) + &
         (1207.97363186907_pr*c4*gA2)/(fpi4*mpi2)
    ctr0Dr0(2,1,13) = (56932.8731897877_pr*c1*gA2)/(fpi4*mpi2) + &
         (11075.3299701944_pr*c3*gA2)/(fpi4*mpi2) - &
         (844.741128183943_pr*c4*gA2)/(fpi4*mpi2)
    ctr0Dr0(3,1,13) = (-14559.3117129491_pr*c1*gA2)/(fpi4*mpi2) - &
         (3504.49103169193_pr*c3*gA2)/(fpi4*mpi2) + &
         (116.596984863281_pr*c4*gA2)/(fpi4*mpi2)
    ctr0Dr0(1,3,13) = (-12860.985515625_pr*c1*gA2)/(fpi4*mpi2) - &
         (14398.998496875_pr*c3*gA2)/(fpi4*mpi2) - &
         (616.763278125_pr*c4*gA2)/(fpi4*mpi2)
    ctr0Dr0(1,2,14) = (71603.420010498_pr*c1*gA2)/(fpi4*mpi2) + &
         (8297.07769839308_pr*c3*gA2)/(fpi4*mpi2) - &
         (2483.1196515904_pr*c4*gA2)/(fpi4*mpi2)
    ctr0Dr0(2,2,14) = (2438.09865025112_pr*c1*gA2)/(fpi4*mpi2) + &
         (10960.7457584461_pr*c3*gA2)/(fpi4*mpi2) + &
         (1009.19850167411_pr*c4*gA2)/(fpi4*mpi2)
    ctr0Dr0(1,1,15) = (-55860.3376653923_pr*c1*gA2)/(fpi4*mpi2) - &
         (25835.4946732797_pr*c3*gA2)/(fpi4*mpi2) - &
         (1174.87146717911_pr*c4*gA2)/(fpi4*mpi2)
    ctr0Dr0(2,1,15) = (47592.1515045526_pr*c1*gA2)/(fpi4*mpi2) + &
         (24786.4294824231_pr*c3*gA2)/(fpi4*mpi2) + &
         (1301.50458021698_pr*c4*gA2)/(fpi4*mpi2)
    ctr0Dr0(3,1,15) = (-19018.8059498995_pr*c1*gA2)/(fpi4*mpi2) - &
         (9429.01449770894_pr*c3*gA2)/(fpi4*mpi2) - &
         (324.792194366455_pr*c4*gA2)/(fpi4*mpi2)
    ctr0Dr0(1,3,15) = (-44074.7843378906_pr*c1*gA2)/(fpi4*mpi2) - &
         (9754.29660498047_pr*c3*gA2)/(fpi4*mpi2) + &
         (1118.35204980469_pr*c4*gA2)/(fpi4*mpi2)
    ctr0Dr0(1,2,16) = (1466.81527313232_pr*c1*gA2)/(fpi4*mpi2) + &
         (4924.95415195852_pr*c3*gA2)/(fpi4*mpi2) + &
         (1563.11953388149_pr*c4*gA2)/(fpi4*mpi2)
    ctr0Dr0(2,2,16) = (29864.464335022_pr*c1*gA2)/(fpi4*mpi2) + &
         (7829.64002841679_pr*c3*gA2)/(fpi4*mpi2) - &
         (942.380516836984_pr*c4*gA2)/(fpi4*mpi2)
    ctr0Dr0(1,1,17) = (-42578.4126891706_pr*c1*gA2)/(fpi4*mpi2) - &
         (17202.0887780327_pr*c3*gA2)/(fpi4*mpi2) + &
         (24.7012874970572_pr*c4*gA2)/(fpi4*mpi2)
    ctr0Dr0(2,1,17) = (61948.0344894364_pr*c1*gA2)/(fpi4*mpi2) + &
         (24461.7278379897_pr*c3*gA2)/(fpi4*mpi2) - &
         (213.463917761666_pr*c4*gA2)/(fpi4*mpi2)
    ctr0Dr0(3,1,17) = (-26551.291288457_pr*c1*gA2)/(fpi4*mpi2) - &
         (10248.0190226489_pr*c3*gA2)/(fpi4*mpi2) + &
         (104.612325701032_pr*c4*gA2)/(fpi4*mpi2)
    ctr0Dr0(1,3,17) = (-7839.31645019531_pr*c1*gA2)/(fpi4*mpi2) - &
         (4409.58359893799_pr*c3*gA2)/(fpi4*mpi2) - &
         (513.293134852818_pr*c4*gA2)/(fpi4*mpi2)
    ctr0Dr0(1,2,18) = (-2406.80499142456_pr*c1*gA2)/(fpi4*mpi2) - &
         (982.897425834421_pr*c3*gA2)/(fpi4*mpi2) - &
         (16.3321086730957_pr*c4*gA2)/(fpi4*mpi2)
    ctr0Dr0(2,2,18) = (8676.01512762451_pr*c1*gA2)/(fpi4*mpi2) + &
         (3669.79377386557_pr*c3*gA2)/(fpi4*mpi2) + &
         (130.679305718994_pr*c4*gA2)/(fpi4*mpi2)
    ctr0Dr0(1,1,19) = (-21929.7613258823_pr*c1*gA2)/(fpi4*mpi2) - &
         (9003.06173155003_pr*c3*gA2)/(fpi4*mpi2) - &
         (0.123949706677028_pr*c4*gA2)/(fpi4*mpi2)
    ctr0Dr0(2,1,19) = (41084.26511068_pr*c1*gA2)/(fpi4*mpi2) + &
         (16712.9487662382_pr*c3*gA2)/(fpi4*mpi2) - &
         (4.06063970530374_pr*c4*gA2)/(fpi4*mpi2)
    ctr0Dr0(3,1,19) = (-18477.8744897258_pr*c1*gA2)/(fpi4*mpi2) - &
         (7453.07953912234_pr*c3*gA2)/(fpi4*mpi2) - &
         (5.64185216903687_pr*c4*gA2)/(fpi4*mpi2)
    ctr0Dr0(2,2,20) = (601.70124785614_pr*c1*gA2)/(fpi4*mpi2) + &
         (245.724356458605_pr*c3*gA2)/(fpi4*mpi2) + &
         (4.08302716827393_pr*c4*gA2)/(fpi4*mpi2)
    ctr0Dr0(1,1,21) = (-7429.54966559941_pr*c1*gA2)/(fpi4*mpi2) - &
         (3087.22338867281_pr*c3*gA2)/(fpi4*mpi2)
    ctr0Dr0(2,1,21) = (17522.7958314409_pr*c1*gA2)/(fpi4*mpi2) + &
         (7223.97599005467_pr*c3*gA2)/(fpi4*mpi2) + &
         (0.0619748533385141_pr*c4*gA2)/(fpi4*mpi2)
    ctr0Dr0(3,1,21) = (-9051.54263718816_pr*c1*gA2)/(fpi4*mpi2) - &
         (3700.96455501676_pr*c3*gA2)/(fpi4*mpi2) - &
         (0.528670542240143_pr*c4*gA2)/(fpi4*mpi2)
    ctr0Dr0(1,1,23) = (-1722.74624112667_pr*c1*gA2)/(fpi4*mpi2) - &
         (722.002478964633_pr*c3*gA2)/(fpi4*mpi2)
    ctr0Dr0(2,1,23) = (5292.28471362693_pr*c1*gA2)/(fpi4*mpi2) + &
         (2204.46546742604_pr*c3*gA2)/(fpi4*mpi2)
    ctr0Dr0(3,1,23) = (-3370.28377443923_pr*c1*gA2)/(fpi4*mpi2) - &
         (1394.125888934_pr*c3*gA2)/(fpi4*mpi2) - &
         (0.00774685666731426_pr*c4*gA2)/(fpi4*mpi2)
    ctr0Dr0(1,1,25) = (-258.704980303594_pr*c1*gA2)/(fpi4*mpi2) - &
         (108.950617217712_pr*c3*gA2)/(fpi4*mpi2)
    ctr0Dr0(2,1,25) = (1106.14939761973_pr*c1*gA2)/(fpi4*mpi2) + &
         (464.078201799952_pr*c3*gA2)/(fpi4*mpi2)
    ctr0Dr0(3,1,25) = (-916.533683372315_pr*c1*gA2)/(fpi4*mpi2) - &
         (382.506711741246_pr*c3*gA2)/(fpi4*mpi2)
    ctr0Dr0(1,1,27) = (-22.6474359092818_pr*c1*gA2)/(fpi4*mpi2) - &
         (9.54811915326822_pr*c3*gA2)/(fpi4*mpi2)
    ctr0Dr0(2,1,27) = (151.415132381586_pr*c1*gA2)/(fpi4*mpi2) + &
         (63.7775488277401_pr*c3*gA2)/(fpi4*mpi2)
    ctr0Dr0(3,1,27) = (-174.235171472089_pr*c1*gA2)/(fpi4*mpi2) - &
         (73.1584858358234_pr*c3*gA2)/(fpi4*mpi2)
    ctr0Dr0(1,1,29) = (-0.877190519238951_pr*c1*gA2)/(fpi4*mpi2) - &
         (0.368818401576571_pr*c3*gA2)/(fpi4*mpi2)
    ctr0Dr0(2,1,29) = (12.2009084738798_pr*c1*gA2)/(fpi4*mpi2) + &
         (5.14287797821068_pr*c3*gA2)/(fpi4*mpi2)
    ctr0Dr0(3,1,29) = (-21.9040194562317_pr*c1*gA2)/(fpi4*mpi2) - &
         (9.22717823122213_pr*c3*gA2)/(fpi4*mpi2)
    ctr0Dr0(2,1,31) = (0.438595259619476_pr*c1*gA2)/(fpi4*mpi2) + &
         (0.184409200788286_pr*c3*gA2)/(fpi4*mpi2)
    ctr0Dr0(3,1,31) = (-1.63476237413985_pr*c1*gA2)/(fpi4*mpi2) - &
         (0.688962047473406_pr*c3*gA2)/(fpi4*mpi2)
    ctr0Dr0(3,1,33) = (-0.0548244074524344_pr*c1*gA2)/(fpi4*mpi2) - &
         (0.0230511500985357_pr*c3*gA2)/(fpi4*mpi2)
    !
    !  Urho1DDrho0
    !
    ctr1Dr0=0.0_pr
    ctr1Dr0(1,1,3) = (0.0185237085762877_pr*c3*gA2)/(fpi4*mpi2) - &
         (0.00798930166828636_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr0(1,1,5) = (0.0956155117984694_pr*c1*gA2)/(fpi4*mpi2) - &
         (0.0234414046556122_pr*c3*gA2)/(fpi4*mpi2) + &
         (0.0555016735756803_pr*c4*gA2)/(fpi4*mpi2) - &
         (0.01171875_pr*cd*ga)/(fpi4*mpi2*LambdaX)
    ctr1Dr0(2,1,5) = (-0.00389508928571429_pr*c3*gA2)/(fpi4*mpi2) - &
         (0.0195424107142857_pr*c4*gA2)/(fpi4*mpi2) + &
         (0.005859375_pr*cd*ga)/(fpi4*mpi2*LambdaX)
    ctr1Dr0(1,1,7) = (-0.382716029575893_pr*c1*gA2)/(fpi4*mpi2) + &
         (0.159635060586735_pr*c3*gA2)/(fpi4*mpi2) - &
         (0.024158889708227_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr0(2,1,7) = (-0.0256136798469388_pr*c1*gA2)/(fpi4*mpi2) + &
         (0.00456883769132653_pr*c3*gA2)/(fpi4*mpi2) + &
         (0.0190778725552721_pr*c4*gA2)/(fpi4*mpi2) + &
         (0.0029296875_pr*cd*ga)/(fpi4*mpi2*LambdaX)
    ctr1Dr0(1,2,8) = (0.706878683035714_pr*c1*gA2)/(fpi4*mpi2) - &
         (0.423425189732143_pr*c3*gA2)/(fpi4*mpi2) - &
         (0.16659515625_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr0(2,2,8) = (-0.0234375_pr*c3*gA2)/(fpi4*mpi2) - &
         (0.046875_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr0(1,1,9) = (11.4067307059152_pr*c1*gA2)/(fpi4*mpi2) + &
         (0.609889416055485_pr*c3*gA2)/(fpi4*mpi2) + &
         (3.62756185666454_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr0(2,1,9) = (-3.54638253348214_pr*c1*gA2)/(fpi4*mpi2) - &
         (0.0995982142857143_pr*c3*gA2)/(fpi4*mpi2) - &
         (1.16014741443452_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr0(3,1,9) = (0.25048828125_pr*c1*gA2)/(fpi4*mpi2) + &
         (0.04833984375_pr*c3*gA2)/(fpi4*mpi2) + &
         (0.13623046875_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr0(1,3,9) = (0.949243861607143_pr*c3*gA2)/(fpi4*mpi2) + &
         (0.632829241071429_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr0(1,2,10) = (-22.8885294642857_pr*c1*gA2)/(fpi4*mpi2) + &
         (18.9939639150191_pr*c3*gA2)/(fpi4*mpi2) - &
         (0.442549402104592_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr0(2,2,10) = (2.53108258928571_pr*c1*gA2)/(fpi4*mpi2) - &
         (4.85298549107143_pr*c3*gA2)/(fpi4*mpi2) - &
         (1.03610491071429_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr0(1,1,11) = (220.437076035854_pr*c1*gA2)/(fpi4*mpi2) + &
         (298.906979832589_pr*c3*gA2)/(fpi4*mpi2) + &
         (108.456140706264_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr0(2,1,11) = (-68.8102811802455_pr*c1*gA2)/(fpi4*mpi2) - &
         (121.491437360491_pr*c3*gA2)/(fpi4*mpi2) - &
         (42.5187242257254_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr0(3,1,11) = (6.13759068080357_pr*c1*gA2)/(fpi4*mpi2) + &
         (12.8441554478237_pr*c3*gA2)/(fpi4*mpi2) + &
         (4.64661080496652_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr0(1,3,11) = (11.318203125_pr*c1*gA2)/(fpi4*mpi2) - &
         (23.38048828125_pr*c3*gA2)/(fpi4*mpi2) - &
         (3.4463671875_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr0(1,2,12) = (-732.624496372768_pr*c1*gA2)/(fpi4*mpi2) - &
         (842.4480234375_pr*c3*gA2)/(fpi4*mpi2) - &
         (299.799970982143_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr0(2,2,12) = (117.953701171875_pr*c1*gA2)/(fpi4*mpi2) + &
         (175.760551757812_pr*c3*gA2)/(fpi4*mpi2) + &
         (59.490029296875_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr0(1,1,13) = (-1470.77295530744_pr*c1*gA2)/(fpi4*mpi2) - &
         (1177.66729674159_pr*c3*gA2)/(fpi4*mpi2) - &
         (402.65787728969_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr0(2,1,13) = (906.809157364328_pr*c1*gA2)/(fpi4*mpi2) + &
         (809.938923974958_pr*c3*gA2)/(fpi4*mpi2) + &
         (281.580376061314_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr0(3,1,13) = (-110.580871582031_pr*c1*gA2)/(fpi4*mpi2) - &
         (112.623596191406_pr*c3*gA2)/(fpi4*mpi2) - &
         (38.8656616210938_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr0(1,3,13) = (585.845296875_pr*c1*gA2)/(fpi4*mpi2) + &
         (588.08008125_pr*c3*gA2)/(fpi4*mpi2) + &
         (205.587759375_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr0(1,2,14) = (3251.26034692383_pr*c1*gA2)/(fpi4*mpi2) + &
         (2508.40495063477_pr*c3*gA2)/(fpi4*mpi2) + &
         (827.706550530134_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr0(2,2,14) = (-1184.58378557478_pr*c1*gA2)/(fpi4*mpi2) - &
         (995.956718052455_pr*c3*gA2)/(fpi4*mpi2) - &
         (336.399500558036_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr0(1,1,15) = (1877.99099063873_pr*c1*gA2)/(fpi4*mpi2) + &
         (1378.17489546073_pr*c3*gA2)/(fpi4*mpi2) + &
         (391.623822393036_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr0(2,1,15) = (-1930.62984776132_pr*c1*gA2)/(fpi4*mpi2) - &
         (1432.9768855957_pr*c3*gA2)/(fpi4*mpi2) - &
         (433.834860072327_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr0(3,1,15) = (440.209643554687_pr*c1*gA2)/(fpi4*mpi2) + &
         (341.656391143799_pr*c3*gA2)/(fpi4*mpi2) + &
         (108.264064788818_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr0(1,3,15) = (-1549.60388085937_pr*c1*gA2)/(fpi4*mpi2) - &
         (1159.75179052734_pr*c3*gA2)/(fpi4*mpi2) - &
         (372.784016601562_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr0(1,2,16) = (-2582.26988983154_pr*c1*gA2)/(fpi4*mpi2) - &
         (1875.22398799962_pr*c3*gA2)/(fpi4*mpi2) - &
         (521.039844627162_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr0(2,2,16) = (1459.93622772217_pr*c1*gA2)/(fpi4*mpi2) + &
         (1058.4680922808_pr*c3*gA2)/(fpi4*mpi2) + &
         (314.126838945661_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr0(1,1,17) = (-56.9118636474609_pr*c1*gA2)/(fpi4*mpi2) - &
         (35.9791338062831_pr*c3*gA2)/(fpi4*mpi2) - &
         (8.23376249901908_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr0(2,1,17) = (396.575549217224_pr*c1*gA2)/(fpi4*mpi2) + &
         (276.498193133763_pr*c3*gA2)/(fpi4*mpi2) + &
         (71.1546392538888_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr0(3,1,17) = (-182.383999263218_pr*c1*gA2)/(fpi4*mpi2) - &
         (125.990329873221_pr*c3*gA2)/(fpi4*mpi2) - &
         (34.8707752336775_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr0(1,3,17) = (871.035161132812_pr*c1*gA2)/(fpi4*mpi2) + &
         (629.940514133998_pr*c3*gA2)/(fpi4*mpi2) + &
         (171.097711617606_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr0(1,2,18) = (38.1077882995605_pr*c1*gA2)/(fpi4*mpi2) + &
         (24.4976645050049_pr*c3*gA2)/(fpi4*mpi2) + &
         (5.44403622436523_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr0(2,2,18) = (-244.521582824707_pr*c1*gA2)/(fpi4*mpi2) - &
         (173.383349386597_pr*c3*gA2)/(fpi4*mpi2) - &
         (43.559768572998_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr0(1,1,19) = (0.340248109817505_pr*c1*gA2)/(fpi4*mpi2) + &
         (0.240601839556013_pr*c3*gA2)/(fpi4*mpi2) + &
         (0.0413165688923427_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr0(2,1,19) = (9.06178956413269_pr*c1*gA2)/(fpi4*mpi2) + &
         (5.50013281108311_pr*c3*gA2)/(fpi4*mpi2) + &
         (1.35354656843458_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr0(3,1,19) = (10.8524751663208_pr*c1*gA2)/(fpi4*mpi2) + &
         (8.40921586990356_pr*c3*gA2)/(fpi4*mpi2) + &
         (1.88061738967896_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr0(2,2,20) = (-9.52694707489014_pr*c1*gA2)/(fpi4*mpi2) - &
         (6.12441612625122_pr*c3*gA2)/(fpi4*mpi2) - &
         (1.36100905609131_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr0(2,1,21) = (-0.170124054908752_pr*c1*gA2)/(fpi4*mpi2) - &
         (0.120300919778006_pr*c3*gA2)/(fpi4*mpi2) - &
         (0.0206582844461714_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr0(3,1,21) = (1.29154408693314_pr*c1*gA2)/(fpi4*mpi2) + &
         (0.873662660121918_pr*c3*gA2)/(fpi4*mpi2) + &
         (0.176223514080048_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr0(3,1,23) = (0.0212655068635941_pr*c1*gA2)/(fpi4*mpi2) + &
         (0.0150376149722508_pr*c3*gA2)/(fpi4*mpi2) + &
         (0.00258228555577142_pr*c4*gA2)/(fpi4*mpi2)
    !
    !  Urho1DDrho1
    !
    ctr1Dr1=0.0_pr
    ctr1Dr1(1,1,3) = (0.225058111718187_pr*c3*gA2)/(fpi4*mpi2) - &
         (0.0159786033365727_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr1(1,1,5) = (1.76926855346105_pr*c1*gA2)/(fpi4*mpi2) - &
         (1.25129754669487_pr*c3*gA2)/(fpi4*mpi2) + &
         (0.111003347151361_pr*c4*gA2)/(fpi4*mpi2) - &
         (0.0234375_pr*cd*ga)/(fpi4*mpi2*LambdaX)
    ctr1Dr1(2,1,5) = (-0.0449223666191509_pr*c3*gA2)/(fpi4*mpi2) - &
         (0.0390848214285714_pr*c4*gA2)/(fpi4*mpi2) + &
         (0.01171875_pr*cd*ga)/(fpi4*mpi2*LambdaX)
    ctr1Dr1(1,1,7) = (8.62173784319196_pr*c1*gA2)/(fpi4*mpi2) - &
         (4.30128936533428_pr*c3*gA2)/(fpi4*mpi2) - &
         (0.0483177794164541_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr1(2,1,7) = (-9.7579980091616_pr*c1*gA2)/(fpi4*mpi2) + &
         (4.67405890125441_pr*c3*gA2)/(fpi4*mpi2) + &
         (0.0381557451105442_pr*c4*gA2)/(fpi4*mpi2) + &
         (0.005859375_pr*cd*ga)/(fpi4*mpi2*LambdaX)
    ctr1Dr1(1,2,8) = (84.4669955357143_pr*c1*gA2)/(fpi4*mpi2) - &
         (18.660361268857_pr*c3*gA2)/(fpi4*mpi2) - &
         (0.3331903125_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr1(2,2,8) = (-9.18765625273164_pr*c3*gA2)/(fpi4*mpi2) - &
         (0.09375_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr1(1,1,9) = (1573.18444149334_pr*c1*gA2)/(fpi4*mpi2) + &
         (246.450668847167_pr*c3*gA2)/(fpi4*mpi2) + &
         (7.25512371332908_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr1(2,1,9) = (-602.738093849159_pr*c1*gA2)/(fpi4*mpi2) - &
         (77.5124918057675_pr*c3*gA2)/(fpi4*mpi2) - &
         (2.32029482886905_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr1(3,1,9) = (54.959238292518_pr*c1*gA2)/(fpi4*mpi2) + &
         (16.3655859410853_pr*c3*gA2)/(fpi4*mpi2) + &
         (0.2724609375_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr1(1,3,9) = (137.182014508929_pr*c3*gA2)/(fpi4*mpi2) + &
         (1.26565848214286_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr1(1,2,10) = (-2950.89558816964_pr*c1*gA2)/(fpi4*mpi2) + &
         (192.771436581372_pr*c3*gA2)/(fpi4*mpi2) - &
         (0.885098804209184_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr1(2,2,10) = (202.294921875_pr*c1*gA2)/(fpi4*mpi2) - &
         (345.017723242968_pr*c3*gA2)/(fpi4*mpi2) - &
         (2.07220982142857_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr1(1,1,11) = (6073.45819058092_pr*c1*gA2)/(fpi4*mpi2) + &
         (4996.23922290246_pr*c3*gA2)/(fpi4*mpi2) + &
         (216.912281412528_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr1(2,1,11) = (-2212.39051736854_pr*c1*gA2)/(fpi4*mpi2) - &
         (2578.84096274467_pr*c3*gA2)/(fpi4*mpi2) - &
         (85.0374484514509_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr1(3,1,11) = (484.396391719877_pr*c1*gA2)/(fpi4*mpi2) + &
         (478.331459408286_pr*c3*gA2)/(fpi4*mpi2) + &
         (9.29322160993304_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr1(1,3,11) = (3776.4796875_pr*c1*gA2)/(fpi4*mpi2) + &
         (595.892330729167_pr*c3*gA2)/(fpi4*mpi2) - &
         (6.892734375_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr1(1,2,12) = (-1047.22431947545_pr*c1*gA2)/(fpi4*mpi2) - &
         (5677.84872382209_pr*c3*gA2)/(fpi4*mpi2) - &
         (599.599941964286_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr1(2,2,12) = (-4730.6293359375_pr*c1*gA2)/(fpi4*mpi2) - &
         (56.7874345025092_pr*c3*gA2)/(fpi4*mpi2) + &
         (118.98005859375_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr1(1,1,13) = (26158.9112133749_pr*c1*gA2)/(fpi4*mpi2) + &
         (7519.86242027358_pr*c3*gA2)/(fpi4*mpi2) - &
         (805.315754579381_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr1(2,1,13) = (-17547.6432543683_pr*c1*gA2)/(fpi4*mpi2) - &
         (4066.12243819318_pr*c3*gA2)/(fpi4*mpi2) + &
         (563.160752122628_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr1(3,1,13) = (4641.24227101558_pr*c1*gA2)/(fpi4*mpi2) + &
         (1225.12479783611_pr*c3*gA2)/(fpi4*mpi2) - &
         (77.7313232421875_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr1(1,3,13) = (5176.02796875_pr*c1*gA2)/(fpi4*mpi2) + &
         (4535.422284375_pr*c3*gA2)/(fpi4*mpi2) + &
         (411.17551875_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr1(1,2,14) = (-19673.8226904297_pr*c1*gA2)/(fpi4*mpi2) - &
         (3790.5753035822_pr*c3*gA2)/(fpi4*mpi2) + &
         (1655.41310106027_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr1(2,2,14) = (-2415.02747628348_pr*c1*gA2)/(fpi4*mpi2) - &
         (3234.1744717979_pr*c3*gA2)/(fpi4*mpi2) - &
         (672.799001116071_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr1(1,1,15) = (20527.2675777519_pr*c1*gA2)/(fpi4*mpi2) + &
         (8144.9046506711_pr*c3*gA2)/(fpi4*mpi2) + &
         (783.247644786072_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr1(2,1,15) = (-17967.065175939_pr*c1*gA2)/(fpi4*mpi2) - &
         (7747.02659701377_pr*c3*gA2)/(fpi4*mpi2) - &
         (867.669720144653_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr1(3,1,15) = (6843.01542324125_pr*c1*gA2)/(fpi4*mpi2) + &
         (3014.94458858161_pr*c3*gA2)/(fpi4*mpi2) + &
         (216.528129577637_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr1(1,3,15) = (12800.9049609375_pr*c1*gA2)/(fpi4*mpi2) + &
         (3707.04542871094_pr*c3*gA2)/(fpi4*mpi2) - &
         (745.568033203125_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr1(1,2,16) = (-3092.52618530273_pr*c1*gA2)/(fpi4*mpi2) - &
         (1011.19649671026_pr*c3*gA2)/(fpi4*mpi2) - &
         (1042.07968925432_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr1(2,2,16) = (-8378.82125244141_pr*c1*gA2)/(fpi4*mpi2) - &
         (2987.23517760232_pr*c3*gA2)/(fpi4*mpi2) + &
         (628.253677891323_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr1(1,1,17) = (14135.5592743402_pr*c1*gA2)/(fpi4*mpi2) + &
         (5746.10194483582_pr*c3*gA2)/(fpi4*mpi2) - &
         (16.4675249980382_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr1(2,1,17) = (-20256.3592693034_pr*c1*gA2)/(fpi4*mpi2) - &
         (8245.07712593439_pr*c3*gA2)/(fpi4*mpi2) + &
         (142.309278507778_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr1(3,1,17) = (8660.61555253689_pr*c1*gA2)/(fpi4*mpi2) + &
         (3459.42204756108_pr*c3*gA2)/(fpi4*mpi2) - &
         (69.7415504673549_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr1(1,3,17) = (3484.14064453125_pr*c1*gA2)/(fpi4*mpi2) + &
         (1259.881028268_pr*c3*gA2)/(fpi4*mpi2) + &
         (342.195423235212_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr1(1,2,18) = (840.376118774414_pr*c1*gA2)/(fpi4*mpi2) + &
         (319.466587109805_pr*c3*gA2)/(fpi4*mpi2) + &
         (10.8880724487305_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr1(2,2,18) = (-3131.19715759277_pr*c1*gA2)/(fpi4*mpi2) - &
         (1166.81519764533_pr*c3*gA2)/(fpi4*mpi2) - &
         (87.1195371459961_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr1(1,1,19) = (7310.26069007057_pr*c1*gA2)/(fpi4*mpi2) + &
         (3000.94037657016_pr*c3*gA2)/(fpi4*mpi2) + &
         (0.0826331377846854_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr1(2,1,19) = (-13685.5267014613_pr*c1*gA2)/(fpi4*mpi2) - &
         (5572.85595346119_pr*c3*gA2)/(fpi4*mpi2) + &
         (2.70709313686916_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr1(3,1,19) = (6169.2187169198_pr*c1*gA2)/(fpi4*mpi2) + &
         (2481.7781746784_pr*c3*gA2)/(fpi4*mpi2) + &
         (3.76123477935791_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr1(2,2,20) = (-210.094029693604_pr*c1*gA2)/(fpi4*mpi2) - &
         (79.8666467774513_pr*c3*gA2)/(fpi4*mpi2) - &
         (2.72201811218262_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr1(1,1,21) = (2476.5165551998_pr*c1*gA2)/(fpi4*mpi2) + &
         (1029.07446289094_pr*c3*gA2)/(fpi4*mpi2)
    ctr1Dr1(2,1,21) = (-5841.10206786854_pr*c1*gA2)/(fpi4*mpi2) - &
         (2407.9518963783_pr*c3*gA2)/(fpi4*mpi2) - &
         (0.0413165688923427_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr1(3,1,21) = (3018.45160491616_pr*c1*gA2)/(fpi4*mpi2) + &
         (1233.36858750781_pr*c3*gA2)/(fpi4*mpi2) + &
         (0.352447028160095_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr1(1,1,23) = (574.248747042225_pr*c1*gA2)/(fpi4*mpi2) + &
         (240.667492988211_pr*c3*gA2)/(fpi4*mpi2)
    ctr1Dr1(2,1,23) = (-1764.09490454231_pr*c1*gA2)/(fpi4*mpi2) - &
         (734.821822475346_pr*c3*gA2)/(fpi4*mpi2)
    ctr1Dr1(3,1,23) = (1123.44919031994_pr*c1*gA2)/(fpi4*mpi2) + &
         (464.703617106343_pr*c3*gA2)/(fpi4*mpi2) + &
         (0.00516457111154284_pr*c4*gA2)/(fpi4*mpi2)
    ctr1Dr1(1,1,25) = (86.2349934345314_pr*c1*gA2)/(fpi4*mpi2) + &
         (36.3168724059041_pr*c3*gA2)/(fpi4*mpi2)
    ctr1Dr1(2,1,25) = (-368.716465873243_pr*c1*gA2)/(fpi4*mpi2) - &
         (154.692733933317_pr*c3*gA2)/(fpi4*mpi2)
    ctr1Dr1(3,1,25) = (305.511227790772_pr*c1*gA2)/(fpi4*mpi2) + &
         (127.502237247082_pr*c3*gA2)/(fpi4*mpi2)
    ctr1Dr1(1,1,27) = (7.54914530309393_pr*c1*gA2)/(fpi4*mpi2) + &
         (3.18270638442274_pr*c3*gA2)/(fpi4*mpi2)
    ctr1Dr1(2,1,27) = (-50.4717107938621_pr*c1*gA2)/(fpi4*mpi2) - &
         (21.25918294258_pr*c3*gA2)/(fpi4*mpi2)
    ctr1Dr1(3,1,27) = (58.0783904906964_pr*c1*gA2)/(fpi4*mpi2) + &
         (24.3861619452745_pr*c3*gA2)/(fpi4*mpi2)
    ctr1Dr1(1,1,29) = (0.292396839746317_pr*c1*gA2)/(fpi4*mpi2) + &
         (0.12293946719219_pr*c3*gA2)/(fpi4*mpi2)
    ctr1Dr1(2,1,29) = (-4.06696949129328_pr*c1*gA2)/(fpi4*mpi2) - &
         (1.71429265940356_pr*c3*gA2)/(fpi4*mpi2)
    ctr1Dr1(3,1,29) = (7.30133981874389_pr*c1*gA2)/(fpi4*mpi2) + &
         (3.07572607707404_pr*c3*gA2)/(fpi4*mpi2)
    ctr1Dr1(2,1,31) = (-0.146198419873159_pr*c1*gA2)/(fpi4*mpi2) - &
         (0.0614697335960952_pr*c3*gA2)/(fpi4*mpi2)
    ctr1Dr1(3,1,31) = (0.54492079137995_pr*c1*gA2)/(fpi4*mpi2) + &
         (0.229654015824469_pr*c3*gA2)/(fpi4*mpi2)
    ctr1Dr1(3,1,33) = (0.0182748024841448_pr*c1*gA2)/(fpi4*mpi2) + &
         (0.00768371669951191_pr*c3*gA2)/(fpi4*mpi2)
    !
    !  Urho0tau0
    !
    ctr0t0=0.0_pr
    ctr0t0(1,1,3)=(1.36561930174741_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.0479358100097182_pr*c4*gA2)/(fpi4*mpi2)
    ctr0t0(1,1,5)=(10.5008244999755_pr*c1*gA2)/(fpi4*mpi2)- &
         (7.54491362519471_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.333010041454082_pr*c4*gA2)/(fpi4*mpi2)- &
         (0.0703125_pr*cd*ga)/(fpi4*mpi2*LambdaX)
    ctr0t0(2,1,5)=(-0.24616366400062_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.117254464285714_pr*c4*gA2)/(fpi4*mpi2)+ &
         (0.03515625_pr*cd*ga)/(fpi4*mpi2*LambdaX)
    ctr0t0(1,1,7)=(52.0673482366071_pr*c1*gA2)/(fpi4*mpi2)- &
         (25.8426066958322_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.144953338249362_pr*c4*gA2)/(fpi4*mpi2)
    ctr0t0(2,1,7)=(-58.436493475888_pr*c1*gA2)/(fpi4*mpi2)+ &
         (27.9983571543377_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.114467235331633_pr*c4*gA2)/(fpi4*mpi2)+ &
         (0.017578125_pr*cd*ga)/(fpi4*mpi2*LambdaX)
    ctr0t0(1,2,8)=(505.710701116071_pr*c1*gA2)/(fpi4*mpi2)- &
         (112.325267992606_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.9995709375_pr*c4*gA2)/(fpi4*mpi2)
    ctr0t0(2,2,8)=(-54.9853125163899_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.28125_pr*c4*gA2)/(fpi4*mpi2)
    ctr0t0(1,1,9)=(9474.83599128706_pr*c1*gA2)/(fpi4*mpi2)+ &
         (1465.87254191511_pr*c3*gA2)/(fpi4*mpi2)+ &
         (21.7653711399872_pr*c4*gA2)/(fpi4*mpi2)
    ctr0t0(2,1,9)=(-3624.78698664406_pr*c1*gA2)/(fpi4*mpi2)- &
         (461.242897263176_pr*c3*gA2)/(fpi4*mpi2)- &
         (6.96088448660714_pr*c4*gA2)/(fpi4*mpi2)
    ctr0t0(3,1,9)=(330.256406317608_pr*c1*gA2)/(fpi4*mpi2)+ &
         (97.9034765840117_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.8173828125_pr*c4*gA2)/(fpi4*mpi2)
    ctr0t0(1,3,9)=(824.990574776786_pr*c3*gA2)/(fpi4*mpi2)+ &
         (3.79697544642857_pr*c4*gA2)/(fpi4*mpi2)
    ctr0t0(1,2,10)=(-17975.7704772321_pr*c1*gA2)/(fpi4*mpi2)+ &
         (1262.86185981827_pr*c3*gA2)/(fpi4*mpi2)- &
         (2.65529641262755_pr*c4*gA2)/(fpi4*mpi2)
    ctr0t0(2,2,10)=(1251.73928571429_pr*c1*gA2)/(fpi4*mpi2)- &
         (2090.34981043995_pr*c3*gA2)/(fpi4*mpi2)- &
         (6.21662946428571_pr*c4*gA2)/(fpi4*mpi2)
    ctr0t0(1,1,11)=(34044.1058864892_pr*c1*gA2)/(fpi4*mpi2)+ &
         (30851.2885695409_pr*c3*gA2)/(fpi4*mpi2)+ &
         (650.736844237584_pr*c4*gA2)/(fpi4*mpi2)
    ctr0t0(2,1,11)=(-12289.0849327548_pr*c1*gA2)/(fpi4*mpi2)- &
         (15854.7386609546_pr*c3*gA2)/(fpi4*mpi2)- &
         (255.112345354353_pr*c4*gA2)/(fpi4*mpi2)
    ctr0t0(3,1,11)=(2814.07624373444_pr*c1*gA2)/(fpi4*mpi2)+ &
         (2910.54669625161_pr*c3*gA2)/(fpi4*mpi2)+ &
         (27.8796648297991_pr*c4*gA2)/(fpi4*mpi2)
    ctr0t0(1,3,11)=(23028.03140625_pr*c1*gA2)/(fpi4*mpi2)+ &
         (3455.7492578125_pr*c3*gA2)/(fpi4*mpi2)- &
         (20.678203125_pr*c4*gA2)/(fpi4*mpi2)
    ctr0t0(1,2,12)=(1388.89324888393_pr*c1*gA2)/(fpi4*mpi2)- &
         (36494.6219835576_pr*c3*gA2)/(fpi4*mpi2)- &
         (1798.79982589286_pr*c4*gA2)/(fpi4*mpi2)
    ctr0t0(2,2,12)=(-30185.6310351562_pr*c1*gA2)/(fpi4*mpi2)+ &
         (232.70274650057_pr*c3*gA2)/(fpi4*mpi2)+ &
         (356.94017578125_pr*c4*gA2)/(fpi4*mpi2)
    ctr0t0(1,1,13)=(169633.190522348_pr*c1*gA2)/(fpi4*mpi2)+ &
         (42011.3077626309_pr*c3*gA2)/(fpi4*mpi2)- &
         (2415.94726373814_pr*c4*gA2)/(fpi4*mpi2)
    ctr0t0(2,1,13)=(-113865.746379575_pr*c1*gA2)/(fpi4*mpi2)- &
         (22150.6599403888_pr*c3*gA2)/(fpi4*mpi2)+ &
         (1689.48225636789_pr*c4*gA2)/(fpi4*mpi2)
    ctr0t0(3,1,13)=(29118.6234258982_pr*c1*gA2)/(fpi4*mpi2)+ &
         (7008.98206338386_pr*c3*gA2)/(fpi4*mpi2)- &
         (233.193969726563_pr*c4*gA2)/(fpi4*mpi2)
    ctr0t0(1,3,13)=(25721.97103125_pr*c1*gA2)/(fpi4*mpi2)+ &
         (28797.99699375_pr*c3*gA2)/(fpi4*mpi2)+ &
         (1233.52655625_pr*c4*gA2)/(fpi4*mpi2)
    ctr0t0(1,2,14)=(-143206.840020996_pr*c1*gA2)/(fpi4*mpi2)- &
         (16594.1553967862_pr*c3*gA2)/(fpi4*mpi2)+ &
         (4966.2393031808_pr*c4*gA2)/(fpi4*mpi2)
    ctr0t0(2,2,14)=(-4876.19730050223_pr*c1*gA2)/(fpi4*mpi2)- &
         (21921.4915168923_pr*c3*gA2)/(fpi4*mpi2)- &
         (2018.39700334821_pr*c4*gA2)/(fpi4*mpi2)
    ctr0t0(1,1,15)=(111720.675330785_pr*c1*gA2)/(fpi4*mpi2)+ &
         (51670.9893465594_pr*c3*gA2)/(fpi4*mpi2)+ &
         (2349.74293435822_pr*c4*gA2)/(fpi4*mpi2)
    ctr0t0(2,1,15)=(-95184.3030091052_pr*c1*gA2)/(fpi4*mpi2)- &
         (49572.8589648463_pr*c3*gA2)/(fpi4*mpi2)- &
         (2603.00916043396_pr*c4*gA2)/(fpi4*mpi2)
    ctr0t0(3,1,15)=(38037.6118997991_pr*c1*gA2)/(fpi4*mpi2)+ &
         (18858.0289954179_pr*c3*gA2)/(fpi4*mpi2)+ &
         (649.58438873291_pr*c4*gA2)/(fpi4*mpi2)
    ctr0t0(1,3,15)=(88149.5686757812_pr*c1*gA2)/(fpi4*mpi2)+ &
         (19508.5932099609_pr*c3*gA2)/(fpi4*mpi2)- &
         (2236.70409960937_pr*c4*gA2)/(fpi4*mpi2)
    ctr0t0(1,2,16)=(-2933.63054626465_pr*c1*gA2)/(fpi4*mpi2)- &
         (9849.90830391705_pr*c3*gA2)/(fpi4*mpi2)- &
         (3126.23906776297_pr*c4*gA2)/(fpi4*mpi2)
    ctr0t0(2,2,16)=(-59728.9286700439_pr*c1*gA2)/(fpi4*mpi2)- &
         (15659.2800568336_pr*c3*gA2)/(fpi4*mpi2)+ &
         (1884.76103367397_pr*c4*gA2)/(fpi4*mpi2)
    ctr0t0(1,1,17)=(85156.8253783411_pr*c1*gA2)/(fpi4*mpi2)+ &
         (34404.1775560654_pr*c3*gA2)/(fpi4*mpi2)- &
         (49.4025749941145_pr*c4*gA2)/(fpi4*mpi2)
    ctr0t0(2,1,17)=(-123896.068978873_pr*c1*gA2)/(fpi4*mpi2)- &
         (48923.4556759794_pr*c3*gA2)/(fpi4*mpi2)+ &
         (426.927835523333_pr*c4*gA2)/(fpi4*mpi2)
    ctr0t0(3,1,17)=(53102.5825769139_pr*c1*gA2)/(fpi4*mpi2)+ &
         (20496.0380452978_pr*c3*gA2)/(fpi4*mpi2)- &
         (209.224651402065_pr*c4*gA2)/(fpi4*mpi2)
    ctr0t0(1,3,17)=(15678.6329003906_pr*c1*gA2)/(fpi4*mpi2)+ &
         (8819.16719787598_pr*c3*gA2)/(fpi4*mpi2)+ &
         (1026.58626970564_pr*c4*gA2)/(fpi4*mpi2)
    ctr0t0(1,2,18)=(4813.60998284912_pr*c1*gA2)/(fpi4*mpi2)+ &
         (1965.79485166884_pr*c3*gA2)/(fpi4*mpi2)+ &
         (32.6642173461914_pr*c4*gA2)/(fpi4*mpi2)
    ctr0t0(2,2,18)=(-17352.030255249_pr*c1*gA2)/(fpi4*mpi2)- &
         (7339.58754773114_pr*c3*gA2)/(fpi4*mpi2)- &
         (261.358611437988_pr*c4*gA2)/(fpi4*mpi2)
    ctr0t0(1,1,19)=(43859.5226517645_pr*c1*gA2)/(fpi4*mpi2)+ &
         (18006.1234631001_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.247899413354056_pr*c4*gA2)/(fpi4*mpi2)
    ctr0t0(2,1,19)=(-82168.5302213599_pr*c1*gA2)/(fpi4*mpi2)- &
         (33425.8975324765_pr*c3*gA2)/(fpi4*mpi2)+ &
         (8.12127941060747_pr*c4*gA2)/(fpi4*mpi2)
    ctr0t0(3,1,19)=(36955.7489794515_pr*c1*gA2)/(fpi4*mpi2)+ &
         (14906.1590782447_pr*c3*gA2)/(fpi4*mpi2)+ &
         (11.2837043380737_pr*c4*gA2)/(fpi4*mpi2)
    ctr0t0(2,2,20)=(-1203.40249571228_pr*c1*gA2)/(fpi4*mpi2)- &
         (491.448712917211_pr*c3*gA2)/(fpi4*mpi2)- &
         (8.16605433654785_pr*c4*gA2)/(fpi4*mpi2)
    ctr0t0(1,1,21)=(14859.0993311988_pr*c1*gA2)/(fpi4*mpi2)+ &
         (6174.44677734561_pr*c3*gA2)/(fpi4*mpi2)
    ctr0t0(2,1,21)=(-35045.5916628818_pr*c1*gA2)/(fpi4*mpi2)- &
         (14447.9519801093_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.123949706677028_pr*c4*gA2)/(fpi4*mpi2)
    ctr0t0(3,1,21)=(18103.0852743763_pr*c1*gA2)/(fpi4*mpi2)+ &
         (7401.92911003352_pr*c3*gA2)/(fpi4*mpi2)+ &
         (1.05734108448029_pr*c4*gA2)/(fpi4*mpi2)
    ctr0t0(1,1,23)=(3445.49248225335_pr*c1*gA2)/(fpi4*mpi2)+ &
         (1444.00495792927_pr*c3*gA2)/(fpi4*mpi2)
    ctr0t0(2,1,23)=(-10584.5694272539_pr*c1*gA2)/(fpi4*mpi2)- &
         (4408.93093485208_pr*c3*gA2)/(fpi4*mpi2)
    ctr0t0(3,1,23)=(6740.56754887846_pr*c1*gA2)/(fpi4*mpi2)+ &
         (2788.251777868_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.0154937133346285_pr*c4*gA2)/(fpi4*mpi2)
    ctr0t0(1,1,25)=(517.409960607188_pr*c1*gA2)/(fpi4*mpi2)+ &
         (217.901234435425_pr*c3*gA2)/(fpi4*mpi2)
    ctr0t0(2,1,25)=(-2212.29879523946_pr*c1*gA2)/(fpi4*mpi2)- &
         (928.156403599904_pr*c3*gA2)/(fpi4*mpi2)
    ctr0t0(3,1,25)=(1833.06736674463_pr*c1*gA2)/(fpi4*mpi2)+ &
         (765.013423482493_pr*c3*gA2)/(fpi4*mpi2)
    ctr0t0(1,1,27)=(45.2948718185636_pr*c1*gA2)/(fpi4*mpi2)+ &
         (19.0962383065364_pr*c3*gA2)/(fpi4*mpi2)
    ctr0t0(2,1,27)=(-302.830264763173_pr*c1*gA2)/(fpi4*mpi2)- &
         (127.55509765548_pr*c3*gA2)/(fpi4*mpi2)
    ctr0t0(3,1,27)=(348.470342944178_pr*c1*gA2)/(fpi4*mpi2)+ &
         (146.316971671647_pr*c3*gA2)/(fpi4*mpi2)
    ctr0t0(1,1,29)=(1.7543810384779_pr*c1*gA2)/(fpi4*mpi2)+ &
         (0.737636803153143_pr*c3*gA2)/(fpi4*mpi2)
    ctr0t0(2,1,29)=(-24.4018169477597_pr*c1*gA2)/(fpi4*mpi2)- &
         (10.2857559564214_pr*c3*gA2)/(fpi4*mpi2)
    ctr0t0(3,1,29)=(43.8080389124633_pr*c1*gA2)/(fpi4*mpi2)+ &
         (18.4543564624443_pr*c3*gA2)/(fpi4*mpi2)
    ctr0t0(2,1,31)=(-0.877190519238951_pr*c1*gA2)/(fpi4*mpi2)- &
         (0.368818401576571_pr*c3*gA2)/(fpi4*mpi2)
    ctr0t0(3,1,31)=(3.2695247482797_pr*c1*gA2)/(fpi4*mpi2)+ &
         (1.37792409494681_pr*c3*gA2)/(fpi4*mpi2)
    ctr0t0(3,1,33)=(0.109648814904869_pr*c1*gA2)/(fpi4*mpi2)+ &
         (0.0461023001970714_pr*c3*gA2)/(fpi4*mpi2)
    !
    !  Urho1tau0
    !
    ctr1t0=0.0_pr
    ctr1t0(1,1,3)=(-0.0370474171525753_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.0159786033365727_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t0(1,1,5)=(-0.191231023596939_pr*c1*gA2)/(fpi4*mpi2)+ &
         (0.0468828093112245_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.111003347151361_pr*c4*gA2)/(fpi4*mpi2)+ &
         (0.0234375_pr*cd*ga)/(fpi4*mpi2*LambdaX)
    ctr1t0(2,1,5)=(0.00779017857142857_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.0390848214285714_pr*c4*gA2)/(fpi4*mpi2)- &
         (0.01171875_pr*cd*ga)/(fpi4*mpi2*LambdaX)
    ctr1t0(1,1,7)=(0.765432059151786_pr*c1*gA2)/(fpi4*mpi2)- &
         (0.319270121173469_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.0483177794164541_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t0(2,1,7)=(0.0512273596938776_pr*c1*gA2)/(fpi4*mpi2)- &
         (0.00913767538265306_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.0381557451105442_pr*c4*gA2)/(fpi4*mpi2)- &
         (0.005859375_pr*cd*ga)/(fpi4*mpi2*LambdaX)
    ctr1t0(1,2,8)=(-1.41375736607143_pr*c1*gA2)/(fpi4*mpi2)+ &
         (0.846850379464286_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.3331903125_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t0(2,2,8)=(0.046875_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.09375_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t0(1,1,9)=(-22.8134614118304_pr*c1*gA2)/(fpi4*mpi2)- &
         (1.21977883211097_pr*c3*gA2)/(fpi4*mpi2)- &
         (7.25512371332908_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t0(2,1,9)=(7.09276506696429_pr*c1*gA2)/(fpi4*mpi2)+ &
         (0.199196428571429_pr*c3*gA2)/(fpi4*mpi2)+ &
         (2.32029482886905_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t0(3,1,9)=(-0.5009765625_pr*c1*gA2)/(fpi4*mpi2)- &
         (0.0966796875_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.2724609375_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t0(1,3,9)=(-1.89848772321429_pr*c3*gA2)/(fpi4*mpi2)- &
         (1.26565848214286_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t0(1,2,10)=(45.7770589285714_pr*c1*gA2)/(fpi4*mpi2)- &
         (37.9879278300383_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.885098804209184_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t0(2,2,10)=(-5.06216517857143_pr*c1*gA2)/(fpi4*mpi2)+ &
         (9.70597098214286_pr*c3*gA2)/(fpi4*mpi2)+ &
         (2.07220982142857_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t0(1,1,11)=(-440.874152071708_pr*c1*gA2)/(fpi4*mpi2)- &
         (597.813959665179_pr*c3*gA2)/(fpi4*mpi2)- &
         (216.912281412528_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t0(2,1,11)=(137.620562360491_pr*c1*gA2)/(fpi4*mpi2)+ &
         (242.982874720982_pr*c3*gA2)/(fpi4*mpi2)+ &
         (85.0374484514509_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t0(3,1,11)=(-12.2751813616071_pr*c1*gA2)/(fpi4*mpi2)- &
         (25.6883108956473_pr*c3*gA2)/(fpi4*mpi2)- &
         (9.29322160993304_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t0(1,3,11)=(-22.63640625_pr*c1*gA2)/(fpi4*mpi2)+ &
         (46.7609765625_pr*c3*gA2)/(fpi4*mpi2)+ &
         (6.892734375_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t0(1,2,12)=(1465.24899274554_pr*c1*gA2)/(fpi4*mpi2)+ &
         (1684.896046875_pr*c3*gA2)/(fpi4*mpi2)+ &
         (599.599941964286_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t0(2,2,12)=(-235.90740234375_pr*c1*gA2)/(fpi4*mpi2)- &
         (351.521103515625_pr*c3*gA2)/(fpi4*mpi2)- &
         (118.98005859375_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t0(1,1,13)=(2941.54591061489_pr*c1*gA2)/(fpi4*mpi2)+ &
         (2355.33459348319_pr*c3*gA2)/(fpi4*mpi2)+ &
         (805.315754579381_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t0(2,1,13)=(-1813.61831472866_pr*c1*gA2)/(fpi4*mpi2)- &
         (1619.87784794992_pr*c3*gA2)/(fpi4*mpi2)- &
         (563.160752122628_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t0(3,1,13)=(221.161743164063_pr*c1*gA2)/(fpi4*mpi2)+ &
         (225.247192382813_pr*c3*gA2)/(fpi4*mpi2)+ &
         (77.7313232421875_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t0(1,3,13)=(-1171.69059375_pr*c1*gA2)/(fpi4*mpi2)- &
         (1176.1601625_pr*c3*gA2)/(fpi4*mpi2)- &
         (411.17551875_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t0(1,2,14)=(-6502.52069384766_pr*c1*gA2)/(fpi4*mpi2)- &
         (5016.80990126953_pr*c3*gA2)/(fpi4*mpi2)- &
         (1655.41310106027_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t0(2,2,14)=(2369.16757114955_pr*c1*gA2)/(fpi4*mpi2)+ &
         (1991.91343610491_pr*c3*gA2)/(fpi4*mpi2)+ &
         (672.799001116071_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t0(1,1,15)=(-3755.98198127747_pr*c1*gA2)/(fpi4*mpi2)- &
         (2756.34979092146_pr*c3*gA2)/(fpi4*mpi2)- &
         (783.247644786072_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t0(2,1,15)=(3861.25969552264_pr*c1*gA2)/(fpi4*mpi2)+ &
         (2865.95377119141_pr*c3*gA2)/(fpi4*mpi2)+ &
         (867.669720144653_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t0(3,1,15)=(-880.419287109375_pr*c1*gA2)/(fpi4*mpi2)- &
         (683.312782287598_pr*c3*gA2)/(fpi4*mpi2)- &
         (216.528129577637_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t0(1,3,15)=(3099.20776171875_pr*c1*gA2)/(fpi4*mpi2)+ &
         (2319.50358105469_pr*c3*gA2)/(fpi4*mpi2)+ &
         (745.568033203125_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t0(1,2,16)=(5164.53977966309_pr*c1*gA2)/(fpi4*mpi2)+ &
         (3750.44797599923_pr*c3*gA2)/(fpi4*mpi2)+ &
         (1042.07968925432_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t0(2,2,16)=(-2919.87245544434_pr*c1*gA2)/(fpi4*mpi2)- &
         (2116.93618456159_pr*c3*gA2)/(fpi4*mpi2)- &
         (628.253677891323_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t0(1,1,17)=(113.823727294922_pr*c1*gA2)/(fpi4*mpi2)+ &
         (71.9582676125663_pr*c3*gA2)/(fpi4*mpi2)+ &
         (16.4675249980382_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t0(2,1,17)=(-793.151098434448_pr*c1*gA2)/(fpi4*mpi2)- &
         (552.996386267526_pr*c3*gA2)/(fpi4*mpi2)- &
         (142.309278507778_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t0(3,1,17)=(364.767998526437_pr*c1*gA2)/(fpi4*mpi2)+ &
         (251.980659746443_pr*c3*gA2)/(fpi4*mpi2)+ &
         (69.7415504673549_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t0(1,3,17)=(-1742.07032226563_pr*c1*gA2)/(fpi4*mpi2)- &
         (1259.881028268_pr*c3*gA2)/(fpi4*mpi2)- &
         (342.195423235212_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t0(1,2,18)=(-76.2155765991211_pr*c1*gA2)/(fpi4*mpi2)- &
         (48.9953290100098_pr*c3*gA2)/(fpi4*mpi2)- &
         (10.8880724487305_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t0(2,2,18)=(489.043165649414_pr*c1*gA2)/(fpi4*mpi2)+ &
         (346.766698773193_pr*c3*gA2)/(fpi4*mpi2)+ &
         (87.1195371459961_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t0(1,1,19)=(-0.68049621963501_pr*c1*gA2)/(fpi4*mpi2)- &
         (0.481203679112026_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.0826331377846854_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t0(2,1,19)=(-18.1235791282654_pr*c1*gA2)/(fpi4*mpi2)- &
         (11.0002656221662_pr*c3*gA2)/(fpi4*mpi2)- &
         (2.70709313686916_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t0(3,1,19)=(-21.7049503326416_pr*c1*gA2)/(fpi4*mpi2)- &
         (16.8184317398071_pr*c3*gA2)/(fpi4*mpi2)- &
         (3.76123477935791_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t0(2,2,20)=(19.0538941497803_pr*c1*gA2)/(fpi4*mpi2)+ &
         (12.2488322525024_pr*c3*gA2)/(fpi4*mpi2)+ &
         (2.72201811218262_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t0(2,1,21)=(0.340248109817505_pr*c1*gA2)/(fpi4*mpi2)+ &
         (0.240601839556013_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.0413165688923427_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t0(3,1,21)=(-2.58308817386627_pr*c1*gA2)/(fpi4*mpi2)- &
         (1.74732532024384_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.352447028160095_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t0(3,1,23)=(-0.0425310137271881_pr*c1*gA2)/(fpi4*mpi2)- &
         (0.0300752299445016_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.00516457111154284_pr*c4*gA2)/(fpi4*mpi2)
    !
    !  Urho1tau1
    !
    ctr1t1=0.0_pr
    ctr1t1(1,1,3)=(-0.450116223436374_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.0319572066731454_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t1(1,1,5)=(-3.5385371069221_pr*c1*gA2)/(fpi4*mpi2)+ &
         (2.50259509338973_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.222006694302721_pr*c4*gA2)/(fpi4*mpi2)+ &
         (0.046875_pr*cd*ga)/(fpi4*mpi2*LambdaX)
    ctr1t1(2,1,5)=(0.0898447332383019_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.0781696428571429_pr*c4*gA2)/(fpi4*mpi2)- &
         (0.0234375_pr*cd*ga)/(fpi4*mpi2*LambdaX)
    ctr1t1(1,1,7)=(-17.2434756863839_pr*c1*gA2)/(fpi4*mpi2)+ &
         (8.60257873066855_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.0966355588329082_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t1(2,1,7)=(19.5159960183232_pr*c1*gA2)/(fpi4*mpi2)- &
         (9.34811780250883_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.0763114902210884_pr*c4*gA2)/(fpi4*mpi2)- &
         (0.01171875_pr*cd*ga)/(fpi4*mpi2*LambdaX)
    ctr1t1(1,2,8)=(-168.933991071429_pr*c1*gA2)/(fpi4*mpi2)+ &
         (37.320722537714_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.666380625_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t1(2,2,8)=(18.3753125054633_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.1875_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t1(1,1,9)=(-3146.36888298668_pr*c1*gA2)/(fpi4*mpi2)- &
         (492.901337694334_pr*c3*gA2)/(fpi4*mpi2)- &
         (14.5102474266582_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t1(2,1,9)=(1205.47618769832_pr*c1*gA2)/(fpi4*mpi2)+ &
         (155.024983611535_pr*c3*gA2)/(fpi4*mpi2)+ &
         (4.6405896577381_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t1(3,1,9)=(-109.918476585036_pr*c1*gA2)/(fpi4*mpi2)- &
         (32.7311718821706_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.544921875_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t1(1,3,9)=(-274.364029017857_pr*c3*gA2)/(fpi4*mpi2)- &
         (2.53131696428571_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t1(1,2,10)=(5901.79117633929_pr*c1*gA2)/(fpi4*mpi2)- &
         (385.542873162743_pr*c3*gA2)/(fpi4*mpi2)+ &
         (1.77019760841837_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t1(2,2,10)=(-404.58984375_pr*c1*gA2)/(fpi4*mpi2)+ &
         (690.035446485936_pr*c3*gA2)/(fpi4*mpi2)+ &
         (4.14441964285714_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t1(1,1,11)=(-12146.9163811618_pr*c1*gA2)/(fpi4*mpi2)- &
         (9992.47844580492_pr*c3*gA2)/(fpi4*mpi2)- &
         (433.824562825056_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t1(2,1,11)=(4424.78103473708_pr*c1*gA2)/(fpi4*mpi2)+ &
         (5157.68192548934_pr*c3*gA2)/(fpi4*mpi2)+ &
         (170.074896902902_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t1(3,1,11)=(-968.792783439754_pr*c1*gA2)/(fpi4*mpi2)- &
         (956.662918816572_pr*c3*gA2)/(fpi4*mpi2)- &
         (18.5864432198661_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t1(1,3,11)=(-7552.959375_pr*c1*gA2)/(fpi4*mpi2)- &
         (1191.78466145833_pr*c3*gA2)/(fpi4*mpi2)+ &
         (13.78546875_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t1(1,2,12)=(2094.44863895089_pr*c1*gA2)/(fpi4*mpi2)+ &
         (11355.6974476442_pr*c3*gA2)/(fpi4*mpi2)+ &
         (1199.19988392857_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t1(2,2,12)=(9461.258671875_pr*c1*gA2)/(fpi4*mpi2)+ &
         (113.574869005018_pr*c3*gA2)/(fpi4*mpi2)- &
         (237.9601171875_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t1(1,1,13)=(-52317.8224267498_pr*c1*gA2)/(fpi4*mpi2)- &
         (15039.7248405472_pr*c3*gA2)/(fpi4*mpi2)+ &
         (1610.63150915876_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t1(2,1,13)=(35095.2865087366_pr*c1*gA2)/(fpi4*mpi2)+ &
         (8132.24487638635_pr*c3*gA2)/(fpi4*mpi2)- &
         (1126.32150424526_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t1(3,1,13)=(-9282.48454203116_pr*c1*gA2)/(fpi4*mpi2)- &
         (2450.24959567222_pr*c3*gA2)/(fpi4*mpi2)+ &
         (155.462646484375_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t1(1,3,13)=(-10352.0559375_pr*c1*gA2)/(fpi4*mpi2)- &
         (9070.84456875_pr*c3*gA2)/(fpi4*mpi2)- &
         (822.3510375_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t1(1,2,14)=(39347.6453808594_pr*c1*gA2)/(fpi4*mpi2)+ &
         (7581.1506071644_pr*c3*gA2)/(fpi4*mpi2)- &
         (3310.82620212054_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t1(2,2,14)=(4830.05495256696_pr*c1*gA2)/(fpi4*mpi2)+ &
         (6468.34894359579_pr*c3*gA2)/(fpi4*mpi2)+ &
         (1345.59800223214_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t1(1,1,15)=(-41054.5351555039_pr*c1*gA2)/(fpi4*mpi2)- &
         (16289.8093013422_pr*c3*gA2)/(fpi4*mpi2)- &
         (1566.49528957214_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t1(2,1,15)=(35934.130351878_pr*c1*gA2)/(fpi4*mpi2)+ &
         (15494.0531940275_pr*c3*gA2)/(fpi4*mpi2)+ &
         (1735.33944028931_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t1(3,1,15)=(-13686.0308464825_pr*c1*gA2)/(fpi4*mpi2)- &
         (6029.88917716322_pr*c3*gA2)/(fpi4*mpi2)- &
         (433.056259155273_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t1(1,3,15)=(-25601.809921875_pr*c1*gA2)/(fpi4*mpi2)- &
         (7414.09085742188_pr*c3*gA2)/(fpi4*mpi2)+ &
         (1491.13606640625_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t1(1,2,16)=(6185.05237060547_pr*c1*gA2)/(fpi4*mpi2)+ &
         (2022.39299342052_pr*c3*gA2)/(fpi4*mpi2)+ &
         (2084.15937850865_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t1(2,2,16)=(16757.6425048828_pr*c1*gA2)/(fpi4*mpi2)+ &
         (5974.47035520464_pr*c3*gA2)/(fpi4*mpi2)- &
         (1256.50735578265_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t1(1,1,17)=(-28271.1185486804_pr*c1*gA2)/(fpi4*mpi2)- &
         (11492.2038896716_pr*c3*gA2)/(fpi4*mpi2)+ &
         (32.9350499960763_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t1(2,1,17)=(40512.7185386068_pr*c1*gA2)/(fpi4*mpi2)+ &
         (16490.1542518688_pr*c3*gA2)/(fpi4*mpi2)- &
         (284.618557015555_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t1(3,1,17)=(-17321.2311050738_pr*c1*gA2)/(fpi4*mpi2)- &
         (6918.84409512217_pr*c3*gA2)/(fpi4*mpi2)+ &
         (139.48310093471_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t1(1,3,17)=(-6968.2812890625_pr*c1*gA2)/(fpi4*mpi2)- &
         (2519.76205653599_pr*c3*gA2)/(fpi4*mpi2)- &
         (684.390846470424_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t1(1,2,18)=(-1680.75223754883_pr*c1*gA2)/(fpi4*mpi2)- &
         (638.933174219611_pr*c3*gA2)/(fpi4*mpi2)- &
         (21.7761448974609_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t1(2,2,18)=(6262.39431518555_pr*c1*gA2)/(fpi4*mpi2)+ &
         (2333.63039529067_pr*c3*gA2)/(fpi4*mpi2)+ &
         (174.239074291992_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t1(1,1,19)=(-14620.5213801411_pr*c1*gA2)/(fpi4*mpi2)- &
         (6001.88075314032_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.165266275569371_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t1(2,1,19)=(27371.0534029225_pr*c1*gA2)/(fpi4*mpi2)+ &
         (11145.7119069224_pr*c3*gA2)/(fpi4*mpi2)- &
         (5.41418627373832_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t1(3,1,19)=(-12338.4374338396_pr*c1*gA2)/(fpi4*mpi2)- &
         (4963.55634935681_pr*c3*gA2)/(fpi4*mpi2)- &
         (7.52246955871582_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t1(2,2,20)=(420.188059387207_pr*c1*gA2)/(fpi4*mpi2)+ &
         (159.733293554903_pr*c3*gA2)/(fpi4*mpi2)+ &
         (5.44403622436523_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t1(1,1,21)=(-4953.03311039961_pr*c1*gA2)/(fpi4*mpi2)- &
         (2058.14892578187_pr*c3*gA2)/(fpi4*mpi2)
    ctr1t1(2,1,21)=(11682.2041357371_pr*c1*gA2)/(fpi4*mpi2)+ &
         (4815.90379275659_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.0826331377846854_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t1(3,1,21)=(-6036.90320983232_pr*c1*gA2)/(fpi4*mpi2)- &
         (2466.73717501561_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.70489405632019_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t1(1,1,23)=(-1148.49749408445_pr*c1*gA2)/(fpi4*mpi2)- &
         (481.334985976422_pr*c3*gA2)/(fpi4*mpi2)
    ctr1t1(2,1,23)=(3528.18980908462_pr*c1*gA2)/(fpi4*mpi2)+ &
         (1469.64364495069_pr*c3*gA2)/(fpi4*mpi2)
    ctr1t1(3,1,23)=(-2246.89838063988_pr*c1*gA2)/(fpi4*mpi2)- &
         (929.407234212685_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.0103291422230857_pr*c4*gA2)/(fpi4*mpi2)
    ctr1t1(1,1,25)=(-172.469986869063_pr*c1*gA2)/(fpi4*mpi2)- &
         (72.6337448118083_pr*c3*gA2)/(fpi4*mpi2)
    ctr1t1(2,1,25)=(737.432931746486_pr*c1*gA2)/(fpi4*mpi2)+ &
         (309.385467866635_pr*c3*gA2)/(fpi4*mpi2)
    ctr1t1(3,1,25)=(-611.022455581544_pr*c1*gA2)/(fpi4*mpi2)- &
         (255.004474494164_pr*c3*gA2)/(fpi4*mpi2)
    ctr1t1(1,1,27)=(-15.0982906061879_pr*c1*gA2)/(fpi4*mpi2)- &
         (6.36541276884548_pr*c3*gA2)/(fpi4*mpi2)
    ctr1t1(2,1,27)=(100.943421587724_pr*c1*gA2)/(fpi4*mpi2)+ &
         (42.51836588516_pr*c3*gA2)/(fpi4*mpi2)
    ctr1t1(3,1,27)=(-116.156780981393_pr*c1*gA2)/(fpi4*mpi2)- &
         (48.7723238905489_pr*c3*gA2)/(fpi4*mpi2)
    ctr1t1(1,1,29)=(-0.584793679492634_pr*c1*gA2)/(fpi4*mpi2)- &
         (0.245878934384381_pr*c3*gA2)/(fpi4*mpi2)
    ctr1t1(2,1,29)=(8.13393898258656_pr*c1*gA2)/(fpi4*mpi2)+ &
         (3.42858531880712_pr*c3*gA2)/(fpi4*mpi2)
    ctr1t1(3,1,29)=(-14.6026796374878_pr*c1*gA2)/(fpi4*mpi2)- &
         (6.15145215414809_pr*c3*gA2)/(fpi4*mpi2)
    ctr1t1(2,1,31)=(0.292396839746317_pr*c1*gA2)/(fpi4*mpi2)+ &
         (0.12293946719219_pr*c3*gA2)/(fpi4*mpi2)
    ctr1t1(3,1,31)=(-1.0898415827599_pr*c1*gA2)/(fpi4*mpi2)- &
         (0.459308031648938_pr*c3*gA2)/(fpi4*mpi2)
    ctr1t1(3,1,33)=(-0.0365496049682896_pr*c1*gA2)/(fpi4*mpi2)- &
         (0.0153674333990238_pr*c3*gA2)/(fpi4*mpi2)
    !
    !  UJ0Drho0
    !
    ctJ0dr0=0.0_pr
    !
    !  Urho0DJ0
    !
    ctr0DJ0=0.0_pr
    ctr0DJ0(1,1,3)=(-0.244419766459837_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.0234375000151846_pr*c4*gA2)/(fpi4*mpi2)
    ctr0DJ0(1,1,5)=(-1.03158597015212_pr*c1*gA2)/(fpi4*mpi2)+ &
         (0.780470479470306_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.0351562492028061_pr*c4*gA2)/(fpi4*mpi2)
    ctr0DJ0(1,1,7)=(-21.0022652575419_pr*c1*gA2)/(fpi4*mpi2)+ &
         (2.27019651550668_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.00439427564971301_pr*c4*gA2)/(fpi4*mpi2)
    ctr0DJ0(2,1,7)=(6.64452901902785_pr*c1*gA2)/(fpi4*mpi2)- &
         (1.38867403439195_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.0175780851403061_pr*c4*gA2)/(fpi4*mpi2)
    ctr0DJ0(1,2,8)=(-0.000291666666666667_pr*c1*gA2)/(fpi4*mpi2)+ &
         (0.0000478125_pr*c3*gA2)/(fpi4*mpi2)- &
         (4.01785714285714e-7_pr*c4*gA2)/(fpi4*mpi2)
    ctr0DJ0(1,1,9)=(-307.281664803321_pr*c1*gA2)/(fpi4*mpi2)- &
         (17.4248922644585_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.0131892671795281_pr*c4*gA2)/(fpi4*mpi2)
    ctr0DJ0(2,1,9)=(167.072976616587_pr*c1*gA2)/(fpi4*mpi2)+ &
         (4.91318494493787_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.00878976004464286_pr*c4*gA2)/(fpi4*mpi2)
    ctr0DJ0(3,1,9)=(-20.6458593811462_pr*c1*gA2)/(fpi4*mpi2)
    ctr0DJ0(1,2,10)=(0.07489375_pr*c1*gA2)/(fpi4*mpi2)+ &
         (0.000520145089285714_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.0000100207270408163_pr*c4*gA2)/(fpi4*mpi2)
    ctr0DJ0(2,2,10)=(-0.009375_pr*c1*gA2)/(fpi4*mpi2)
    ctr0DJ0(1,1,11)=(-1417.24568001336_pr*c1*gA2)/(fpi4*mpi2)- &
         (148.086566637738_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.00426528076171875_pr*c4*gA2)/(fpi4*mpi2)
    ctr0DJ0(2,1,11)=(1006.30895614752_pr*c1*gA2)/(fpi4*mpi2)+ &
         (93.3959309491168_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.0102003609793527_pr*c4*gA2)/(fpi4*mpi2)
    ctr0DJ0(3,1,11)=(-165.352324283285_pr*c1*gA2)/(fpi4*mpi2)- &
         (12.9178818130112_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.00332205636160714_pr*c4*gA2)/(fpi4*mpi2)
    ctr0DJ0(1,3,11)=(-0.0875_pr*c1*gA2)/(fpi4*mpi2)
    ctr0DJ0(1,2,12)=(-0.663125_pr*c1*gA2)/(fpi4*mpi2)+ &
         (0.09263671875_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.00322935267857143_pr*c4*gA2)/(fpi4*mpi2)
    ctr0DJ0(2,2,12)=(0.22640625_pr*c1*gA2)/(fpi4*mpi2)- &
         (0.01634765625_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.00052734375_pr*c4*gA2)/(fpi4*mpi2)
    ctr0DJ0(1,1,13)=(-3324.31750521588_pr*c1*gA2)/(fpi4*mpi2)- &
         (384.460747217616_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.00614578334263393_pr*c4*gA2)/(fpi4*mpi2)
    ctr0DJ0(2,1,13)=(2946.4643595763_pr*c1*gA2)/(fpi4*mpi2)+ &
         (332.165470161666_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.00216459803989955_pr*c4*gA2)/(fpi4*mpi2)
    ctr0DJ0(3,1,13)=(-602.212375765244_pr*c1*gA2)/(fpi4*mpi2)- &
         (64.5897786600606_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.001190185546875_pr*c4*gA2)/(fpi4*mpi2)
    ctr0DJ0(1,3,13)=(0.37125_pr*c1*gA2)/(fpi4*mpi2)- &
         (0.0631546875_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.0026578125_pr*c4*gA2)/(fpi4*mpi2)
    ctr0DJ0(1,2,14)=(1.72600911458333_pr*c1*gA2)/(fpi4*mpi2)- &
         (0.135301904296875_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.0143205845424107_pr*c4*gA2)/(fpi4*mpi2)
    ctr0DJ0(2,2,14)=(-0.62890625_pr*c1*gA2)/(fpi4*mpi2)+ &
         (0.0793212890625_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.00530482700892857_pr*c4*gA2)/(fpi4*mpi2)
    ctr0DJ0(1,1,15)=(-4612.5195280616_pr*c1*gA2)/(fpi4*mpi2)- &
         (513.154765943116_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.00963807367597307_pr*c4*gA2)/(fpi4*mpi2)
    ctr0DJ0(2,1,15)=(5043.02746283907_pr*c1*gA2)/(fpi4*mpi2)+ &
         (573.956470083127_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.00939304275512695_pr*c4*gA2)/(fpi4*mpi2)
    ctr0DJ0(3,1,15)=(-1259.59323184652_pr*c1*gA2)/(fpi4*mpi2)- &
         (143.759310262187_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.00231170654296875_pr*c4*gA2)/(fpi4*mpi2)
    ctr0DJ0(1,3,15)=(-0.71465625_pr*c1*gA2)/(fpi4*mpi2)+ &
         (0.0487265625_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.0069609375_pr*c4*gA2)/(fpi4*mpi2)
    ctr0DJ0(1,2,16)=(-0.13190234375_pr*c1*gA2)/(fpi4*mpi2)+ &
         (0.084516064453125_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.0133438685825893_pr*c4*gA2)/(fpi4*mpi2)
    ctr0DJ0(2,2,16)=(0.345556640625_pr*c1*gA2)/(fpi4*mpi2)- &
         (0.0366448974609375_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.0070806884765625_pr*c4*gA2)/(fpi4*mpi2)
    ctr0DJ0(1,1,17)=(-4081.8063003269_pr*c1*gA2)/(fpi4*mpi2)- &
         (405.584681811802_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.000288566207885742_pr*c4*gA2)/(fpi4*mpi2)
    ctr0DJ0(2,1,17)=(5511.17933250622_pr*c1*gA2)/(fpi4*mpi2)+ &
         (582.019749761264_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.00207645034790039_pr*c4*gA2)/(fpi4*mpi2)
    ctr0DJ0(3,1,17)=(-1676.42040558742_pr*c1*gA2)/(fpi4*mpi2)- &
         (184.111758668806_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.000897445678710938_pr*c4*gA2)/(fpi4*mpi2)
    ctr0DJ0(1,3,17)=(-0.031904296875_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.00455775669642857_pr*c4*gA2)/(fpi4*mpi2)
    ctr0DJ0(1,2,18)=(-0.0106455078125_pr*c1*gA2)/(fpi4*mpi2)- &
         (0.00226593017578125_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.00019940185546875_pr*c4*gA2)/(fpi4*mpi2)
    ctr0DJ0(2,2,18)=(0.03829833984375_pr*c1*gA2)/(fpi4*mpi2)+ &
         (0.0119082458496094_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.00132149047851563_pr*c4*gA2)/(fpi4*mpi2)
    ctr0DJ0(1,1,19)=(-2389.93945013977_pr*c1*gA2)/(fpi4*mpi2)- &
         (200.758956740934_pr*c3*gA2)/(fpi4*mpi2)+ &
         (2.18095779418945e-6_pr*c4*gA2)/(fpi4*mpi2)
    ctr0DJ0(2,1,19)=(4026.89040316843_pr*c1*gA2)/(fpi4*mpi2)+ &
         (373.930398299718_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.0000424012184143066_pr*c4*gA2)/(fpi4*mpi2)
    ctr0DJ0(3,1,19)=(-1499.34103770493_pr*c1*gA2)/(fpi4*mpi2)- &
         (149.680535490279_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.0000683426856994629_pr*c4*gA2)/(fpi4*mpi2)
    ctr0DJ0(2,2,20)=(0.002661376953125_pr*c1*gA2)/(fpi4*mpi2)+ &
         (0.000566482543945312_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.0000498504638671875_pr*c4*gA2)/(fpi4*mpi2)
    ctr0DJ0(1,1,21)=(-937.343180466548_pr*c1*gA2)/(fpi4*mpi2)- &
         (62.9319292613857_pr*c3*gA2)/(fpi4*mpi2)
    ctr0DJ0(2,1,21)=(2012.17746809803_pr*c1*gA2)/(fpi4*mpi2)+ &
         (156.764429796522_pr*c3*gA2)/(fpi4*mpi2)- &
         (1.09047889709473e-6_pr*c4*gA2)/(fpi4*mpi2)
    ctr0DJ0(3,1,21)=(-928.899230533649_pr*c1*gA2)/(fpi4*mpi2)- &
         (80.7120141836349_pr*c3*gA2)/(fpi4*mpi2)+ &
         (7.43508338928223e-6_pr*c4*gA2)/(fpi4*mpi2)
    ctr0DJ0(1,1,23)=(-243.60536380909_pr*c1*gA2)/(fpi4*mpi2)- &
         (12.1417483739015_pr*c3*gA2)/(fpi4*mpi2)
    ctr0DJ0(2,1,23)=(690.008776700697_pr*c1*gA2)/(fpi4*mpi2)+ &
         (42.8121424298444_pr*c3*gA2)/(fpi4*mpi2)
    ctr0DJ0(3,1,23)=(-403.794812461118_pr*c1*gA2)/(fpi4*mpi2)- &
         (29.2881400946876_pr*c3*gA2)/(fpi4*mpi2)+ &
         (1.36309862136841e-7_pr*c4*gA2)/(fpi4*mpi2)
    ctr0DJ0(1,1,25)=(-40.2494438142034_pr*c1*gA2)/(fpi4*mpi2)- &
         (1.31603730589479_pr*c3*gA2)/(fpi4*mpi2)
    ctr0DJ0(2,1,25)=(159.713027711956_pr*c1*gA2)/(fpi4*mpi2)+ &
         (7.34601767825556_pr*c3*gA2)/(fpi4*mpi2)
    ctr0DJ0(3,1,25)=(-122.828777785615_pr*c1*gA2)/(fpi4*mpi2)- &
         (7.0783524478032_pr*c3*gA2)/(fpi4*mpi2)
    ctr0DJ0(1,1,27)=(-3.82761492020625_pr*c1*gA2)/(fpi4*mpi2)- &
         (0.0613407218849266_pr*c3*gA2)/(fpi4*mpi2)
    ctr0DJ0(2,1,27)=(23.8460141906355_pr*c1*gA2)/(fpi4*mpi2)+ &
         (0.719359374832321_pr*c3*gA2)/(fpi4*mpi2)
    ctr0DJ0(3,1,27)=(-25.6066641016362_pr*c1*gA2)/(fpi4*mpi2)- &
         (1.09298032666628_pr*c3*gA2)/(fpi4*mpi2)
    ctr0DJ0(1,1,29)=(-0.159483955008594_pr*c1*gA2)/(fpi4*mpi2)
    ctr0DJ0(2,1,29)=(2.07329141511172_pr*c1*gA2)/(fpi4*mpi2)+ &
         (0.0306703609424633_pr*c3*gA2)/(fpi4*mpi2)
    ctr0DJ0(3,1,29)=(-3.48578429802332_pr*c1*gA2)/(fpi4*mpi2)- &
         (0.0975875120896559_pr*c3*gA2)/(fpi4*mpi2)
    ctr0DJ0(2,1,31)=(0.0797419775042969_pr*c1*gA2)/(fpi4*mpi2)
    ctr0DJ0(3,1,31)=(-0.279096921265039_pr*c1*gA2)/(fpi4*mpi2)- &
         (0.00383379511780791_pr*c3*gA2)/(fpi4*mpi2)
    ctr0DJ0(3,1,33)=(-0.00996774718803712_pr*c1*gA2)/(fpi4*mpi2)
    !
    !  UJ1Drho1
    !
    ctJ1dr1=0.0_pr
    !
    !  Urho1DJ1
    !
    ctr1dJ1=0.0_pr
    ctr1dJ1(1,1,3)=(0.0736607554815508_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.0156250000101231_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ1(1,1,5)=(0.308705740050707_pr*c1*gA2)/(fpi4*mpi2)- &
         (0.248438076755833_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.0234374994685374_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ1(1,1,7)=(6.96559883584731_pr*c1*gA2)/(fpi4*mpi2)- &
         (0.755267413285654_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.00292951709980867_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ1(2,1,7)=(-2.17968675634262_pr*c1*gA2)/(fpi4*mpi2)+ &
         (0.45703198308388_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.0117187234268707_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ1(1,2,8)=(0.0000972222222222222_pr*c1*gA2)/(fpi4*mpi2)- &
         (0.0000158035714285714_pr*c3*gA2)/(fpi4*mpi2)+ &
         (2.67857142857143e-7_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ1(1,1,9)=(102.418432538607_pr*c1*gA2)/(fpi4*mpi2)+ &
         (5.80390099909298_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.00879284478635204_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ1(2,1,9)=(-55.6646250180288_pr*c1*gA2)/(fpi4*mpi2)- &
         (1.63479839496441_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.0058598400297619_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ1(3,1,9)=(6.87316406454873_pr*c1*gA2)/(fpi4*mpi2)
    ctr1dJ1(1,2,10)=(-0.0249645833333333_pr*c1*gA2)/(fpi4*mpi2)- &
         (0.000170041454081633_pr*c3*gA2)/(fpi4*mpi2)+ &
         (6.68048469387755e-6_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ1(2,2,10)=(0.003125_pr*c1*gA2)/(fpi4*mpi2)
    ctr1dJ1(1,1,11)=(472.415226671119_pr*c1*gA2)/(fpi4*mpi2)+ &
         (49.3607671189922_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.0028435205078125_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ1(2,1,11)=(-335.431924184589_pr*c1*gA2)/(fpi4*mpi2)- &
         (31.1285768627125_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.00680024065290179_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ1(3,1,11)=(55.1130468965117_pr*c1*gA2)/(fpi4*mpi2)+ &
         (4.30485325221653_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.00221470424107143_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ1(1,3,11)=(0.0291666666666667_pr*c1*gA2)/(fpi4*mpi2)
    ctr1dJ1(1,2,12)=(0.221041666666667_pr*c1*gA2)/(fpi4*mpi2)- &
         (0.0298024553571429_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.00215290178571429_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ1(2,2,12)=(-0.07546875_pr*c1*gA2)/(fpi4*mpi2)+ &
         (0.0052734375_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.0003515625_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ1(1,1,13)=(1108.10583507196_pr*c1*gA2)/(fpi4*mpi2)+ &
         (128.155631000319_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.00409718889508929_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ1(2,1,13)=(-982.154786525432_pr*c1*gA2)/(fpi4*mpi2)- &
         (110.722544919902_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.00144306535993304_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ1(3,1,13)=(200.736909272009_pr*c1*gA2)/(fpi4*mpi2)+ &
         (21.5295294915046_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.00079345703125_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ1(1,3,13)=(-0.12375_pr*c1*gA2)/(fpi4*mpi2)+ &
         (0.020165625_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.001771875_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ1(1,2,14)=(-0.575336371527778_pr*c1*gA2)/(fpi4*mpi2)+ &
         (0.0403271065848214_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.00954705636160714_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ1(2,2,14)=(0.209635416666667_pr*c1*gA2)/(fpi4*mpi2)- &
         (0.0246721540178571_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.00353655133928571_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ1(1,1,15)=(1537.50650935387_pr*c1*gA2)/(fpi4*mpi2)+ &
         (171.04837595648_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.00642538245064872_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ1(2,1,15)=(-1681.00915427969_pr*c1*gA2)/(fpi4*mpi2)- &
         (191.31569234679_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.00626202850341797_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ1(3,1,15)=(419.864410615508_pr*c1*gA2)/(fpi4*mpi2)+ &
         (47.9189995185479_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.0015411376953125_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ1(1,3,15)=(0.23821875_pr*c1*gA2)/(fpi4*mpi2)- &
         (0.013921875_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.004640625_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ1(1,2,16)=(0.0439674479166667_pr*c1*gA2)/(fpi4*mpi2)- &
         (0.0237240652901786_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.00889591238839286_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ1(2,2,16)=(-0.115185546875_pr*c1*gA2)/(fpi4*mpi2)+ &
         (0.009854736328125_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.004720458984375_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ1(1,1,17)=(1360.60210010897_pr*c1*gA2)/(fpi4*mpi2)+ &
         (135.194990126003_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.000192377471923828_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ1(2,1,17)=(-1837.05977750207_pr*c1*gA2)/(fpi4*mpi2)- &
         (194.007275403871_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.00138430023193359_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ1(3,1,17)=(558.806801862472_pr*c1*gA2)/(fpi4*mpi2)+ &
         (61.370885371495_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.000598297119140625_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ1(1,3,17)=(0.00911551339285714_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.00303850446428571_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ1(1,2,18)=(0.00354850260416667_pr*c1*gA2)/(fpi4*mpi2)+ &
         (0.0006888427734375_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.0001329345703125_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ1(2,2,18)=(-0.01276611328125_pr*c1*gA2)/(fpi4*mpi2)- &
         (0.00352891845703125_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.00088099365234375_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ1(1,1,19)=(796.646483379922_pr*c1*gA2)/(fpi4*mpi2)+ &
         (66.919651519992_pr*c3*gA2)/(fpi4*mpi2)- &
         (1.45397186279297e-6_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ1(2,1,19)=(-1342.29680105614_pr*c1*gA2)/(fpi4*mpi2)- &
         (124.643480233646_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.0000282674789428711_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ1(3,1,19)=(499.780345901644_pr*c1*gA2)/(fpi4*mpi2)+ &
         (49.8934890491979_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.0000455617904663086_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ1(2,2,20)=(-0.000887125651041667_pr*c1*gA2)/(fpi4*mpi2)- &
         (0.000172210693359375_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.000033233642578125_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ1(1,1,21)=(312.447726822183_pr*c1*gA2)/(fpi4*mpi2)+ &
         (20.9773097537952_pr*c3*gA2)/(fpi4*mpi2)
    ctr1dJ1(2,1,21)=(-670.725822699343_pr*c1*gA2)/(fpi4*mpi2)- &
         (52.2548095686812_pr*c3*gA2)/(fpi4*mpi2)+ &
         (7.26985931396484e-7_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ1(3,1,21)=(309.63307684455_pr*c1*gA2)/(fpi4*mpi2)+ &
         (26.9040022495172_pr*c3*gA2)/(fpi4*mpi2)- &
         (4.95672225952148e-6_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ1(1,1,23)=(81.2017879363635_pr*c1*gA2)/(fpi4*mpi2)+ &
         (4.04724945796715_pr*c3*gA2)/(fpi4*mpi2)
    ctr1dJ1(2,1,23)=(-230.002925566899_pr*c1*gA2)/(fpi4*mpi2)- &
         (14.2707141432815_pr*c3*gA2)/(fpi4*mpi2)
    ctr1dJ1(3,1,23)=(134.598270820373_pr*c1*gA2)/(fpi4*mpi2)+ &
         (9.76271331945924_pr*c3*gA2)/(fpi4*mpi2)- &
         (9.08732414245605e-8_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ1(1,1,25)=(13.4164812714011_pr*c1*gA2)/(fpi4*mpi2)+ &
         (0.43867910196493_pr*c3*gA2)/(fpi4*mpi2)
    ctr1dJ1(2,1,25)=(-53.2376759039853_pr*c1*gA2)/(fpi4*mpi2)- &
         (2.44867255941852_pr*c3*gA2)/(fpi4*mpi2)
    ctr1dJ1(3,1,25)=(40.9429259285383_pr*c1*gA2)/(fpi4*mpi2)+ &
         (2.3594508159344_pr*c3*gA2)/(fpi4*mpi2)
    ctr1dJ1(1,1,27)=(1.27587164006875_pr*c1*gA2)/(fpi4*mpi2)+ &
         (0.0204469072949755_pr*c3*gA2)/(fpi4*mpi2)
    ctr1dJ1(2,1,27)=(-7.94867139687851_pr*c1*gA2)/(fpi4*mpi2)- &
         (0.23978645827744_pr*c3*gA2)/(fpi4*mpi2)
    ctr1dJ1(3,1,27)=(8.53555470054539_pr*c1*gA2)/(fpi4*mpi2)+ &
         (0.364326775555427_pr*c3*gA2)/(fpi4*mpi2)
    ctr1dJ1(1,1,29)=(0.053161318336198_pr*c1*gA2)/(fpi4*mpi2)
    ctr1dJ1(2,1,29)=(-0.691097138370574_pr*c1*gA2)/(fpi4*mpi2)- &
         (0.0102234536474878_pr*c3*gA2)/(fpi4*mpi2)
    ctr1dJ1(3,1,29)=(1.16192809934111_pr*c1*gA2)/(fpi4*mpi2)+ &
         (0.032529170696552_pr*c3*gA2)/(fpi4*mpi2)
    ctr1dJ1(2,1,31)=(-0.026580659168099_pr*c1*gA2)/(fpi4*mpi2)
    ctr1dJ1(3,1,31)=(0.0930323070883464_pr*c1*gA2)/(fpi4*mpi2)+ &
         (0.00127793170593597_pr*c3*gA2)/(fpi4*mpi2)
    ctr1dJ1(3,1,33)=(0.00332258239601237_pr*c1*gA2)/(fpi4*mpi2)
    !
    !  UJ0Drho1
    !
    ctJ0dr1=0.0_pr
    !
    !  Urho1DJ0
    !
    ctr1dJ0=0.0_pr
    ctr1dJ0(1,1,3)=(0.0234375000151846_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.00781250000506155_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ0(1,1,5)=(0.10546875_pr*c1*gA2)/(fpi4*mpi2)- &
         (0.0351562492028061_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.0117187497342687_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ0(1,1,7)=(0.10546875_pr*c1*gA2)/(fpi4*mpi2)- &
         (0.00439427564971301_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.00146475854990434_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ0(2,1,7)=(-0.10546875_pr*c1*gA2)/(fpi4*mpi2)+ &
         (0.0175780851403061_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.00585936171343537_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ0(1,2,8)=(-4.01785714285714e-7_pr*c3*gA2)/(fpi4*mpi2)+ &
         (1.33928571428571e-7_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ0(1,1,9)=(0.0263671875_pr*c1*gA2)/(fpi4*mpi2)+ &
         (0.0131892671795281_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.00439642239317602_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ0(2,1,9)=(-0.0791015625_pr*c1*gA2)/(fpi4*mpi2)- &
         (0.00878976004464286_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.00292992001488095_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ0(3,1,9)=(0.0263671875_pr*c1*gA2)/(fpi4*mpi2)
    ctr1dJ0(1,2,10)=(-0.0000100207270408163_pr*c3*gA2)/(fpi4*mpi2)+ &
         (3.34024234693878e-6_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ0(1,1,11)=(0.00426528076171875_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.00142176025390625_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ0(2,1,11)=(-0.01318359375_pr*c1*gA2)/(fpi4*mpi2)- &
         (0.0102003609793527_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.00340012032645089_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ0(3,1,11)=(0.01318359375_pr*c1*gA2)/(fpi4*mpi2)+ &
         (0.00332205636160714_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.00110735212053571_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ0(1,2,12)=(-0.00322935267857143_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.00107645089285714_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ0(2,2,12)=(0.00052734375_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.00017578125_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ0(1,1,13)=(-0.00614578334263393_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.00204859444754464_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ0(2,1,13)=(0.00216459803989955_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.000721532679966518_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ0(3,1,13)=(0.00164794921875_pr*c1*gA2)/(fpi4*mpi2)+ &
         (0.001190185546875_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.000396728515625_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ0(1,3,13)=(0.0026578125_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.0008859375_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ0(1,2,14)=(0.0143205845424107_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.00477352818080357_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ0(2,2,14)=(-0.00530482700892857_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.00176827566964286_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ0(1,1,15)=(0.00963807367597307_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.00321269122532436_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ0(2,1,15)=(-0.00939304275512695_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.00313101425170898_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ0(3,1,15)=(0.00231170654296875_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.00077056884765625_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ0(1,3,15)=(-0.0069609375_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.0023203125_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ0(1,2,16)=(-0.0133438685825893_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.00444795619419643_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ0(2,2,16)=(0.0070806884765625_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.0023602294921875_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ0(1,1,17)=(-0.000288566207885742_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.0000961887359619141_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ0(2,1,17)=(0.00207645034790039_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.000692150115966797_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ0(3,1,17)=(-0.000897445678710938_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.000299148559570312_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ0(1,3,17)=(0.00455775669642857_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.00151925223214286_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ0(1,2,18)=(0.00019940185546875_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.00006646728515625_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ0(2,2,18)=(-0.00132149047851563_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.000440496826171875_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ0(1,1,19)=(2.18095779418945e-6_pr*c3*gA2)/(fpi4*mpi2)- &
         (7.26985931396484e-7_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ0(2,1,19)=(0.0000424012184143066_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.0000141337394714355_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ0(3,1,19)=(0.0000683426856994629_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.0000227808952331543_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ0(2,2,20)=(-0.0000498504638671875_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.0000166168212890625_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ0(2,1,21)=(-1.09047889709473e-6_pr*c3*gA2)/(fpi4*mpi2)+ &
         (3.63492965698242e-7_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ0(3,1,21)=(7.43508338928223e-6_pr*c3*gA2)/(fpi4*mpi2)- &
         (2.47836112976074e-6_pr*c4*gA2)/(fpi4*mpi2)
    ctr1dJ0(3,1,23)=(1.36309862136841e-7_pr*c3*gA2)/(fpi4*mpi2)- &
         (4.54366207122803e-8_pr*c4*gA2)/(fpi4*mpi2)
    !
    !  UJ1Drho0
    !
    ctJ1dr0=0.0_pr
    !
    !  UJ0J0
    !
    ctJ0J0=0.0_pr
    ctJ0J0(1,1,3)=(-0.0388151948706056_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.0689519291560374_pr*c4*gA2)/(fpi4*mpi2)+ &
         (0.03515625_pr*cd*ga)/(fpi4*mpi2*LambdaX)
    ctJ0J0(1,1,5)=(-0.148030393439646_pr*c1*gA2)/(fpi4*mpi2)- &
         (0.125249890279611_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.124165184550383_pr*c4*gA2)/(fpi4*mpi2)- &
         (0.017578125_pr*cd*ga)/(fpi4*mpi2*LambdaX)
    ctJ0J0(1,2,6)=(0.266832652280755_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.0685045280612245_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J0(1,1,7)=(-50.9400757481906_pr*c1*gA2)/(fpi4*mpi2)+ &
         (1.49639517552504_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.00598016955317283_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J0(2,1,7)=(9.4436896594477_pr*c1*gA2)/(fpi4*mpi2)- &
         (0.387304024062572_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.00211338089923469_pr*c4*gA2)/(fpi4*mpi2)+ &
         (0.00439453125_pr*cd*ga)/(fpi4*mpi2*LambdaX)
    ctJ0J0(1,2,8)=(60.4392047247024_pr*c1*gA2)/(fpi4*mpi2)+ &
         (21.2791752723318_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.0653900223214286_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J0(1,1,9)=(-6519.80035123157_pr*c1*gA2)/(fpi4*mpi2)+ &
         (316.045390495029_pr*c3*gA2)/(fpi4*mpi2)+ &
         (2.16832575424506_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J0(2,1,9)=(2094.21472214372_pr*c1*gA2)/(fpi4*mpi2)- &
         (79.8751918140941_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.347175990513393_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J0(3,1,9)=(-174.923789099377_pr*c1*gA2)/(fpi4*mpi2)
    ctJ0J0(1,3,9)=(-136.232770647321_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.632829241071429_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J0(1,2,10)=(22280.2381832589_pr*c1*gA2)/(fpi4*mpi2)- &
         (3725.75432559614_pr*c3*gA2)/(fpi4*mpi2)- &
         (40.7846229073661_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J0(2,2,10)=(-3482.03035714286_pr*c1*gA2)/(fpi4*mpi2)+ &
         (857.700259443584_pr*c3*gA2)/(fpi4*mpi2)+ &
         (7.79614955357143_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J0(1,1,11)=(52284.4157057857_pr*c1*gA2)/(fpi4*mpi2)- &
         (22649.0853151035_pr*c3*gA2)/(fpi4*mpi2)- &
         (389.622252285779_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J0(2,1,11)=(-29244.8802258893_pr*c1*gA2)/(fpi4*mpi2)+ &
         (11240.6895935096_pr*c3*gA2)/(fpi4*mpi2)+ &
         (170.39136171439_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J0(3,1,11)=(3224.34088479694_pr*c1*gA2)/(fpi4*mpi2)- &
         (1377.64430659016_pr*c3*gA2)/(fpi4*mpi2)- &
         (18.1685616629464_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J0(1,3,11)=(-20240.849921875_pr*c1*gA2)/(fpi4*mpi2)+ &
         (3674.53847265625_pr*c3*gA2)/(fpi4*mpi2)+ &
         (49.9097109375_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J0(1,2,12)=(-142538.810602121_pr*c1*gA2)/(fpi4*mpi2)+ &
         (51959.7177006278_pr*c3*gA2)/(fpi4*mpi2)+ &
         (1056.48083035714_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J0(2,2,12)=(47556.1071386719_pr*c1*gA2)/(fpi4*mpi2)- &
         (13973.2343116668_pr*c3*gA2)/(fpi4*mpi2)- &
         (251.396513671875_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J0(1,1,13)=(-141614.511333235_pr*c1*gA2)/(fpi4*mpi2)+ &
         (35973.0682685409_pr*c3*gA2)/(fpi4*mpi2)+ &
         (1263.90306398228_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J0(2,1,13)=(120423.751289578_pr*c1*gA2)/(fpi4*mpi2)- &
         (33366.8468838635_pr*c3*gA2)/(fpi4*mpi2)- &
         (938.242939340534_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J0(3,1,13)=(-23741.2058036637_pr*c1*gA2)/(fpi4*mpi2)+ &
         (6070.38539035745_pr*c3*gA2)/(fpi4*mpi2)+ &
         (145.681594848633_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J0(1,3,13)=(76403.207390625_pr*c1*gA2)/(fpi4*mpi2)- &
         (27942.3675271205_pr*c3*gA2)/(fpi4*mpi2)- &
         (671.186349441964_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J0(1,2,14)=(204907.907447184_pr*c1*gA2)/(fpi4*mpi2)- &
         (56211.484659242_pr*c3*gA2)/(fpi4*mpi2)- &
         (2422.99460657436_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J0(2,2,14)=(-95398.9531424386_pr*c1*gA2)/(fpi4*mpi2)+ &
         (30129.2960691746_pr*c3*gA2)/(fpi4*mpi2)+ &
         (1018.34175868443_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J0(1,1,15)=(9978.05620114632_pr*c1*gA2)/(fpi4*mpi2)- &
         (6474.12892378917_pr*c3*gA2)/(fpi4*mpi2)- &
         (968.323984416389_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J0(2,1,15)=(-36487.3307862002_pr*c1*gA2)/(fpi4*mpi2)+ &
         (13937.926974747_pr*c3*gA2)/(fpi4*mpi2)+ &
         (1128.44835742705_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J0(3,1,15)=(13562.8790229223_pr*c1*gA2)/(fpi4*mpi2)- &
         (5370.52492057074_pr*c3*gA2)/(fpi4*mpi2)- &
         (292.012623596191_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J0(1,3,15)=(-76061.0427714844_pr*c1*gA2)/(fpi4*mpi2)+ &
         (21292.048190918_pr*c3*gA2)/(fpi4*mpi2)+ &
         (1052.55900878906_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J0(1,2,16)=(-26755.8098873901_pr*c1*gA2)/(fpi4*mpi2)+ &
         (11051.0158225074_pr*c3*gA2)/(fpi4*mpi2)+ &
         (1284.3833242048_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J0(2,2,16)=(33104.1130819702_pr*c1*gA2)/(fpi4*mpi2)- &
         (10790.492615363_pr*c3*gA2)/(fpi4*mpi2)- &
         (813.688233476911_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J0(1,1,17)=(-13525.0298722901_pr*c1*gA2)/(fpi4*mpi2)+ &
         (3920.12706464951_pr*c3*gA2)/(fpi4*mpi2)+ &
         (21.2402742906025_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J0(2,1,17)=(18744.3022469218_pr*c1*gA2)/(fpi4*mpi2)- &
         (5272.85370859068_pr*c3*gA2)/(fpi4*mpi2)- &
         (174.676497182301_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J0(3,1,17)=(-7131.99279047117_pr*c1*gA2)/(fpi4*mpi2)+ &
         (1930.52177440425_pr*c3*gA2)/(fpi4*mpi2)+ &
         (88.4860045787266_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J0(1,3,17)=(7839.31645019531_pr*c1*gA2)/(fpi4*mpi2)- &
         (2869.73837755476_pr*c3*gA2)/(fpi4*mpi2)- &
         (419.970217895508_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J0(1,2,18)=(355.059586151123_pr*c1*gA2)/(fpi4*mpi2)+ &
         (183.100210884983_pr*c3*gA2)/(fpi4*mpi2)- &
         (13.999078478132_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J0(2,2,18)=(-1327.89377142334_pr*c1*gA2)/(fpi4*mpi2)+ &
         (15.4343164854196_pr*c3*gA2)/(fpi4*mpi2)+ &
         (105.873926083374_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J0(1,1,19)=(-8867.21170169755_pr*c1*gA2)/(fpi4*mpi2)+ &
         (2936.70582294006_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.109368735306604_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J0(2,1,19)=(13819.8747331675_pr*c1*gA2)/(fpi4*mpi2)- &
         (4438.03614592496_pr*c3*gA2)/(fpi4*mpi2)- &
         (3.51122917092868_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J0(3,1,19)=(-4725.00077792637_pr*c1*gA2)/(fpi4*mpi2)+ &
         (1532.04177968309_pr*c3*gA2)/(fpi4*mpi2)- &
         (4.33029295563698_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J0(2,2,20)=(-88.7648965377808_pr*c1*gA2)/(fpi4*mpi2)- &
         (45.7750527212457_pr*c3*gA2)/(fpi4*mpi2)+ &
         (3.49976961953299_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J0(1,1,21)=(-3950.27983470918_pr*c1*gA2)/(fpi4*mpi2)+ &
         (1347.42215988918_pr*c3*gA2)/(fpi4*mpi2)
    ctJ0J0(2,1,21)=(7835.22431087985_pr*c1*gA2)/(fpi4*mpi2)- &
         (2624.64064001171_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.0546843676533018_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J0(3,1,21)=(-3337.91716486204_pr*c1*gA2)/(fpi4*mpi2)+ &
         (1111.14574092555_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.449709850430489_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J0(1,1,23)=(-1142.83677022112_pr*c1*gA2)/(fpi4*mpi2)+ &
         (401.209483659988_pr*c3*gA2)/(fpi4*mpi2)
    ctJ0J0(2,1,23)=(3005.12399409001_pr*c1*gA2)/(fpi4*mpi2)- &
         (1034.46527332476_pr*c3*gA2)/(fpi4*mpi2)
    ctJ0J0(3,1,23)=(-1635.837501786_pr*c1*gA2)/(fpi4*mpi2)+ &
         (553.405150406837_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.00683554595666272_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J0(1,1,25)=(-207.173615193637_pr*c1*gA2)/(fpi4*mpi2)+ &
         (74.5943777265557_pr*c3*gA2)/(fpi4*mpi2)
    ctJ0J0(2,1,25)=(765.620232650329_pr*c1*gA2)/(fpi4*mpi2)- &
         (270.43438082633_pr*c3*gA2)/(fpi4*mpi2)
    ctJ0J0(3,1,25)=(-549.802354657625_pr*c1*gA2)/(fpi4*mpi2)+ &
         (190.708530684211_pr*c3*gA2)/(fpi4*mpi2)
    ctJ0J0(1,1,27)=(-21.371516474291_pr*c1*gA2)/(fpi4*mpi2)+ &
         (7.86480912750357_pr*c3*gA2)/(fpi4*mpi2)
    ctJ0J0(2,1,27)=(124.32036907328_pr*c1*gA2)/(fpi4*mpi2)- &
         (44.92276431339_pr*c3*gA2)/(fpi4*mpi2)
    ctJ0J0(3,1,27)=(-125.00166164342_pr*c1*gA2)/(fpi4*mpi2)+ &
         (44.3795879210135_pr*c3*gA2)/(fpi4*mpi2)
    ctJ0J0(1,1,29)=(-0.956932496743248_pr*c1*gA2)/(fpi4*mpi2)+ &
         (0.358850516087132_pr*c3*gA2)/(fpi4*mpi2)
    ctJ0J0(2,1,29)=(11.6426907338887_pr*c1*gA2)/(fpi4*mpi2)- &
         (4.29125507983892_pr*c3*gA2)/(fpi4*mpi2)
    ctJ0J0(3,1,29)=(-18.3709744429036_pr*c1*gA2)/(fpi4*mpi2)+ &
         (6.65825509945955_pr*c3*gA2)/(fpi4*mpi2)
    ctJ0J0(2,1,31)=(0.478466248371624_pr*c1*gA2)/(fpi4*mpi2)- &
         (0.179425258043566_pr*c3*gA2)/(fpi4*mpi2)
    ctJ0J0(3,1,31)=(-1.574952903829_pr*c1*gA2)/(fpi4*mpi2)+ &
         (0.581263199490756_pr*c3*gA2)/(fpi4*mpi2)
    ctJ0J0(3,1,33)=(-0.059808281046453_pr*c1*gA2)/(fpi4*mpi2)+ &
         (0.0224281572554458_pr*c3*gA2)/(fpi4*mpi2)
    !
    !  UJ0J1
    !
    ctJ0J1=0.0_pr
    ctJ0J1(1,1,3)=(0.0285278380152656_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.0459679527706916_pr*c4*gA2)/(fpi4*mpi2)- &
         (0.0234375_pr*cd*ga)/(fpi4*mpi2*LambdaX)
    ctJ0J1(1,1,5)=(-0.00310602359693878_pr*c1*gA2)/(fpi4*mpi2)- &
         (0.0516361625744048_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.0827767897002551_pr*c4*gA2)/(fpi4*mpi2)+ &
         (0.01171875_pr*cd*ga)/(fpi4*mpi2*LambdaX)
    ctJ0J1(1,2,6)=(0.0475446853741497_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.0456696853741497_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J1(1,1,7)=(0.147463309151786_pr*c1*gA2)/(fpi4*mpi2)- &
         (0.0358081265611713_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.00398677970211522_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J1(2,1,7)=(0.00200860969387755_pr*c1*gA2)/(fpi4*mpi2)- &
         (0.0111190874787415_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.0014089205994898_pr*c4*gA2)/(fpi4*mpi2)- &
         (0.0029296875_pr*cd*ga)/(fpi4*mpi2*LambdaX)
    ctJ0J1(1,2,8)=(-0.363757366071429_pr*c1*gA2)/(fpi4*mpi2)+ &
         (0.177937700892857_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.0435933482142857_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J1(1,1,9)=(11.9185698381696_pr*c1*gA2)/(fpi4*mpi2)- &
         (0.18312424087213_pr*c3*gA2)/(fpi4*mpi2)- &
         (1.44555050283004_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J1(2,1,9)=(-2.81250837053571_pr*c1*gA2)/(fpi4*mpi2)- &
         (0.0791064453125_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.231450660342262_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J1(3,1,9)=(0.17578125_pr*c1*gA2)/(fpi4*mpi2)
    ctJ0J1(1,3,9)=(-0.210943080357143_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.421886160714286_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J1(1,2,10)=(-90.1323160714286_pr*c1*gA2)/(fpi4*mpi2)+ &
         (9.21932595663265_pr*c3*gA2)/(fpi4*mpi2)+ &
         (27.1897486049107_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J1(2,2,10)=(12.6565848214286_pr*c1*gA2)/(fpi4*mpi2)- &
         (1.095703125_pr*c3*gA2)/(fpi4*mpi2)- &
         (5.19743303571429_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J1(1,1,11)=(-798.881085665458_pr*c1*gA2)/(fpi4*mpi2)+ &
         (160.074257447634_pr*c3*gA2)/(fpi4*mpi2)+ &
         (259.748168190519_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J1(2,1,11)=(328.414995954241_pr*c1*gA2)/(fpi4*mpi2)- &
         (61.5935256713867_pr*c3*gA2)/(fpi4*mpi2)- &
         (113.594241142927_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J1(3,1,11)=(-30.7629743303571_pr*c1*gA2)/(fpi4*mpi2)+ &
         (5.57625906808036_pr*c3*gA2)/(fpi4*mpi2)+ &
         (12.1123744419643_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J1(1,3,11)=(123.05109375_pr*c1*gA2)/(fpi4*mpi2)- &
         (15.2580234375_pr*c3*gA2)/(fpi4*mpi2)- &
         (33.273140625_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J1(1,2,12)=(2557.41305524554_pr*c1*gA2)/(fpi4*mpi2)- &
         (494.193056919643_pr*c3*gA2)/(fpi4*mpi2)- &
         (704.320553571429_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J1(2,2,12)=(-600.61833984375_pr*c1*gA2)/(fpi4*mpi2)+ &
         (105.762021484375_pr*c3*gA2)/(fpi4*mpi2)+ &
         (167.59767578125_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J1(1,1,13)=(4226.57441403285_pr*c1*gA2)/(fpi4*mpi2)- &
         (759.654990867397_pr*c3*gA2)/(fpi4*mpi2)- &
         (842.602042654855_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J1(2,1,13)=(-2859.96228445522_pr*c1*gA2)/(fpi4*mpi2)+ &
         (519.521237971814_pr*c3*gA2)/(fpi4*mpi2)+ &
         (625.495292893689_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J1(3,1,13)=(423.723815917969_pr*c1*gA2)/(fpi4*mpi2)- &
         (74.1513366699219_pr*c3*gA2)/(fpi4*mpi2)- &
         (97.1210632324219_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J1(1,3,13)=(-1778.06559375_pr*c1*gA2)/(fpi4*mpi2)+ &
         (349.290122544643_pr*c3*gA2)/(fpi4*mpi2)+ &
         (447.457566294643_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J1(1,2,14)=(-8387.96795947266_pr*c1*gA2)/(fpi4*mpi2)+ &
         (1557.82783909738_pr*c3*gA2)/(fpi4*mpi2)+ &
         (1615.32973771624_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J1(2,2,14)=(3204.65585239955_pr*c1*gA2)/(fpi4*mpi2)- &
         (610.780761369978_pr*c3*gA2)/(fpi4*mpi2)- &
         (678.894505789621_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J1(1,1,15)=(-3814.31004524231_pr*c1*gA2)/(fpi4*mpi2)+ &
         (782.002794581876_pr*c3*gA2)/(fpi4*mpi2)+ &
         (645.54932294426_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J1(2,1,15)=(4206.02934884295_pr*c1*gA2)/(fpi4*mpi2)- &
         (834.729188615308_pr*c3*gA2)/(fpi4*mpi2)- &
         (752.298904951368_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J1(3,1,15)=(-1006.82687988281_pr*c1*gA2)/(fpi4*mpi2)+ &
         (200.402084350586_pr*c3*gA2)/(fpi4*mpi2)+ &
         (194.675082397461_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J1(1,3,15)=(3781.37963671875_pr*c1*gA2)/(fpi4*mpi2)- &
         (709.003098632812_pr*c3*gA2)/(fpi4*mpi2)- &
         (701.706005859375_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J1(1,2,16)=(5207.17552185059_pr*c1*gA2)/(fpi4*mpi2)- &
         (1065.41645752128_pr*c3*gA2)/(fpi4*mpi2)- &
         (856.255549469866_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J1(2,2,16)=(-3152.00038513184_pr*c1*gA2)/(fpi4*mpi2)+ &
         (618.68313205392_pr*c3*gA2)/(fpi4*mpi2)+ &
         (542.458822317941_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J1(1,1,17)=(114.489910766602_pr*c1*gA2)/(fpi4*mpi2)- &
         (21.7326762047359_pr*c3*gA2)/(fpi4*mpi2)- &
         (14.1601828604017_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J1(2,1,17)=(-785.971121017456_pr*c1*gA2)/(fpi4*mpi2)+ &
         (158.614487102509_pr*c3*gA2)/(fpi4*mpi2)+ &
         (116.450998121534_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J1(3,1,17)=(379.629753897531_pr*c1*gA2)/(fpi4*mpi2)- &
         (73.6791959381104_pr*c3*gA2)/(fpi4*mpi2)- &
         (58.9906697191511_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J1(1,3,17)=(-1742.07032226563_pr*c1*gA2)/(fpi4*mpi2)+ &
         (357.745064784459_pr*c3*gA2)/(fpi4*mpi2)+ &
         (279.980145263672_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J1(1,2,18)=(-76.2155765991211_pr*c1*gA2)/(fpi4*mpi2)+ &
         (14.7764228733608_pr*c3*gA2)/(fpi4*mpi2)+ &
         (9.33271898542132_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J1(2,2,18)=(478.384230102539_pr*c1*gA2)/(fpi4*mpi2)- &
         (98.7791618408203_pr*c3*gA2)/(fpi4*mpi2)- &
         (70.582617388916_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J1(1,1,19)=(-0.68049621963501_pr*c1*gA2)/(fpi4*mpi2)+ &
         (0.150680578790392_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.0729124902044024_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J1(2,1,19)=(-18.4566708641052_pr*c1*gA2)/(fpi4*mpi2)+ &
         (3.32744608689717_pr*c3*gA2)/(fpi4*mpi2)+ &
         (2.34081944728579_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J1(3,1,19)=(-19.8544406890869_pr*c1*gA2)/(fpi4*mpi2)+ &
         (4.63924562215805_pr*c3*gA2)/(fpi4*mpi2)+ &
         (2.88686197042465_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J1(2,2,20)=(19.0538941497803_pr*c1*gA2)/(fpi4*mpi2)- &
         (3.69410571834019_pr*c3*gA2)/(fpi4*mpi2)- &
         (2.33317974635533_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J1(2,1,21)=(0.340248109817505_pr*c1*gA2)/(fpi4*mpi2)- &
         (0.0753402893951961_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.0364562451022012_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J1(3,1,21)=(-2.54145170688629_pr*c1*gA2)/(fpi4*mpi2)+ &
         (0.526430741071701_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.299806566953659_pr*c4*gA2)/(fpi4*mpi2)
    ctJ0J1(3,1,23)=(-0.0425310137271881_pr*c1*gA2)/(fpi4*mpi2)+ &
         (0.00941753617439951_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.00455703063777515_pr*c4*gA2)/(fpi4*mpi2)
    !
    !  UJ1J1
    !
    ctJ1J1=0.0_pr
    ctJ1J1(1,1,3)=(0.0496322121163276_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.0229839763853458_pr*c4*gA2)/(fpi4*mpi2)- &
         (0.01171875_pr*cd*ga)/(fpi4*mpi2*LambdaX)
    ctJ1J1(1,1,5)=(0.196140339479882_pr*c1*gA2)/(fpi4*mpi2)- &
         (0.0113169982018643_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.0413883948501276_pr*c4*gA2)/(fpi4*mpi2)+ &
         (0.005859375_pr*cd*ga)/(fpi4*mpi2*LambdaX)
    ctJ1J1(1,2,6)=(-0.0889442174269183_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.0228348426870748_pr*c4*gA2)/(fpi4*mpi2)
    ctJ1J1(1,1,7)=(16.7237752493969_pr*c1*gA2)/(fpi4*mpi2)- &
         (0.34790459899251_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.00199338985105761_pr*c4*gA2)/(fpi4*mpi2)
    ctJ1J1(2,1,7)=(-3.22524030314923_pr*c1*gA2)/(fpi4*mpi2)+ &
         (0.137722860274259_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.000704460299744898_pr*c4*gA2)/(fpi4*mpi2)- &
         (0.00146484375_pr*cd*ga)/(fpi4*mpi2*LambdaX)
    ctJ1J1(1,2,8)=(-19.6214015749008_pr*c1*gA2)/(fpi4*mpi2)- &
         (7.57700061161061_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.0217966741071429_pr*c4*gA2)/(fpi4*mpi2)
    ctJ1J1(1,1,9)=(2190.64598296261_pr*c1*gA2)/(fpi4*mpi2)- &
         (106.868359765483_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.722775251415019_pr*c4*gA2)/(fpi4*mpi2)
    ctJ1J1(2,1,9)=(-703.063761547905_pr*c1*gA2)/(fpi4*mpi2)+ &
         (27.158281478954_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.115725330171131_pr*c4*gA2)/(fpi4*mpi2)
    ctJ1J1(3,1,9)=(58.6594921997924_pr*c1*gA2)/(fpi4*mpi2)
    ctJ1J1(1,3,9)=(46.67658203125_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.210943080357143_pr*c4*gA2)/(fpi4*mpi2)
    ctJ1J1(1,2,10)=(-7494.70074858631_pr*c1*gA2)/(fpi4*mpi2)+ &
         (1278.61760582159_pr*c3*gA2)/(fpi4*mpi2)+ &
         (13.5948743024554_pr*c4*gA2)/(fpi4*mpi2)
    ctJ1J1(2,2,10)=(1169.53616071429_pr*c1*gA2)/(fpi4*mpi2)- &
         (294.126983802623_pr*c3*gA2)/(fpi4*mpi2)- &
         (2.59871651785714_pr*c4*gA2)/(fpi4*mpi2)
    ctJ1J1(1,1,11)=(-17607.1420353921_pr*c1*gA2)/(fpi4*mpi2)+ &
         (7994.24713374194_pr*c3*gA2)/(fpi4*mpi2)+ &
         (129.87408409526_pr*c4*gA2)/(fpi4*mpi2)
    ctJ1J1(2,1,11)=(9843.68403362975_pr*c1*gA2)/(fpi4*mpi2)- &
         (3932.01024951878_pr*c3*gA2)/(fpi4*mpi2)- &
         (56.7971205714634_pr*c4*gA2)/(fpi4*mpi2)
    ctJ1J1(3,1,11)=(-1084.01759961981_pr*c1*gA2)/(fpi4*mpi2)+ &
         (478.820795649102_pr*c3*gA2)/(fpi4*mpi2)+ &
         (6.05618722098214_pr*c4*gA2)/(fpi4*mpi2)
    ctJ1J1(1,3,11)=(6819.79372395833_pr*c1*gA2)/(fpi4*mpi2)- &
         (1268.16076692708_pr*c3*gA2)/(fpi4*mpi2)- &
         (16.6365703125_pr*c4*gA2)/(fpi4*mpi2)
    ctJ1J1(1,2,12)=(48059.0188986235_pr*c1*gA2)/(fpi4*mpi2)- &
         (18566.944349986_pr*c3*gA2)/(fpi4*mpi2)- &
         (352.160276785714_pr*c4*gA2)/(fpi4*mpi2)
    ctJ1J1(2,2,12)=(-16034.3911816406_pr*c1*gA2)/(fpi4*mpi2)+ &
         (4929.07689946187_pr*c3*gA2)/(fpi4*mpi2)+ &
         (83.798837890625_pr*c4*gA2)/(fpi4*mpi2)
    ctJ1J1(1,1,13)=(47847.3513627872_pr*c1*gA2)/(fpi4*mpi2)- &
         (13686.6719432792_pr*c3*gA2)/(fpi4*mpi2)- &
         (421.301021327427_pr*c4*gA2)/(fpi4*mpi2)
    ctJ1J1(2,1,13)=(-40664.4224147226_pr*c1*gA2)/(fpi4*mpi2)+ &
         (12306.5684431232_pr*c3*gA2)/(fpi4*mpi2)+ &
         (312.747646446845_pr*c4*gA2)/(fpi4*mpi2)
    ctJ1J1(3,1,13)=(8015.01712823947_pr*c1*gA2)/(fpi4*mpi2)- &
         (2193.04572012566_pr*c3*gA2)/(fpi4*mpi2)- &
         (48.5605316162109_pr*c4*gA2)/(fpi4*mpi2)
    ctJ1J1(1,3,13)=(-25770.923296875_pr*c1*gA2)/(fpi4*mpi2)+ &
         (10166.4482434152_pr*c3*gA2)/(fpi4*mpi2)+ &
         (223.728783147321_pr*c4*gA2)/(fpi4*mpi2)
    ctJ1J1(1,2,14)=(-69245.3594485406_pr*c1*gA2)/(fpi4*mpi2)+ &
         (22270.458788223_pr*c3*gA2)/(fpi4*mpi2)+ &
         (807.664868858119_pr*c4*gA2)/(fpi4*mpi2)
    ctJ1J1(2,2,14)=(32217.3951881045_pr*c1*gA2)/(fpi4*mpi2)- &
         (11458.4663920128_pr*c3*gA2)/(fpi4*mpi2)- &
         (339.44725289481_pr*c4*gA2)/(fpi4*mpi2)
    ctJ1J1(1,1,15)=(-3355.18276569786_pr*c1*gA2)/(fpi4*mpi2)+ &
         (4003.15120252837_pr*c3*gA2)/(fpi4*mpi2)+ &
         (322.77466147213_pr*c4*gA2)/(fpi4*mpi2)
    ctJ1J1(2,1,15)=(12334.8284220602_pr*c1*gA2)/(fpi4*mpi2)- &
         (6594.07536966716_pr*c3*gA2)/(fpi4*mpi2)- &
         (376.149452475684_pr*c4*gA2)/(fpi4*mpi2)
    ctJ1J1(3,1,15)=(-4584.16347069416_pr*c1*gA2)/(fpi4*mpi2)+ &
         (2259.89314979311_pr*c3*gA2)/(fpi4*mpi2)+ &
         (97.3375411987305_pr*c4*gA2)/(fpi4*mpi2)
    ctJ1J1(1,3,15)=(25694.7668613281_pr*c1*gA2)/(fpi4*mpi2)- &
         (8712.71905517578_pr*c3*gA2)/(fpi4*mpi2)- &
         (350.853002929688_pr*c4*gA2)/(fpi4*mpi2)
    ctJ1J1(1,2,16)=(8939.92116689046_pr*c1*gA2)/(fpi4*mpi2)- &
         (6189.35971202371_pr*c3*gA2)/(fpi4*mpi2)- &
         (428.127774734933_pr*c4*gA2)/(fpi4*mpi2)
    ctJ1J1(2,2,16)=(-11150.7683255005_pr*c1*gA2)/(fpi4*mpi2)+ &
         (5032.6588526575_pr*c3*gA2)/(fpi4*mpi2)+ &
         (271.22941115897_pr*c4*gA2)/(fpi4*mpi2)
    ctJ1J1(1,1,17)=(4508.67638249921_pr*c1*gA2)/(fpi4*mpi2)- &
         (1354.76069989184_pr*c3*gA2)/(fpi4*mpi2)- &
         (7.08009143020085_pr*c4*gA2)/(fpi4*mpi2)
    ctJ1J1(2,1,17)=(-6244.51076026543_pr*c1*gA2)/(fpi4*mpi2)+ &
         (2125.28532690204_pr*c3*gA2)/(fpi4*mpi2)+ &
         (58.225499060767_pr*c4*gA2)/(fpi4*mpi2)
    ctJ1J1(3,1,17)=(2384.7618078426_pr*c1*gA2)/(fpi4*mpi2)- &
         (812.91389298321_pr*c3*gA2)/(fpi4*mpi2)- &
         (29.4953348595755_pr*c4*gA2)/(fpi4*mpi2)
    ctJ1J1(1,3,17)=(-2613.10548339844_pr*c1*gA2)/(fpi4*mpi2)+ &
         (1796.50318320138_pr*c3*gA2)/(fpi4*mpi2)+ &
         (139.990072631836_pr*c4*gA2)/(fpi4*mpi2)
    ctJ1J1(1,2,18)=(-118.353195383708_pr*c1*gA2)/(fpi4*mpi2)- &
         (28.3697180204175_pr*c3*gA2)/(fpi4*mpi2)+ &
         (4.66635949271066_pr*c4*gA2)/(fpi4*mpi2)
    ctJ1J1(2,2,18)=(437.301789367676_pr*c1*gA2)/(fpi4*mpi2)- &
         (234.978396185244_pr*c3*gA2)/(fpi4*mpi2)- &
         (35.291308694458_pr*c4*gA2)/(fpi4*mpi2)
    ctJ1J1(1,1,19)=(2955.73723389918_pr*c1*gA2)/(fpi4*mpi2)- &
         (978.581137073306_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.0364562451022012_pr*c4*gA2)/(fpi4*mpi2)
    ctJ1J1(2,1,19)=(-4606.79145692376_pr*c1*gA2)/(fpi4*mpi2)+ &
         (1486.71857443532_pr*c3*gA2)/(fpi4*mpi2)+ &
         (1.17040972364289_pr*c4*gA2)/(fpi4*mpi2)
    ctJ1J1(3,1,19)=(1575.92551413057_pr*c1*gA2)/(fpi4*mpi2)- &
         (499.689660100295_pr*c3*gA2)/(fpi4*mpi2)+ &
         (1.44343098521233_pr*c4*gA2)/(fpi4*mpi2)
    ctJ1J1(2,2,20)=(29.5882988459269_pr*c1*gA2)/(fpi4*mpi2)+ &
         (7.09242950510437_pr*c3*gA2)/(fpi4*mpi2)- &
         (1.16658987317766_pr*c4*gA2)/(fpi4*mpi2)
    ctJ1J1(1,1,21)=(1316.75994490306_pr*c1*gA2)/(fpi4*mpi2)- &
         (449.140719963059_pr*c3*gA2)/(fpi4*mpi2)
    ctJ1J1(2,1,21)=(-2611.74143695995_pr*c1*gA2)/(fpi4*mpi2)+ &
         (874.719811383881_pr*c3*gA2)/(fpi4*mpi2)- &
         (0.0182281225511006_pr*c4*gA2)/(fpi4*mpi2)
    ctJ1J1(3,1,21)=(1112.6598731875_pr*c1*gA2)/(fpi4*mpi2)- &
         (369.221981860559_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.14990328347683_pr*c4*gA2)/(fpi4*mpi2)
    ctJ1J1(1,1,23)=(380.945590073708_pr*c1*gA2)/(fpi4*mpi2)- &
         (133.736494553329_pr*c3*gA2)/(fpi4*mpi2)
    ctJ1J1(2,1,23)=(-1001.70799803_pr*c1*gA2)/(fpi4*mpi2)+ &
         (344.82175777492_pr*c3*gA2)/(fpi4*mpi2)
    ctJ1J1(3,1,23)=(545.279167261999_pr*c1*gA2)/(fpi4*mpi2)- &
         (184.448333224776_pr*c3*gA2)/(fpi4*mpi2)+ &
         (0.00227851531888757_pr*c4*gA2)/(fpi4*mpi2)
    ctJ1J1(1,1,25)=(69.0578717312122_pr*c1*gA2)/(fpi4*mpi2)- &
         (24.8647925755186_pr*c3*gA2)/(fpi4*mpi2)
    ctJ1J1(2,1,25)=(-255.206744216776_pr*c1*gA2)/(fpi4*mpi2)+ &
         (90.1447936087768_pr*c3*gA2)/(fpi4*mpi2)
    ctJ1J1(3,1,25)=(183.267451552542_pr*c1*gA2)/(fpi4*mpi2)- &
         (63.5695102280704_pr*c3*gA2)/(fpi4*mpi2)
    ctJ1J1(1,1,27)=(7.12383882476366_pr*c1*gA2)/(fpi4*mpi2)- &
         (2.62160304250119_pr*c3*gA2)/(fpi4*mpi2)
    ctJ1J1(2,1,27)=(-41.4401230244268_pr*c1*gA2)/(fpi4*mpi2)+ &
         (14.97425477113_pr*c3*gA2)/(fpi4*mpi2)
    ctJ1J1(3,1,27)=(41.6672205478068_pr*c1*gA2)/(fpi4*mpi2)- &
         (14.7931959736712_pr*c3*gA2)/(fpi4*mpi2)
    ctJ1J1(1,1,29)=(0.318977498914416_pr*c1*gA2)/(fpi4*mpi2)- &
         (0.119616838695711_pr*c3*gA2)/(fpi4*mpi2)
    ctJ1J1(2,1,29)=(-3.88089691129625_pr*c1*gA2)/(fpi4*mpi2)+ &
         (1.43041835994631_pr*c3*gA2)/(fpi4*mpi2)
    ctJ1J1(3,1,29)=(6.12365814763455_pr*c1*gA2)/(fpi4*mpi2)- &
         (2.21941836648652_pr*c3*gA2)/(fpi4*mpi2)
    ctJ1J1(2,1,31)=(-0.159488749457208_pr*c1*gA2)/(fpi4*mpi2)+ &
         (0.0598084193478553_pr*c3*gA2)/(fpi4*mpi2)
    ctJ1J1(3,1,31)=(0.524984301276333_pr*c1*gA2)/(fpi4*mpi2)- &
         (0.193754399830252_pr*c3*gA2)/(fpi4*mpi2)
    ctJ1J1(3,1,33)=(0.019936093682151_pr*c1*gA2)/(fpi4*mpi2)- &
         (0.00747605241848192_pr*c3*gA2)/(fpi4*mpi2)
  End Subroutine load_tables
  !==================================================================================
  !
  !==================================================================================
  Subroutine set_functional_parameters(fname,lpr)
    !--------------------------------------------------------------------------------
    ! RESERVED NAMES ARE:
    !  -namelist forbiden:
    !          'UNRDF'  - best UNEDF
    !          'SKYRME' - best SKYRME
    !  -namelist inforced but not for C-parameters (use_INM=F) 
    !   or NM-parameters (use_INM=T) defined by the solver 
    !          'FITS'   
    !  -namelist inforced (one can overwrite all):
    !          'ANY OTHER NAME' 
    ! i.e., the DME solver defines C-/NM- only using 'FITS'
    !--------------------------------------------------------------------------------
    Implicit None
    Logical, Intent(in) :: lpr
    Character (30), Intent(inout) :: fname 
    Character (30) :: inforcedname     
    Logical :: regularization
    Logical :: use_INM,use_Namelist
    Integer(ipr), Parameter :: lin=15,lout=6,lnamelist=16 
    Real(pr), Dimension(0:1) :: FCrho,FCdrho,FCtau,FCrDr,FCrdJ,FCJ,FCpV0,FCpV1
    Real(pr) :: Fhbzero,Fsigma,Fe2charg
    Real(pr) :: FE_NM,FK_NM,FSMASS_NM,FRHO_NM,FASS_NM,FLASS_NM,FVMASS_NM
    Namelist /UNEDF_NAMELIST/ FunctionalName,DMEorder,DMElda,use_INM,hbzero, &
         Crho,Cdrho,Ctau,CrDr,CrdJ,CJ,sigma,CpV0,CpV1,e2charg, &
         E_NM,K_NM,SMASS_NM,RHO_NM,ASS_NM,LASS_NM,VMASS_NM, &
         mpi,gA,fpi,c1,c3,c4,cd,ce,LambdaX, &
         use_cm_cor,use_charge_density,use_DME3N_terms,use_j2terms,CExPar, &
         Print_Namelist   
    Open(lnamelist,file='UNEDF_NAMELIST.DAT',DELIM='APOSTROPHE') ! 'QUOTE' 
    !
    ! parameters
    use_DME3N_terms = .True.
    eps=Spacing(1.0_pr)
    Pi=4.0_pr*Atan(1.0_pr)  
    kfconst=(1.50_pr*Pi**2)**(1.0_pr/3.0_pr)    ! (3Pi^2/2)^(1/3)
    CK=3.0_pr/5.0_pr*kfconst**2
    !
    !==========================
    ! STORE OPTIMIZATION VALUES
    !==========================
    If(Trim(fname).Eq.'FITS') Then
       FCrho=Crho;     FCdrho=Cdrho;     FCtau=Ctau
       FCrDr=CrDr;     FCrdJ=CrdJ;       FCJ=CJ
       FCpV0=CpV0;     FCpV1=CpV1;       
       Fsigma=sigma;   Fhbzero=hbzero
       FE_NM=E_NM;     FK_NM=K_NM;       FSMASS_NM=SMASS_NM; FRHO_NM=RHO_NM
       FASS_NM=ASS_NM; FLASS_NM=LASS_NM; FVMASS_NM=VMASS_NM; 
       Fsigma=sigma;   Fhbzero=hbzero;   Fe2charg=e2charg
    Endif
    Do  
       !==================================  
       ! SOME DEFAULT VALUSE FOR ALL CASES  
       !==================================  
       Print_Namelist=.True.
       FunctionalName="Bla-Bla"
       use_charge_density=.False.
       regularization=.False.
       use_cm_cor=.True. 
       use_j2terms = .True.
       DMEorder=2 
       DMElda=0
       Crho(0)=-727.0933239596374733_pr; Crho(1)=474.8709969984467989_pr 
       CDrho(0)=612.1037411660222460_pr; CDrho(1)=-705.7204872069220301_pr
       Ctau(0)=33.8846741217252401_pr;   Ctau(1)=32.4047409594248919_pr
       CrDr(0)=-76.9962031249999939_pr;  CrDr(1)=15.6571351249999999_pr
       CrdJ(0)=-92.2500000000000000_pr;  CrdJ(1)=-30.7500000000000000_pr
       CJ(0)=17.2096115000000012_pr;     CJ(1)=64.5758124999999978_pr
       Cnrho=0.0_pr;                     CJdr=0.0_pr
       CpV0=-258.20_pr;                  CpV1=0.50_pr
       sigma=0.3062227576210547_pr;     
       hbzero=20.7355300000000007_pr;    
       e2charg = 1.43997840_pr ; CExPar = 1.0_pr
       mpi=138.03_pr/197.3_pr; fpi=92.4_pr/197.3_pr; gA=1.29_pr
       c1=-0.81_pr/1000.0_pr*197.3_pr
       c3=-3.4_pr/1000.0_pr*197.3_pr
       c4= 3.4_pr/1000.0_pr*197.3_pr
       cd=-2062.0_pr/1000.0_pr
       ce=-625.0_pr/1000.0_pr
       LambdaX=700.0_pr/197.3_pr
       E_NM=-15.972149141444596410_pr;  RHO_NM=0.159538756711733398_pr 
       K_NM=229.900964482603626493_pr;  SMASS_NM=1.439546988976078357_pr 
       ASS_NM=32.004302815052007247_pr; LASS_NM=45.961751480461579433_pr 
       VMASS_NM=1.249838547196253424_pr
       nuLambda=700.0_pr ; nufpi = 93.0_pr
       !======================
       ! SELECT THE FUNCTIONAL
       !======================
       FUNCTIONAL: Select Case (Trim(fname))
       Case ('UNEDF')
          inforcedname='UNEDF'
          use_INM=.True. 
          use_Namelist=.False.
          ! kind of the functional
          use_charge_density=.False.
          regularization=.False.
          use_cm_cor=.True. 
          DMEorder=2
          DMElda=0
          ! Best DME parameters up to date
          Crho(0)=-727.0933239596374733_pr;  Crho(1)=474.8709969984467989_pr
          CDrho(0)=612.1037411660222460_pr;  CDrho(1)=-705.7204872069220301_pr
          Ctau(0)=33.8846741217252401_pr;    Ctau(1)=32.4047409594248919_pr
          CrDr(0)=-76.9962031249999939_pr;   CrDr(1)=15.6571351249999999_pr
          CrdJ(0)=-92.2500000000000000_pr;   CrdJ(1)=-30.7500000000000000_pr
          CJ(0)=17.2096115000000012_pr;      CJ(1)=64.5758124999999978_pr
          Cnrho=0.0_pr;                      CJdr=0.0_pr      
          CpV0=-258.20_pr;                   CpV1=0.50_pr
          sigma=0.3062227576210547_pr;     
          hbzero=20.7355300000000007_pr;    
          e2charg = 1.43997840_pr
          ! Associated NN and NNN parameters
          mpi=138.03_pr/197.3_pr; fpi=92.4_pr/197.3_pr; gA=1.29_pr
          c1=-0.81_pr/1000.0_pr*197.3_pr
          c3=-3.4_pr/1000.0_pr*197.3_pr
          c4= 3.4_pr/1000.0_pr*197.3_pr
          cd=-2062.0_pr/1000.0_pr
          ce=-625.0_pr/1000.0_pr
          LambdaX=700.0_pr/197.3_pr
          ! Associated INM parameters
          E_NM=-15.972149141444596410_pr;  RHO_NM=0.159538756711733398_pr  
          K_NM=229.900964482603626493_pr;  SMASS_NM=1.439546988976078357_pr       
          ASS_NM=32.004302815052007247_pr; LASS_NM=45.961751480461579433_pr 
          VMASS_NM=1.249838547196253424_pr 
       Case ("SKYRME")
          inforcedname='SKYRME'
          use_Namelist=.False.
          ! kind of the functional
          use_charge_density=.False.
          regularization=.False.
          use_cm_cor=.True. 
          DMEorder=-1
          DMElda=0
          ! Best SKYRME parameters up to date
          hbzero=20.735530_pr;               sigma=0.1666666666666667_pr    
          Crho(0)=-933.3423749999999472_pr;  Crho(1)=830.0524855000001025_pr
          CDrho(0)=861.0625000000000000_pr;  CDrho(1)=-1064.2732499999999618_pr
          Ctau(0)=57.1286874999999981_pr;    Ctau(1)=24.6567364999999974_pr
          CrDr(0)=-76.9962031249999939_pr;   CrDr(1)=15.6571351249999999_pr 
          CrdJ(0)=-92.2500000000000000_pr;   CrdJ(1)=-30.7500000000000000_pr
          CJ(0)=17.2096115000000012_pr;      CJ(1)=64.5758124999999978_pr
          Cnrho=0.0_pr;                      CJdr=0.0_pr       
          CpV0=-258.20_pr;                   CpV1=0.50_pr
          sigma=0.1666666666666667_pr;     
          hbzero=20.7355300000000007_pr;    
          e2charg = 1.43997840_pr
          ! Associated INM parameters
          E_NM=-15.972149141444596410_pr;   RHO_NM=0.159538756711733398_pr 
          K_NM=229.900964482603626493_pr;   SMASS_NM=1.439546988976078357_pr 
          ASS_NM=32.004302815052007247_pr;  LASS_NM=45.961751480461579433_pr 
          VMASS_NM=1.249838547196253424_pr 
       Case ("FITS")
          inforcedname='FITS'
          use_Namelist=.True.
          use_INM=.False.
       Case default
          inforcedname=fname
          use_Namelist=.True.
          use_INM=.True.
       End Select FUNCTIONAL
       !======================
       ! READ NAMELISTS     
       !======================
       If(.Not.use_Namelist) Exit
       Read(UNIT=lnamelist,NML=UNEDF_NAMELIST,Err=200,End=100)
       If(Trim(FunctionalName).Eq.Trim(inforcedname)) Exit
    Enddo
100 Continue
    Close(lnamelist)
    !
    !================================
    ! SEE WHAT THE NAMELISTS MODIFIED    
    !================================
    INFORCED_FUNCTIONAL: Select Case (Trim(inforcedname))
    Case ("UNEDF")
       FunctionalName='UNEDF'
    Case ("SKYRME")
       FunctionalName='SKYRME'
    Case ("FITS")
       ! Restore all defined by the DME solver (modify later for use_INM)
       FunctionalName='FITS'
       Crho=FCrho;     Cdrho=FCdrho;     Ctau=FCtau
       CrDr=FCrDr;     CrdJ=FCrdJ;       CJ=FCJ
       CpV0=FCpV0;     CpV1=FCpV1;     
       sigma=Fsigma;   hbzero=Fhbzero;   e2charg=Fe2charg
       E_NM=FE_NM;     K_NM=FK_NM;       SMASS_NM=FSMASS_NM; RHO_NM=FRHO_NM
       ASS_NM=FASS_NM; LASS_NM=FLASS_NM; VMASS_NM=FVMASS_NM; 
    Case default
       ! MISSING ENTRY WITHIN UNEDF_NAMELIST.DAT FILE
       If(Trim(FunctionalName).Ne.Trim(inforcedname)) Then
          Write(LOUT,'(1X,/,A)') 'ATTENTION: MISSING INPUT!'      
          Write(LOUT,*) 'THE INPUT DATA WITH LABEL FUNCTIONALNAME=''',Trim(INFORCEDNAME),''''
          Write(LOUT,*) 'IS MISSING INSIDE THE UNEDF_NAMELIST.DAT FILE.'      
          Write(LOUT,*) 'PLESE CORECT AND TRY AGAIN!'      
          Stop 'PROGRAM STOP IN SET_FUNCTIONAL_PARAMETERS'  
       Endif 
    End Select INFORCED_FUNCTIONAL
    !  
    Call Make_Parameter_Free_Useful_Combintions()
    !
    ! exact Hartree CHrho from INM
    CHrho=0.0_pr; !!!!If (dmeorder.eq.3) Call CHrho_from_NM()
    !
    If(use_INM) then 
     Call calculate_C_form_NM(E_NM,K_NM,SMASS_NM,RHO_NM,ASS_NM,LASS_NM,VMASS_NM)
    Else
     Crho(0)=Crho(0)+CHrho                       !*(0.0_pr) !mario
    End if
    Call calculate_NM_properties()   
    !
    Crho(0)=Crho(0)-CHrho                        !*(0.00_pr) !mario
    !
    Call calculate_natural_units()
    !
    ! Print output
    If(lpr) Then
     Call print_functional_parameters(lout)
     If(Print_Namelist) Write (lout, UNEDF_NAMELIST)
    Endif 
    !
    Return
    !
200 Continue 
    ! WRONG ENTRY WITHIN UNEDF_NAMELIST.DAT FILE
    Write(LOUT,'(1X,/,A)') 'ATTENTION: WRONG INPUT!'      
    Write(LOUT,*) 'THE INPUT DATA WITH LABEL FUNCTIONALNAME=''',Trim(INFORCEDNAME),''''
    Write(LOUT,*) 'INSIDE THE UNEDF_NAMELIST.DAT FILE IS WRONG.'      
    Write(LOUT,*) 'PLESE CORECT AND TRY AGAIN!'      
    Stop 'PROGRAM STOP IN SET_FUNCTIONAL_PARAMETERS'  
  End Subroutine set_functional_parameters       
  !==================================================================================
  !          
  !==================================================================================
  Subroutine print_functional_parameters(lout)         
    !--------------------------------------------------------------------------------
    Implicit None
    Integer(ipr), Intent(in) :: lout 
    !
    Write(lout,'(a)')   '  ---------------------------------------'
    Write(lout,'(a,a)') '           UNEDF Module Version:', &
                                         Trim(Version)    
    Write(lout,'(a)')   '         M.Kortelainen & M.Stoitsov ' 
    Write(lout,'(a)')   '  ---------------------------------------'
    
    
    Write(lout,'(a)')    
    Write(lout,'(100(2x,a,a,f15.8))') Trim(FunctionalName),' functional'
    Write(lout,'(100(2x,a,f15.8))') '----------------------------------'
    Write(lout,'("  Crho(0)= ",g26.18,"; Crho(1)= ",g26.18)') Crho
    Write(lout,'("  CDrho(0)=",g26.18,"; CDrho(1)=",g26.18)') CDrho
    Write(lout,'("  Ctau(0)= ",g26.18,"; Ctau(1)= ",g26.18)') Ctau
    Write(lout,'("  CrDr(0)= ",g26.18,"; CrDr(1)= ",g26.18)') Crdr
    Write(lout,'("  CrdJ(0)= ",g26.18,"; CrdJ(1)= ",g26.18)') CrdJ
    Write(lout,'("  CJ(0)=   ",g26.18,"; CJ(1)=   ",g26.18)') CJ
    Write(lout,'("  CpV0(0)= ",g26.18,"; CpV0(1)= ",g26.18)') CpV0
    Write(lout,'("  CpV1(0)= ",g26.18,"; CpV1(1)= ",g26.18)') CpV1
    Write(lout,'("  sigma=   ",g26.18,"; hbzero=  ",g26.18)') sigma,hbzero 
    Write(lout,'("  e^2 chrg=",g26.18,"; CExPar=  ",g26.18)') e2charg,CExPar
    Write(lout,'("  c.m. correction: ",L1,", chr. density in direct Coul: ",L1)') use_cm_cor,use_charge_density
    Write(lout,'("  use tensor terms: ",L1)') use_j2terms
        
    Write(lout,'(100(2x,a,f15.8))') 
    Write(lout,'(100(2x,a,f15.8))') 'Coupling constants in natural units'
    Write(lout,'(100(2x,a,f15.8))') '-----------------------------------'
    Write(lout,'("  Crho_nu(0)= ",g26.18,"; Crho_nu(1)= ",g26.18)') nuCrho
    Write(lout,'("  CDrho_nu(0)=",g26.18,"; CDrho_nu(1)=",g26.18)') nuCDrho
    Write(lout,'("  Ctau_nu(0)= ",g26.18,"; Ctau_nu(1)= ",g26.18)') nuCtau
    Write(lout,'("  CrDr_nu(0)= ",g26.18,"; CrDr_nu(1)= ",g26.18)') nuCrdr
    Write(lout,'("  CrdJ_nu(0)= ",g26.18,"; CrdJ_nu(1)= ",g26.18)') nuCrdJ
    Write(lout,'("  CJ_nu(0)=   ",g26.18,"; CJ_nu(1)=   ",g26.18)') nuCJ
    Write(lout,'("  CpV0_nu(0)= ",g26.18,"; CpV0_nu(1)= ",g26.18)') nuCpV0
    Write(lout,'("  CpV1_nu(0)= ",g26.18,"; CpV1_nu(1)= ",g26.18)') nuCpV1
    Write(lout,'("  fpi_nu=     ",g26.18,"; Lambda_nu=  ",g26.18)') nufpi,nuLambda
    
    If (dmeorder.Ge.0) Then
      Write(lout,'(100(2x,a,f15.8))') 
      Write(lout,'(100(2x,a,f15.8))') 'DME parameters'
      Write(lout,'(100(2x,a,f15.8))') '----------------------------------'
      Write(lout,'("       gA=",f12.6," mpi [1/fm]=",f12.6," fpi [1/fm]=",f12.6)') gA,mpi,fpi
      Write(lout,'("  c1 [fm]=",f12.6,"    c3 [fm]=",f12.6,"    c4 [fm]=",f12.6)') c1,c3,c4
      Write(lout,'("       cd=",f12.6,"         ce=",f12.6," LamX[1/fm]=",f12.6)') cd,ce,LambdaX
      Write(lout,'("  ->CHrho=",f12.6)') CHrho
      If (dmeorder.Ge.2) Write(lout,'("  use 3N terms: ",L1)') use_DME3N_terms
    End If
    
    Write(lout,'(100(2x,a,f15.8))') 
    Write(lout,'(100(2x,a,f15.8))') 'Nuclear matter properties'
    Write(lout,'(100(2x,a,f15.8))') '----------------------------------'
    Write(lout,'(100(2x,a9,f25.16))') 'E_NM=',E_NM,'K_NM=',K_NM
    Write(lout,'(100(2x,a9,f25.16))') 'P_NM=',P_NM,'RHO_NM=',RHO_NM
    Write(lout,'(100(2x,a9,f25.16))') 'ASS_NM=',ASS_NM,'LASS_NM=',LASS_NM
    Write(lout,'(100(2x,a9,f25.16))') 'SMASS_NM=',SMASS_NM,'VMASS_NM=',VMASS_NM
    
    Call t_from_C()
    Write(lout,'(100(2x,a,f15.8))') 
    Write(lout,'(100(2x,a,f15.8))') 'Associated (t,x)-coupling constants' 
    Write(lout,'(100(2x,a,f15.8))') '-----------------------------------'
    Write(lout,'("  t0=    ",g26.18,"; x0=     ",g26.18)') t0,x0
    Write(lout,'("  t1=    ",g26.18,"; x1=     ",g26.18)') t1,x1
    Write(lout,'("  t2=    ",g26.18,"; x2=     ",g26.18)') t2,x2
    Write(lout,'("  t3=    ",g26.18,"; x3=     ",g26.18)') t3,x3
    Write(lout,'("  b4=    ",g26.18,"; b4p=    ",g26.18)') b4,b4p
    Write(lout,'("  te=    ",g26.18,"; to=     ",g26.18)') te,to
    Write(lout,'("  sigma= ",g26.18,"; hbzero= ",g26.18)') sigma,hbzero
    
    If(Print_Namelist) Then
     Write(lout,'(100(2x,a,f15.8))') 
     SELECTED_FUNCTIONAL: Select Case (Trim(FunctionalName))
      Case ("UNEDF","SKYRME")
       Write(lout,'(100(2x,a,f15.8))') 'NAMELIST CONTENT (cannot be modified for functional names UNEDF,SKYRME)'
       Write(lout,'(100(2x,a,f15.8))') '-----------------------------------------------------------------------'
      Case ("FITS")
       Write(lout,'(100(2x,a,f15.8))') 'NAMELIST CONTENT (Advane usage: modify all but not C-, NM-, and more...)'
       Write(lout,'(100(2x,a,f15.8))') '-----------------------------------------------------------------------'
      Case default
       Write(lout,'(100(2x,a,f15.8))') 'NAMELIST CONTENT (copy/past to UNEDF_NAMELIST.dat and modify)'
       Write(lout,'(100(2x,a,f15.8))') '-------------------------------------------------------------'
     End Select SELECTED_FUNCTIONAL
     Write(lout,'(100(a,f15.8))')    ' !NB: FUNCTIONALNAME should be always in quotations'
    End If
  End Subroutine print_functional_parameters
  !==================================================================================
  !
  !==================================================================================
  Subroutine calculate_natural_units
    ! Calculates coupling constants in natural units
    !-----------------------------------------------------------------------------------
    Implicit None
    nuCrho = Crho*(nufpi**2)/(mevfm**3)
    nuCdrho = Cdrho*(nufpi**2)*((nuLambda*nufpi*nufpi)**sigma)/(mevfm**(3.0_pr*(1.0_pr+sigma)))
    nuCtau = Ctau*((nufpi*nuLambda)**2)/(mevfm**5)
    nuCrDr = CrDr*((nufpi*nuLambda)**2)/(mevfm**5)
    nuCrdJ = CrdJ*((nufpi*nuLambda)**2)/(mevfm**5)
    nuCJ = CJ*((nufpi*nuLambda)**2)/(mevfm**5)
    nuCpV0 = CpV0*(nufpi**2)/(mevfm**3)
    nuCpV1 = CpV1*(nufpi**4)*nuLambda/(mevfm**6)
  End Subroutine calculate_natural_units
  !==================================================================================
  ! 
  !==================================================================================
  Subroutine calculate_C_form_NM(E,K,SMASS,RHO,ASS,LASS,VMASS,sigma_NM)
    ! Calculates volume C-constants (and sigma) form NM properties
    ! Interface usage: 
    !  hbzero,CK,kfconst,mpi,sigma
    !  aRhoRho,bRhoRho...
    !  hRho0Rho0,dhRho0Rho0...
    !  Crho(0),Crho(1),Cdrho(0),Cdrho(1),Ctau(0),Ctau(0)
    !  subroutine calculate_U_parameters
    !
    !  input: E,K,SMASS,RHO,ASS,LASS,VMASS,sigma_NM(optional)
    ! output: Crho(0),Crho(1),Cdrho(0),Cdrho(1),Ctau(0),Ctau(0),sigma(optional)
    ! 
    ! Options:
    !  When sigma_NM exists then 'sigma'=sigma_NM
    !  When sigma_NM does not exist then 'sigma' is defined from NM
    !------------------------------------------------------------------
    Implicit None
    Real(pr), Intent(in) :: E,K,SMASS,RHO,ASS,LASS,VMASS
    Real(pr), Intent(in), Optional :: sigma_NM
    Real(pr) :: aRho0Rho0,daRho0Rho0,ddaRho0Rho0,aRho1Rho1,daRho1Rho1,ddaRho1Rho1
    Real(pr) :: aRho0Tau0,daRho0Tau0,ddaRho0Tau0,aRho1Tau1,daRho1Tau1,ddaRho1Tau1 
    Real(pr) :: u,tauc,rho2
    Real(pr),Parameter :: c13=1.0_pr/3.0_pr,c23=2.0_pr/3.0_pr
    !
    tauc=CK*RHO**c23; u=(kfconst/mpi)*RHO**c13; rho2=rho**2
    Call calculate_U_parameters(RHO,RHO,tauc*RHO,tauc*RHO,0.0_pr,0.0_pr)
    aRho0Rho0=0.50_pr*(aRhoRho+bRhoRho)*mevfm
    aRho1Rho1=0.50_pr*(aRhoRho-bRhoRho)*mevfm
    aRho0Tau0=0.50_pr*(aRhoTau+bRhoTau)*mevfm
    aRho1Tau1=0.50_pr*(aRhoTau-bRhoTau)*mevfm
    daRho0Rho0=0.50_pr*(daRhoRho+dbRhoRho)*mevfm
    daRho1Rho1=0.50_pr*(daRhoRho-dbRhoRho)*mevfm
    daRho0Tau0=0.50_pr*(daRhoTau+dbRhoTau)*mevfm
    daRho1Tau1=0.50_pr*(daRhoTau-dbRhoTau)*mevfm
    ddaRho0Rho0=0.50_pr*(ddaRhoRho+ddbRhoRho)*mevfm
    ddaRho1Rho1=0.50_pr*(ddaRhoRho-ddbRhoRho)*mevfm
    ddaRho0Tau0=0.50_pr*(ddaRhoTau+ddbRhoTau)*mevfm
    ddaRho1Tau1=0.50_pr*(ddaRhoTau-ddbRhoTau)*mevfm
    !
    ! set/calculate sigma
    If (Present(sigma_NM)) Then 
     sigma=sigma_NM 
    Else 
     sigma=((1.0_pr/3.0_pr)*(-K+tauc*hbzero*(-3.0_pr+4.0_pr*SMASS)-9.0_pr*E+9.0_pr*RHO2*hRho0Rho0 & 
             +21.0_pr*tauc*RHO2*hRho0Tau0+u*RHO*(daRho0Rho0+5.0_pr*tauc*daRho0Tau0 & 
             +7.0_pr*RHO*dhRho0Rho0+11.0_pr*tauc*RHO*dhRho0Tau0+u*ddaRho0Rho0 & 
             +u*tauc*ddaRho0Tau0+u*RHO*ddhRho0Rho0+u*tauc*RHO*ddhRho0Tau0))) & 
             /(tauc*hbzero*(-3.0_pr+2.0_pr*SMASS)+3.0_pr*E+3.0_pr*RHO2*hRho0Rho0 & 
             +3.0_pr*tauc*RHO2*hRho0Tau0+u*RHO*(daRho0Rho0+tauc*daRho0Tau0 & 
             + RHO*dhRho0Rho0+tauc*RHO*dhRho0Tau0)) 
    End If
    !  
    Crho(0)=(c13*(tauc*hbzero*(-3.0_pr+(2.0_pr-3.0_pr*sigma)*SMASS) &
        +3.0_pr*(1.0_pr+sigma)*E-3.0_pr*sigma*RHO*aRho0Rho0 &
        +3.0_pr*(1.0_pr-sigma)*RHO2*hRho0Rho0+3.0_pr*tauc*RHO2*hRho0Tau0 &
        +u*RHO*(daRho0Rho0+tauc*daRho0Tau0+RHO*dhRho0Rho0 &
        +tauc*RHO*dhRho0Tau0)))/(sigma*RHO)
    Cdrho(0)=(c13*RHO**(-1.0_pr-sigma)*(tauc*hbzero*(3.0_pr-2.0_pr*SMASS)&
        -3.0_pr*E-3.0_pr*RHO**2*hRho0Rho0-3.0_pr*tauc*RHO2*hRho0Tau0&
        -u*RHO*(daRho0Rho0+tauc*daRho0Tau0+RHO*dhRho0Rho0 &
        +tauc*RHO*dhRho0Tau0)))/sigma
    Ctau(0)=(hbzero*(SMASS-1.0_pr)-RHO*(aRho0Tau0+RHO*hRho0Tau0))/RHO
    !
    Crho(1)=(27.0_pr*ASS*(1.0_pr+sigma)-9.0_pr*LASS &
        +5.0_pr*tauc*hbzero*(5.0_pr-6.0_pr*VMASS+3.0_pr*sigma*(-4.0_pr+3.0_pr*VMASS)) &
        +20.0_pr*tauc*(2.0_pr-3.0_pr*sigma)*RHO*aRho0Tau0 &
        +RHO*(-27.0_pr*sigma*aRho1Rho1+5.0_pr*tauc*(11.0_pr-12.0_pr*sigma)*RHO*hRho0Tau0 &
        -27.0_pr*(-1.0_pr+sigma)*RHO*hRho1Rho1+9.0_pr*tauc*(5.0_pr-3.0_pr*sigma)*RHO*hRho1Tau0 &
        +45.0_pr*tauc*RHO*hRho1Tau1+40.0_pr*tauc*Ctau(0)-60.0_pr*tauc*sigma*Ctau(0) &
        +5.0_pr*u*tauc*daRho0Tau0+9.0_pr*u*daRho1Rho1+15.0_pr*u*tauc*daRho1Tau1 &
        +5.0_pr*u*tauc*RHO*dhRho0Tau0+9.0_pr*u*RHO*dhRho1Rho1+9.0_pr*u*tauc*RHO*dhRho1Tau0 &
        +15.0_pr*u*tauc*RHO*dhRho1Tau1))/(27.0_pr*sigma*RHO)
     Cdrho(1)=-(RHO**(-1.0_pr-sigma)*(27.0_pr*ASS-9.0_pr*LASS &
        +5.0_pr*tauc*hbzero*(5.0_pr-6.0_pr*VMASS)+40.0_pr*tauc*RHO*aRho0Tau0 &
        +55.0_pr*tauc*RHO2*hRho0Tau0+27.0_pr*RHO**2*hRho1Rho1+45.0_pr*tauc*RHO2*hRho1Tau0 &
        +45.0_pr*tauc*RHO2*hRho1Tau1+40.0_pr*tauc*RHO*Ctau(0) +5.0_pr*u*tauc*RHO*daRho0Tau0 &
        +9.0_pr*u*RHO*daRho1Rho1+15.0_pr*u*tauc*RHO*daRho1Tau1 &
        +5.0_pr*u*tauc*RHO2*dhRho0Tau0+9.0_pr*u*RHO2*dhRho1Rho1 &
        +9.0_pr*u*tauc*RHO2*dhRho1Tau0 +15.0_pr*u*tauc*RHO2*dhRho1Tau1))/(27.0_pr*sigma)
     Ctau(1)=(hbzero-hbzero*VMASS+RHO*(aRho0Tau0-aRho1Tau1+RHO*hRho0Tau0-RHO*hRho1Tau1+Ctau(0)))/RHO
     !
  End Subroutine calculate_C_form_NM
  !==================================================================================
  !
  !==================================================================================
  Subroutine calculate_NM_properties()
    ! Calculates INM properties
    ! Interface usage: 
    !  hbzero,CK,kfconst,mpi,sigma
    !  aRhoRho,bRhoRho...
    !  hRho0Rho0,dhRho0Rho0...
    !  Crho(0),Crho(1),Cdrho(0),Cdrho(1),Ctau(0),Ctau(0)
    !  E_NM,K_NM,SMASS_NM,RHO_NM,ASS_NM,LASS_NM,VMASS_NM,sigma,P_NM,KA_NM
    !  function find_NM_RHOC()
    ! input:  Crho(0),Crho(1),Cdrho(0),Cdrho(1),Ctau(0),Ctau(0),sigma
    ! output: E_NM,K_NM,SMASS_NM,RHO_NM,ASS_NM,LASS_NM,VMASS_NM,sigma,P_NM,KA_NM
    ! Using:
    !  RHO_NM=find_NM_RHOC()
    !------------------------------------------------------------------ 
    Implicit None
    Real(pr) :: aRho0Rho0,daRho0Rho0,ddaRho0Rho0,aRho1Rho1,daRho1Rho1,ddaRho1Rho1
    Real(pr) :: aRho0Tau0,daRho0Tau0,ddaRho0Tau0,aRho1Tau1,daRho1Tau1,ddaRho1Tau1 
    Real(pr) :: u,tauc,rho_NM2
    Real(pr), Parameter :: c13=1.0_pr/3.0_pr,c23=2.0_pr/3.0_pr
    !
    RHO_NM=find_NM_RHOC()
    !
    aRho0Rho0=0.50_pr*(aRhoRho+bRhoRho)*mevfm
    aRho1Rho1=0.50_pr*(aRhoRho-bRhoRho)*mevfm
    aRho0Tau0=0.50_pr*(aRhoTau+bRhoTau)*mevfm
    aRho1Tau1=0.50_pr*(aRhoTau-bRhoTau)*mevfm
    daRho0Rho0=0.50_pr*(daRhoRho+dbRhoRho)*mevfm
    daRho1Rho1=0.50_pr*(daRhoRho-dbRhoRho)*mevfm
    daRho0Tau0=0.50_pr*(daRhoTau+dbRhoTau)*mevfm
    daRho1Tau1=0.50_pr*(daRhoTau-dbRhoTau)*mevfm
    ddaRho0Rho0=0.50_pr*(ddaRhoRho+ddbRhoRho)*mevfm
    ddaRho1Rho1=0.50_pr*(ddaRhoRho-ddbRhoRho)*mevfm
    ddaRho0Tau0=0.50_pr*(ddaRhoTau+ddbRhoTau)*mevfm
    ddaRho1Tau1=0.50_pr*(ddaRhoTau-ddbRhoTau)*mevfm
    tauc=CK*RHO_NM**c23; u=(kfconst/mpi)*RHO_NM**c13; rho_NM2=rho_NM**2
    !
    ! Symmetric Nuclear Matter 
    E_NM=tauc*hbzero+RHO_NM*(aRho0Rho0+RHO_NM*hRho0Rho0+Crho(0)+RHO_NM**sigma*Cdrho(0)) &
      +tauc*RHO_NM*(aRho0Tau0+RHO_NM*hRho0Tau0+Ctau(0))
    P_NM=c13*RHO_NM**2*((2.0_pr*tauc*hbzero)/RHO_NM+3.0_pr*aRho0Rho0+5.0_pr*tauc*aRho0Tau0 &
      +6.0_pr*RHO_NM*hRho0Rho0+8.0_pr*tauc*RHO_NM*hRho0Tau0+3.0_pr*Crho(0) &
      +3.0_pr*(1+sigma)*RHO_NM**sigma*Cdrho(0)+5.0_pr*tauc*Ctau(0)+u*daRho0Rho0 &
      +u*tauc*daRho0Tau0+u*RHO_NM*dhRho0Rho0+u*tauc*RHO_NM*dhRho0Tau0)
    SMASS_NM=1.0_pr+(RHO_NM*(aRho0Tau0+RHO_NM*hRho0Tau0+Ctau(0)))/hbzero
    K_NM=9.0_pr*sigma*(1+sigma)*RHO_NM**(1+sigma)*Cdrho(0) &
      +(-2.0_pr*tauc*hbzero+10.0_pr*tauc*RHO_NM*aRho0Tau0+18.0_pr*RHO_NM2*hRho0Rho0 &
      +40.0_pr*tauc*RHO_NM**2*hRho0Tau0+4.0_pr*u*RHO_NM*daRho0Rho0 & 
      +RHO_NM*(10.0_pr*tauc*Ctau(0)+u*(8.0_pr*tauc*daRho0Tau0+u*ddaRho0Rho0 &
      +(10.0_pr*RHO_NM*dhRho0Rho0+14.0_pr*tauc*RHO_NM*dhRho0Tau0 &
      +(u*tauc*ddaRho0Tau0+u*RHO_NM*ddhRho0Rho0+u*tauc*RHO_NM*ddhRho0Tau0)))))
    ! 
    ! Asymmetric Nuclear Matter 
    ASS_NM=RHO_NM2*hRho1Rho1+RHO_NM*(aRho1Rho1+Crho(1)+RHO_NM**sigma*Cdrho(1)) &
       +(tauc*(5.0_pr*hbzero+RHO_NM*(5.0_pr*aRho0Tau0+15.0_pr*aRho1Tau1+5.0_pr*RHO_NM*hRho0Tau0 &
       +9.0_pr*RHO_NM*hRho1Tau0+5.0_pr*(3.0_pr*RHO_NM*hRho1Tau1+Ctau(0)+3.0_pr*Ctau(1)))))/9.0_pr
    VMASS_NM=(hbzero+RHO_NM*(aRho0Tau0-aRho1Tau1+RHO_NM*hRho0Tau0-RHO_NM*hRho1Tau1+Ctau(0)-Ctau(1)))/hbzero
    LASS_NM=6.0_pr*RHO_NM2*hRho1Rho1+3.0_pr*RHO_NM*(aRho1Rho1+Crho(1)+(1.0_pr+sigma)*RHO_NM**sigma*Cdrho(1)) &
       +u*RHO_NM*daRho1Rho1 +u*RHO_NM2*dhRho1Rho1 &
       +(tauc*(10.0_pr*hbzero+8.0_pr*RHO_NM2*(5.0_pr*hRho0Tau0+9.0_pr*hRho1Tau0+15.0_pr*hRho1Tau1) &
       +25.0_pr*RHO_NM*(aRho0Tau0+3.0_pr*aRho1Tau1+Ctau(0)+3*Ctau(1)) &
       +5.0_pr*u*RHO_NM*(daRho0Tau0+3.0_pr*daRho1Tau1) &
       +u*RHO_NM2*(5.0_pr*dhRho0Tau0+9.0_pr*dhRho1Tau0+15.0_pr*dhRho1Tau1)))/9.0_pr
    KA_NM=18.0_pr*RHO_NM2*hRho1Rho1+9.0_pr*sigma*(1.0_pr+sigma)*RHO_NM**(1.0_pr+sigma)*Cdrho(1) &
       +4.0_pr*u*RHO_NM*daRho1Rho1 +10.0_pr*u*RHO_NM2*dhRho1Rho1 &
       + u**2*RHO_NM*ddaRho1Rho1+u**2*RHO_NM2*ddhRho1Rho1 &
       +(tauc*(-10.0_pr*hbzero+40.0_pr*RHO_NM2*(5.0_pr*hRho0Tau0+9.0_pr*hRho1Tau0+15.0_pr*hRho1Tau1) &
       +50.0_pr*RHO_NM*(aRho0Tau0+3.0_pr*aRho1Tau1+Ctau(0)+3*Ctau(1)) &
       +40.0_pr*u*RHO_NM*(daRho0Tau0+3.0_pr*daRho1Tau1) &
       +14.0_pr*u*RHO_NM2*(5.0_pr*dhRho0Tau0+9.0_pr*dhRho1Tau0 &
       +15.0_pr*dhRho1Tau1)+5.0_pr*u**2*RHO_NM*(ddaRho0Tau0 &
       +3.0_pr*ddaRho1Tau1)+u**2*RHO_NM2*(5.0_pr*ddhRho0Tau0+9*ddhRho1Tau0+15*ddhRho1Tau1)))/9.
     !       
  End Subroutine calculate_NM_properties
  !==================================================================================  
  !
  !=======================================================================
  Function find_NM_RHOC()
    ! Search for the INM saturation density RHO_NM using the Secant Method
    !====================================================================
    Implicit None
    !Integer(pr) intent(out) :: ierr
    Integer(pr) :: iter
    Real(pr) :: aRho0Rho0,daRho0Rho0,ddaRho0Rho0,aRho1Rho1,daRho1Rho1,ddaRho1Rho1
    Real(pr) :: aRho0Tau0,daRho0Tau0,ddaRho0Tau0,aRho1Tau1,daRho1Tau1,ddaRho1Tau1 
    Real(pr) :: find_NM_RHOC,kfconstmpi,u,tauc
    Real(pr) :: rhom0,rhom,rhom2,w,w0,step,energy
    Real(pr),Parameter :: c13=1.0_pr/3.0_pr,c23=2.0_pr/3.0_pr
    !
    kfconstmpi=kfconst/mpi; step=-0.0010_pr; iter=0
    ! initial point
    rhom=0.170_pr; tauc=CK*rhom**c23; u=kfconstmpi*rhom**c13; rhom2=rhom**2
    Call calculate_U_parameters(rhom,rhom,tauc*rhom,tauc*rhom,0.0_pr,0.0_pr)
    aRho0Rho0=0.50_pr*(aRhoRho+bRhoRho)*mevfm; daRho0Rho0=0.50_pr*(daRhoRho+dbRhoRho)*mevfm
    aRho0Tau0=0.50_pr*(aRhoTau+bRhoTau)*mevfm; daRho0Tau0=0.50_pr*(daRhoTau+dbRhoTau)*mevfm
    w0=c13*rhom2*((2.0_pr*tauc*hbzero)/rhom+3.0_pr*aRho0Rho0+5.0_pr*tauc*aRho0Tau0 &
      +6.0_pr*rhom*hRho0Rho0+8.0_pr*tauc*rhom*hRho0Tau0+3.0_pr*Crho(0) &
      +3.0_pr*(1.0_pr+sigma)*rhom**sigma*Cdrho(0)+5.0_pr*tauc*Ctau(0)+u*daRho0Rho0 &
      +u*tauc*daRho0Tau0+u*rhom*dhRho0Rho0+u*tauc*rhom*dhRho0Tau0)
    rhom0=rhom; rhom=rhom+step
    !	
    ! secant method
    Do While(Abs(step).Ge.eps*100.0_pr)
       iter=iter+1
       tauc=CK*rhom**c23; u=kfconstmpi*rhom**c13; rhom2=rhom**2
       Call calculate_U_parameters(rhom,rhom,tauc*rhom,tauc*rhom,0.0_pr,0.0_pr)
       aRho0Rho0=0.50_pr*(aRhoRho+bRhoRho)*mevfm; daRho0Rho0=0.50_pr*(daRhoRho+dbRhoRho)*mevfm
       aRho0Tau0=0.50_pr*(aRhoTau+bRhoTau)*mevfm; daRho0Tau0=0.50_pr*(daRhoTau+dbRhoTau)*mevfm
       w=c13*rhom2*((2.0_pr*tauc*hbzero)/rhom+3.0_pr*aRho0Rho0+5.0_pr*tauc*aRho0Tau0 &
         +6.0_pr*rhom*hRho0Rho0+8.0_pr*tauc*rhom*hRho0Tau0+3.0_pr*Crho(0) &
         +3.0_pr*(1.0_pr+sigma)*rhom**sigma*Cdrho(0)+5.0_pr*tauc*Ctau(0)+u*daRho0Rho0 &
         +u*tauc*daRho0Tau0+u*rhom*dhRho0Rho0+u*tauc*rhom*dhRho0Tau0)
       step=-w*(rhom-rhom0)/(w-w0)
       rhom0=rhom; w0=w; rhom=rhom+step       
       If(iter.Gt.100) Stop 'STOP(In find_NM_RHOC)'
       !energy=tauc*hbzero+rhom*(aRho0Rho0+rhom*hRho0Rho0+Crho(0)+rhom**sigma*Cdrho(0)) &
       ! +tauc*rhom*(aRho0Tau0+rhom*hRho0Tau0+Ctau(0))        
       !write(6,'(a,15(1pg12.4))') ' rhom0,rhom,step,e,w=',rhom0,rhom,step,energy,w
    Enddo
    find_NM_RHOC=rhom
  End Function find_NM_RHOC
  !==================================================================================
  !
  !==================================================================================
  Subroutine C_from_t()
    !--------------------------------------------------------------------------------
    ! C- from (t,x)-
    !--------------------------------------------------------------------------------
    Implicit None
     Crho(0) =  3.0_pr/8.0_pr*t0                            
     Cdrho(0) =  (1.0_pr/16.0_pr)*t3
     Crho(1) = -(1.0_pr/4.0_pr)*t0*(0.50_pr+x0)   
     Cdrho(1) = -(1.0_pr/24.0_pr)*t3*(0.50_pr+x3)   
     Ctau(0)  =  (3.0_pr/16.0_pr)*t1+(1.0_pr/4.0_pr)*t2*(5.0_pr/4.0_pr+x2)   
     Ctau(1)  = -(1.0_pr/8.0_pr)*t1*(0.5+x1)+(1.0_pr/8.0_pr)*t2*(0.50_pr+x2)   
     CrDr(0) =  (1.0_pr/16.0_pr)*t2*(5.0_pr/4.0_pr+x2)-(9.0_pr/64.0_pr)*t1
     CrDr(1) =  (3.0_pr/32.0_pr)*t1*(0.5+x1)+(1.0_pr/32.0_pr)*t2*(0.50_pr+x2)   
     CJ(0)    = -(1.0_pr/16.0_pr)*(t1*(2.0_pr*x1-1.0_pr)+t2*(2.0_pr*x2+1)-5*te-15*to)
     CJ(1)    = -(1.0_pr/16.0_pr)*(t2 -t1 + 5.0_pr*te -5.0_pr*to )
     CrdJ(0)   = -b4-(0.50_pr)*b4p              
     CrdJ(1)   = -0.50_pr*b4p                       
  End Subroutine C_from_t
  !==================================================================================
  !
  !==================================================================================
  Subroutine t_from_C()
    !--------------------------------------------------------------------------------
    ! (t,x)- from C-
    !--------------------------------------------------------------------------------
    Implicit None
    t0     =  (8.0_pr/3)*Crho(0)
    t1     =  4.0_pr/3.0_pr*(Ctau(0)-4.0_pr*CrDr(0))         
    t2     =  4.0_pr/3.0_pr*(3.0_pr*Ctau(0)-6.0_pr*Ctau(1)+4.0_pr*CrDr(0)-8.0_pr*CrDr(1))  
    t3     =  16.0_pr*Cdrho(0)
    x0     = -0.50_pr*(3.0_pr*Crho(1)/Crho(0)+1.0_pr)   
    x1     =  2.0_pr*(-Ctau(0)-3.0_pr*Ctau(1)+4.0_pr*CrDr(0)+12.0_pr*CrDr(1))/t1/3.0_pr
    x2     = -2.0_pr*(3.0_pr*Ctau(0)-15.0_pr*Ctau(1)+4.0_pr*CrDr(0)-20.0_pr*CrDr(1))/t2/3.0_pr
    x3     = -0.50_pr*(3.0_pr*Cdrho(1)/Cdrho(0)+1.0_pr) 
    b4     =  CrdJ(1)-CrdJ(0)
    b4p    = -2.0_pr*CrdJ(1)
    te     = (4.0_pr/15.0_pr)*(3.0_pr*CJ(0)-9.0_pr*CJ(1)-4.0_pr*CrDr(0)+12.0_pr*CrDr(1)-2.0_pr*Ctau(0)+6.0_pr*Ctau(1))
    to     = (4.0_pr/15.0_pr)*(3.0_pr*CJ(0)+3.0_pr*CJ(1)+4.0_pr*CrDr(0)+4.0_pr*CrDr(1))
  End Subroutine t_from_C
  !==================================================================================
  !   
  !==================================================================================
  Subroutine CHrho_from_NM()
    !--------------------------------------------------------------------------------
    ! CHrho from NM, E_NM(Hartree)=CHrho*RHO_NM
    !--------------------------------------------------------------------------------
    Implicit None
	Real(pr) :: z3=1.50_pr
        !
        !!CHrho= & 
        !!+h0mpi6c3NM*(A3_1/b3_1**z3+A3_2/b3_2**z3+A3_3/b3_3**z3+A3_4/b3_4**z3+A3_5/b3_5**z3) &
        !!+h0mpi6c1NM*(A1_1/b1_1**z3+A1_2/b1_2**z3+A1_3/b1_3**z3+A1_4/b1_4**z3+A1_5/b1_5**z3)
        CHrho = 0.0_pr
        !
  End Subroutine CHrho_from_NM
  !==================================================================================
  !
  !==================================================================================
  Elemental Function HartreeV00(u)
    !--------------------------------------------------------------------------------
    ! HartreeV(u), E(Hartree)=(1/2)*Int[rho_0(r)*V(|r-r'|)*rho_0(r')]
    !--------------------------------------------------------------------------------
    Implicit None
	Real(pr), Intent(in) :: u 
	Real(pr)             :: x2,HartreeV00 
        !
        !!x2=(u*mpi)**2
	!
        !!HartreeV=h0mpi6c1*(Exp(-x2*b1_1)*A1_1+Exp(-x2*b1_2)*A1_2+Exp(-x2*b1_3)*A1_3+Exp(-x2*b1_4)*A1_4+Exp(-x2*b1_5)*A1_5)+&
        !!h0mpi6c3*(Exp(-x2*b3_1)*A3_1+Exp(-x2*b3_2)*A3_2+Exp(-x2*b3_3)*A3_3+Exp(-x2*b3_4)*A3_4+Exp(-x2*b3_5)*A3_5)
	!
        HartreeV00=0.0_pr
        !
  End Function HartreeV00
  !
  Elemental Function HartreeV01(u)
    !--------------------------------------------------------------------------------
    ! HartreeV(u), E(Hartree)=(1/2)*Int[rho_0(r)*V(|r-r'|)*rho_1(r')]
    !--------------------------------------------------------------------------------
    Implicit None
	Real(pr), Intent(in) :: u 
	Real(pr)             :: x2,HartreeV01 
        !
        HartreeV01=0.0_pr
        !
  End Function HartreeV01
  !
  Elemental Function HartreeV11(u)
    !--------------------------------------------------------------------------------
    ! HartreeV(u), E(Hartree)=(1/2)*Int[rho_1(r)*V(|r-r'|)*rho_1(r')]
    !--------------------------------------------------------------------------------
    Implicit None
	Real(pr), Intent(in) :: u 
	Real(pr)             :: x2,HartreeV11 
        !
        HartreeV11=0.0_pr
        !
  End Function HartreeV11
  !==================================================================================
  !
  !==================================================================================
  Elemental Function ThetaFunction2(u)
    !--------------------------------------------------------------------------------
    ! ThetaFunction2(u)=0 or 1  when x2<2  or x2>2
    !--------------------------------------------------------------------------------
    Implicit None
	Real(pr), Intent(in) :: u 
	Real(pr)             :: x2,ThetaFunction2 
    !
	x2=(u*mpi)
	!
	ThetaFunction2=0.0_pr
	IF(x2.gt.2.0_pr) ThetaFunction2=1.0_pr
	!
  End Function ThetaFunction2
  !================================================================================== 
  !
  !==================================================================================
  Subroutine Make_Parameter_Free_Useful_Combintions()
    !--------------------------------------------------------------------------------
    ! Make Useful combintions
    !--------------------------------------------------------------------------------
    Implicit None
    !
    If (dmeorder.Ge.0) Then
       mpi2=mpi**2
       gA2=gA**2; gA4=gA2**2; gA6=gA2**3; 
       fpi2=fpi**2; fpi4=fpi2**2;        
       CHartree =mevfm*(3.0_pr*gA2)/(32.0_pr*fpi4*Pi**2) 
	   h0mpi6=197.30_pr*(mpi**6)*(3.0_pr*gA*gA)/(32.0_pr*fpi**4*Pi**2)
	   h0mpi6c1=h0mpi6*c1;         h0mpi6c3=h0mpi6*c3	 
       !
	   h0mpi6NM=197.30_pr*(3.0_pr*(mpi**3)*gA2)/(64.0_pr*fpi**4*Sqrt(Pi))
	   h0mpi6c1NM=h0mpi6NM*c1;     h0mpi6c3NM=h0mpi6NM*c3	 
	   !
	   A3_1=42.7132145164590_pr;   A3_2=0.670441422115440_pr; A3_3=0.0525713896514650_pr; 
	   A3_4=0.0012545731701320_pr; A3_5=5.81008627207380_pr
	   b3_1=3.0809379008590_pr;    b3_2=0.905186811964580_pr; b3_3=0.474514509597610_pr; 
	   b3_4=0.228138177966090_pr;  b3_5=1.66931540698090_pr;
	   !
	   A1_1=2.5000830618386_pr;    A1_2=0.619542286897850_pr; A1_3=0.169682589033730_pr;    
	   A1_4=0.0276112113725470_pr; A1_5=0.00108164458809540_pr
	   b1_1=1.75854210706510_pr;   b1_2=0.88882524524657_pr;  b1_3=0.46377235143756_pr;   
	   b1_4=0.247665887704790_pr;  b1_5=0.132222413002680_pr
	   !
	   Call load_tables()
	   !
    Endif
    !
  End Subroutine Make_Parameter_Free_Useful_Combintions
  !==================================================================================
  !  
  !==================================================================================
  Elemental Function Vexternal(t,x,y,z)
    !
    Implicit None
    Integer(ipr), Intent(in) :: t  !! isospin index: 0=isoscalar, 1=isovector
    Real(pr), Intent(in) :: x,y,z  !! position in cartesian basis
    Real(pr) :: Vexternal
    !
    Vexternal = 0.0_pr
    !
  End Function Vexternal
  !
End Module UNEDF
!====================================================================================
!
