!
!                 Set Coulomb interaction
!                 in coordinate space, nuclear case, returns in MeV
!
SUBROUTINE coulomb_integral
  USE constants
  USE wave_functions
  USE relcm_gmatrix
  IMPLICIT NONE
  INTEGER :: n1, n2, lr, i, nrel_max
  REAL(DP) :: oscl_r, int_sum, xr, xp, z, factor1, factor2
  REAL(DP), ALLOCATABLE, DIMENSION(:) :: rr, wrr
  REAL(DP) :: cx(0:200)

  oscl_r=oscl*SQRT(2.0D0)        ! Oscillator parameter for relative
  nrel_max = 400
  ALLOCATE ( rr(nrel_max ), wrr(nrel_max ))
  CALL gauss_legendre(0.d0, 20.d0, rr, wrr, nrel_max )
  DO lr = 0, lmax, 1
     DO n1 = 0, nmax, 1
        factor1 = 0.5D0*((n1+lr+2)*LOG(2.D0)+fac(n1)-dfac(2*n1+2*lr+1)-0.5D0*LOG(pi))
        factor1 = EXP(factor1)
        DO n2 = 0, nmax,1
           IF ( n2 == n1) THEN
              factor2 = factor1
           ELSE
              factor2 = 0.5D0*((n2+lr+2)*LOG(2.D0)+fac(n2)-dfac(2*n2+2*lr+1)-0.5D0*LOG(pi))
              factor2 = EXP(factor2)
           ENDIF
           int_sum = 0.D0
           DO i=1,nrel_max
              z= rr(i)/oscl_r
              CALL laguerre_general( n1, lr+0.5D0, z*z, cx )
              xp = cx(n1)*EXP(-z*z*0.5)*(z**lr)
              IF ( n1 == n2) THEN 
                 xr = xp
              ELSE
                 CALL laguerre_general( n2, lr+0.5D0, z*z, cx )
                 xr = cx(n2)*EXP(-z*z*0.5)*(z**lr)
              ENDIF
              int_sum=int_sum+wrr(i)*rr(i)*xp*xr
           ENDDO
           !  Coulomb energy in MeV or eV
           coulomb_relcom(n2, n1, lr) = int_sum*factor1*factor2*1.439965183D0/(oscl_r**3)
        ENDDO
     ENDDO
  ENDDO
  DEALLOCATE ( rr, wrr)

END SUBROUTINE coulomb_integral



  SUBROUTINE laguerre_general( n, alpha, x, cx )
    IMPLICIT NONE
    INTEGER, INTENT(IN)  :: n
    REAL (dp ) ::  alpha
    REAL ( dp ) :: cx(0:n)
    INTEGER :: i
    REAL ( dp ), INTENT(IN) ::  x

    IF ( alpha <= -1.0D+00 ) THEN
       WRITE ( *, '(a)' ) ' '
       WRITE ( *, '(a)' ) 'LAGUERRE_GENERAL - Fatal error!'
       WRITE ( *, '(a,g14.6)' ) '  The input value of ALPHA is ', alpha
       WRITE ( *, '(a)' ) '  but ALPHA must be greater than -1.'
       STOP
    END IF
    IF ( n < 0 ) THEN
       RETURN
    END IF
    cx(0) = 1.0D+00
    IF ( n == 0 ) THEN
       RETURN
    END IF
    cx(1) = 1.0D+00 + alpha - x
    DO i = 2, n
       cx(i) = ( ( REAL ( 2 * i - 1, kind = 8 ) + alpha - x ) * cx(i-1)   &
            + ( REAL (   - i + 1, kind = 8 ) - alpha     ) * cx(i-2) ) &
            / REAL (     i,     kind = 8 )
    END DO

  END SUBROUTINE laguerre_general

